/*
 * Decompiled with CFR 0.152.
 */
package ce.ajneb97.utils;

import ce.ajneb97.model.EventType;
import ce.ajneb97.model.StoredVariable;
import ce.ajneb97.model.internal.PostEventVariableResult;
import ce.ajneb97.model.internal.VariablesProperties;
import ce.ajneb97.utils.GlobalVariablesUtils;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class VariablesUtilsExperimental {
    private static final Pattern subVariablesPattern = Pattern.compile("\\{([^{}]+)}");

    public static String replaceAllVariablesInLine(String textLine, VariablesProperties variablesProperties) {
        StringBuilder newText = new StringBuilder();
        int pos = 0;
        while (pos < textLine.length()) {
            int indexLast;
            char posChar = textLine.charAt(pos);
            if (posChar == '%' && (indexLast = textLine.indexOf(37, pos + 1)) != -1) {
                String variable = textLine.substring(pos, indexLast + 1);
                String replacedSubVariables = VariablesUtilsExperimental.replaceSubVariables(variable, variablesProperties);
                String finalReplaced = VariablesUtilsExperimental.manageVariableReplacement(replacedSubVariables.substring(1, replacedSubVariables.length() - 1), variablesProperties, false);
                pos = indexLast;
                if (variable.equals(finalReplaced)) {
                    --pos;
                    finalReplaced = finalReplaced.substring(0, finalReplaced.length() - 1);
                }
                ++pos;
                newText.append(finalReplaced);
                continue;
            }
            newText.append(posChar);
            ++pos;
        }
        return newText.toString();
    }

    private static String replaceSubVariables(String input, VariablesProperties variablesProperties) {
        boolean parseOther = input.contains("parseother_");
        Matcher matcher = subVariablesPattern.matcher(input);
        StringBuffer buffer = new StringBuffer();
        for (int finds = 0; matcher.find() && (!parseOther || finds < 1); ++finds) {
            String variable = matcher.group(1);
            String replacement = VariablesUtilsExperimental.manageVariableReplacement(variable, variablesProperties, true);
            if (parseOther && finds == 0) {
                replacement = "{" + replacement + "}";
            }
            matcher.appendReplacement(buffer, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(buffer);
        String replaced = buffer.toString();
        if (!parseOther && !replaced.equals(input)) {
            return VariablesUtilsExperimental.replaceSubVariables(replaced, variablesProperties);
        }
        return replaced;
    }

    private static PostEventVariableResult replaceEventVariablesPost(String variable, VariablesProperties variablesProperties) {
        EventType eventType = variablesProperties.getEvent().getEventType();
        if (eventType.equals((Object)EventType.PLAYER_COMMAND) || eventType.equals((Object)EventType.CONSOLE_COMMAND)) {
            return VariablesUtilsExperimental.replaceCommandEventsVariables(variable, variablesProperties);
        }
        if (eventType.name().startsWith("BLOCK_")) {
            return VariablesUtilsExperimental.replaceBlockEventsVariables(variable, variablesProperties, eventType);
        }
        return PostEventVariableResult.noReplaced();
    }

    private static PostEventVariableResult replaceCommandEventsVariables(String variable, VariablesProperties variablesProperties) {
        if (variable.startsWith("args_substring_")) {
            String variableLR = variable.replace("args_substring_", "");
            String[] variableLRSplit = variableLR.split("-");
            String param1 = variableLRSplit[0];
            String param2 = variableLRSplit[1];
            String finalSubstring = "";
            boolean started = false;
            for (StoredVariable storedVariable : variablesProperties.getEventVariables()) {
                String name = storedVariable.getName();
                String value = storedVariable.getValue();
                if (name.equals("%arg_" + param1 + "%")) {
                    started = true;
                }
                if (!started) continue;
                if (name.equals("%arg_" + param2 + "%")) {
                    finalSubstring = finalSubstring + value;
                    started = false;
                    continue;
                }
                finalSubstring = finalSubstring + value + " ";
            }
            return PostEventVariableResult.replaced(finalSubstring);
        }
        return PostEventVariableResult.noReplaced();
    }

    private static PostEventVariableResult replaceBlockEventsVariables(String variable, VariablesProperties variablesProperties, EventType eventType) {
        Event minecraftEvent = variablesProperties.getMinecraftEvent();
        if (minecraftEvent == null) {
            return PostEventVariableResult.noReplaced();
        }
        Block block = null;
        block = eventType.equals((Object)EventType.BLOCK_INTERACT) ? ((PlayerInteractEvent)minecraftEvent).getClickedBlock() : ((BlockEvent)minecraftEvent).getBlock();
        if (block != null) {
            if (variable.startsWith("block_below_")) {
                int distance = Integer.parseInt(variable.replace("block_below_", ""));
                Location l = block.getLocation().clone().add(0.0, (double)(-distance), 0.0);
                return PostEventVariableResult.replaced(GlobalVariablesUtils.getBlockTypeInLocation(l));
            }
            if (variable.startsWith("block_above_")) {
                int distance = Integer.parseInt(variable.replace("block_above_", ""));
                Location l = block.getLocation().clone().add(0.0, (double)distance, 0.0);
                return PostEventVariableResult.replaced(GlobalVariablesUtils.getBlockTypeInLocation(l));
            }
        }
        return PostEventVariableResult.noReplaced();
    }

    private static String manageVariableReplacement(String variable, VariablesProperties variablesProperties, boolean smallVariable) {
        Player finalPlayer = variablesProperties.getPlayer();
        Player target = variablesProperties.getTarget();
        Player to = variablesProperties.getToTarget();
        if (variable.startsWith("target:") && target != null) {
            finalPlayer = target;
            variable = variable.replace("target:", "");
        } else if (variable.startsWith("to:") && to != null) {
            finalPlayer = to;
            variable = variable.replace("to:", "");
        }
        ArrayList<StoredVariable> eventVariables = variablesProperties.getEventVariables();
        for (StoredVariable storedVariable : eventVariables) {
            if (storedVariable.getValue() == null || !variable.equals(storedVariable.getName().replace("%", ""))) continue;
            return storedVariable.getValue();
        }
        if (variable.equals("player")) {
            return GlobalVariablesUtils.variablePlayer(finalPlayer);
        }
        if (variable.startsWith("playerblock_below_")) {
            return GlobalVariablesUtils.variablePlayerBlockBelow(finalPlayer, variable);
        }
        if (variable.startsWith("playerblock_above_")) {
            return GlobalVariablesUtils.variablePlayerBlockAbove(finalPlayer, variable);
        }
        if (variable.equals("playerblock_inside")) {
            return GlobalVariablesUtils.variablePlayerBlockInside(finalPlayer);
        }
        if (variable.equals("player_is_outside")) {
            return GlobalVariablesUtils.variablePlayerIsOutside(finalPlayer);
        }
        if (variable.equals("random_player")) {
            return GlobalVariablesUtils.variableRandomPlayer();
        }
        if (variable.startsWith("random_player_")) {
            return GlobalVariablesUtils.variableRandomPlayerWorld(variable);
        }
        if (variable.equals("random_last")) {
            return GlobalVariablesUtils.variableLastRandomMinMax();
        }
        if (variable.startsWith("random_")) {
            return GlobalVariablesUtils.variableRandomMinMax(variable);
        }
        if (variable.startsWith("randomword_")) {
            return GlobalVariablesUtils.variableRandomWorld(variable);
        }
        if (variable.startsWith("playerarmor_name_")) {
            return GlobalVariablesUtils.variablePlayerArmorName(finalPlayer, variable);
        }
        if (variable.startsWith("playerarmor_")) {
            return GlobalVariablesUtils.variablePlayerArmorType(finalPlayer, variable);
        }
        if (variable.startsWith("block_at_")) {
            return GlobalVariablesUtils.variableBlockAt(variable);
        }
        if (variable.startsWith("block_data_at_")) {
            return GlobalVariablesUtils.variableBlockDataAt(variable);
        }
        if (variable.startsWith("is_nearby_")) {
            return GlobalVariablesUtils.variableIsNearby(finalPlayer, variable);
        }
        if (variable.startsWith("world_time_")) {
            return GlobalVariablesUtils.variableWorldTime(variable);
        }
        if (variable.equals("world_is_raining")) {
            return GlobalVariablesUtils.variableWorldIsRaining(finalPlayer);
        }
        if (variable.equals("player_attack_cooldown")) {
            return GlobalVariablesUtils.variablePlayerAttackCooldown(finalPlayer);
        }
        if (variable.startsWith("is_number_")) {
            return GlobalVariablesUtils.isNumber(variable);
        }
        if (variable.equals("empty")) {
            return "";
        }
        PostEventVariableResult result = VariablesUtilsExperimental.replaceEventVariablesPost(variable, variablesProperties);
        if (result.isReplaced()) {
            return result.getVariable();
        }
        if (variablesProperties.isPlaceholderAPI()) {
            String variableBefore = variable;
            variable = PlaceholderAPI.setPlaceholders((Player)finalPlayer, (String)("%" + variable + "%"));
            if (!("%" + variableBefore + "%").equals(variable)) {
                return variable;
            }
            variable = variableBefore;
        }
        if (smallVariable) {
            return "{" + variable + "}";
        }
        return "%" + variable + "%";
    }
}

