/*
 * Decompiled with CFR 0.152.
 */
package ce.ajneb97;

import ce.ajneb97.ConditionalEvents;
import ce.ajneb97.configs.MainConfigManager;
import ce.ajneb97.managers.MessagesManager;
import ce.ajneb97.managers.PlayerManager;
import ce.ajneb97.managers.SavedItemsManager;
import ce.ajneb97.model.CEEvent;
import ce.ajneb97.model.EventType;
import ce.ajneb97.model.player.PlayerData;
import ce.ajneb97.utils.ActionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class MainCommand
implements CommandExecutor,
TabCompleter {
    private ConditionalEvents plugin;
    private MainConfigManager mainConfigManager;

    public MainCommand(ConditionalEvents plugin) {
        this.plugin = plugin;
        this.mainConfigManager = plugin.getConfigsManager().getMainConfigManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        FileConfiguration config = this.mainConfigManager.getConfig();
        MessagesManager msgManager = this.plugin.getMessagesManager();
        if (sender.isOp() || sender.hasPermission("conditionalevents.admin")) {
            if (args.length >= 1) {
                if (args[0].equalsIgnoreCase("reload")) {
                    if (!this.plugin.getConfigsManager().reload()) {
                        sender.sendMessage(ConditionalEvents.prefix + MessagesManager.getColoredMessage(" &cThere was an error reloading the config, check the console."));
                        return true;
                    }
                    msgManager.sendMessage(sender, config.getString("Messages.commandReload"), true);
                } else if (args[0].equalsIgnoreCase("help")) {
                    MainCommand.help(sender);
                } else if (args[0].equalsIgnoreCase("reset")) {
                    this.reset(args, sender, config, msgManager);
                } else if (args[0].equalsIgnoreCase("enable")) {
                    this.enable(args, sender, config, msgManager);
                } else if (args[0].equalsIgnoreCase("disable")) {
                    this.disable(args, sender, config, msgManager);
                } else if (args[0].equalsIgnoreCase("debug")) {
                    this.debug(args, sender, config, msgManager);
                } else if (args[0].equalsIgnoreCase("verify")) {
                    if (sender instanceof Player) {
                        this.plugin.getVerifyManager().sendVerification((Player)sender);
                    } else {
                        msgManager.sendMessage(sender, config.getString("Messages.onlyPlayerCommand"), true);
                    }
                } else if (args[0].equalsIgnoreCase("call")) {
                    this.call(args, sender, config, msgManager);
                } else if (args[0].equalsIgnoreCase("item")) {
                    if (sender instanceof Player) {
                        this.item(args, (Player)sender, config, msgManager);
                    } else {
                        msgManager.sendMessage(sender, config.getString("Messages.onlyPlayerCommand"), true);
                    }
                } else if (args[0].equalsIgnoreCase("interrupt")) {
                    this.interrupt(args, sender, config, msgManager);
                } else {
                    MainCommand.help(sender);
                }
            } else {
                MainCommand.help(sender);
            }
        } else {
            msgManager.sendMessage(sender, config.getString("Messages.commandNoPermissions"), true);
        }
        return true;
    }

    public void reset(String[] args, CommandSender sender, FileConfiguration config, MessagesManager msgManager) {
        if (args.length <= 2) {
            msgManager.sendMessage(sender, config.getString("Messages.commandResetError"), true);
            return;
        }
        String player = args[1];
        String eventName = args[2];
        PlayerManager playerManager = this.plugin.getPlayerManager();
        PlayerData playerData = playerManager.getPlayerDataByName(player);
        if (!player.equals("*") && playerData == null) {
            msgManager.sendMessage(sender, config.getString("Messages.playerDoesNotExists"), true);
            return;
        }
        if (eventName.equals("all")) {
            if (player.equals("*")) {
                playerManager.resetAllDataForPlayers();
                msgManager.sendMessage(sender, config.getString("Messages.eventDataResetAllForAllPlayers"), true);
            } else {
                playerData.resetAll();
                msgManager.sendMessage(sender, config.getString("Messages.eventDataResetAll").replace("%player%", player), true);
            }
        } else {
            CEEvent e = this.plugin.getEventsManager().getEvent(eventName);
            if (e == null) {
                msgManager.sendMessage(sender, config.getString("Messages.eventDoesNotExists"), true);
                return;
            }
            if (player.equals("*")) {
                playerManager.resetEventDataForPlayers(eventName);
                msgManager.sendMessage(sender, config.getString("Messages.eventDataResetForAllPlayers").replace("%event%", eventName), true);
            } else {
                playerData.resetCooldown(eventName);
                playerData.setOneTime(eventName, false);
                msgManager.sendMessage(sender, config.getString("Messages.eventDataReset").replace("%player%", player).replace("%event%", eventName), true);
            }
        }
    }

    public void enable(String[] args, CommandSender sender, FileConfiguration config, MessagesManager msgManager) {
        if (args.length <= 1) {
            msgManager.sendMessage(sender, config.getString("Messages.eventEnableError"), true);
            return;
        }
        String eventName = args[1];
        CEEvent e = this.plugin.getEventsManager().getEvent(eventName);
        if (e == null) {
            msgManager.sendMessage(sender, config.getString("Messages.eventDoesNotExists"), true);
            return;
        }
        e.enable();
        this.plugin.getConfigsManager().saveEvent(e);
        msgManager.sendMessage(sender, config.getString("Messages.eventEnabled").replace("%event%", eventName), true);
    }

    public void disable(String[] args, CommandSender sender, FileConfiguration config, MessagesManager msgManager) {
        if (args.length <= 1) {
            msgManager.sendMessage(sender, config.getString("Messages.eventDisableError"), true);
            return;
        }
        String eventName = args[1];
        CEEvent e = this.plugin.getEventsManager().getEvent(eventName);
        if (e == null) {
            msgManager.sendMessage(sender, config.getString("Messages.eventDoesNotExists"), true);
            return;
        }
        e.disable();
        this.plugin.getInterruptEventManager().interruptEvent(eventName, null);
        this.plugin.getConfigsManager().saveEvent(e);
        msgManager.sendMessage(sender, config.getString("Messages.eventDisabled").replace("%event%", eventName), true);
    }

    public void debug(String[] args, CommandSender sender, FileConfiguration config, MessagesManager msgManager) {
        boolean result;
        if (args.length <= 1) {
            msgManager.sendMessage(sender, config.getString("Messages.commandDebugError"), true);
            return;
        }
        String eventName = args[1];
        CEEvent e = this.plugin.getEventsManager().getEvent(eventName);
        if (e == null) {
            msgManager.sendMessage(sender, config.getString("Messages.eventDoesNotExists"), true);
            return;
        }
        String playerName = null;
        if (args.length >= 3) {
            playerName = args[2];
        }
        if (result = this.plugin.getDebugManager().setDebugSender(sender, eventName, playerName)) {
            if (playerName != null) {
                msgManager.sendMessage(sender, config.getString("Messages.debugEnabledPlayer").replace("%event%", eventName).replace("%player%", playerName), true);
            } else {
                msgManager.sendMessage(sender, config.getString("Messages.debugEnabled").replace("%event%", eventName), true);
            }
        } else if (playerName != null) {
            msgManager.sendMessage(sender, config.getString("Messages.debugDisabledPlayer").replace("%event%", eventName).replace("%player%", playerName), true);
        } else {
            msgManager.sendMessage(sender, config.getString("Messages.debugDisabled").replace("%event%", eventName), true);
        }
    }

    public void call(String[] args, CommandSender sender, FileConfiguration config, MessagesManager msgManager) {
        if (args.length <= 1) {
            msgManager.sendMessage(sender, config.getString("Messages.commandCallError"), true);
            return;
        }
        String eventName = args[1];
        CEEvent e = this.plugin.getEventsManager().getEvent(eventName);
        if (e == null) {
            msgManager.sendMessage(sender, config.getString("Messages.eventDoesNotExists"), true);
            return;
        }
        if (!e.getEventType().equals((Object)EventType.CALL)) {
            msgManager.sendMessage(sender, config.getString("Messages.commandCallInvalidEvent"), true);
            return;
        }
        String actionLine = eventName;
        String playerName = null;
        boolean silent = false;
        if (args.length >= 3) {
            for (int i = 2; i < args.length; ++i) {
                String arg = args[i];
                if (arg.contains("%")) {
                    actionLine = actionLine + ";" + args[i];
                    continue;
                }
                if (arg.startsWith("player:")) {
                    playerName = args[i].replace("player:", "");
                    continue;
                }
                if (!args[i].equals("silent:true")) continue;
                silent = true;
            }
        }
        Player player = null;
        if (playerName != null) {
            player = Bukkit.getPlayer(playerName);
            if (player == null) {
                msgManager.sendMessage(sender, config.getString("Messages.playerNotOnline"), true);
                return;
            }
        } else if (sender instanceof Player) {
            player = (Player)sender;
        }
        if (ActionUtils.callEvent(actionLine, player, this.plugin, null)) {
            if (silent) {
                return;
            }
            if (player != null) {
                msgManager.sendMessage(sender, config.getString("Messages.commandCallCorrectPlayer").replace("%event%", eventName).replace("%player%", player.getName()), true);
            } else {
                msgManager.sendMessage(sender, config.getString("Messages.commandCallCorrect").replace("%event%", eventName), true);
            }
        } else {
            if (silent) {
                return;
            }
            msgManager.sendMessage(sender, config.getString("Messages.commandCallFailed").replace("%event%", eventName), true);
        }
    }

    public void item(String[] args, Player player, FileConfiguration config, MessagesManager msgManager) {
        if (args.length <= 2) {
            msgManager.sendMessage((CommandSender)player, config.getString("Messages.commandItemError"), true);
            return;
        }
        SavedItemsManager savedItemsManager = this.plugin.getSavedItemsManager();
        String type = args[1];
        String name = args[2];
        if (type.equals("save")) {
            if (savedItemsManager.getItem(name, player) != null) {
                msgManager.sendMessage((CommandSender)player, config.getString("Messages.savedItemAlreadyExists"), true);
                return;
            }
            ItemStack item = player.getItemInHand();
            if (item == null || item.getType().equals((Object)Material.AIR)) {
                msgManager.sendMessage((CommandSender)player, config.getString("Messages.mustHaveItemInHand"), true);
                return;
            }
            savedItemsManager.addItem(name, item.clone());
            msgManager.sendMessage((CommandSender)player, config.getString("Messages.savedItemAdded").replace("%name%", name), true);
        } else if (type.equals("remove")) {
            if (savedItemsManager.getItem(name, player) == null) {
                msgManager.sendMessage((CommandSender)player, config.getString("Messages.savedItemDoesNotExists"), true);
                return;
            }
            savedItemsManager.removeItem(name);
            msgManager.sendMessage((CommandSender)player, config.getString("Messages.savedItemRemoved").replace("%name%", name), true);
        } else {
            msgManager.sendMessage((CommandSender)player, config.getString("Messages.commandItemError"), true);
        }
    }

    public void interrupt(String[] args, CommandSender sender, FileConfiguration config, MessagesManager msgManager) {
        if (args.length <= 1) {
            msgManager.sendMessage(sender, config.getString("Messages.commandInterruptError"), true);
            return;
        }
        String eventName = args[1];
        CEEvent e = this.plugin.getEventsManager().getEvent(eventName);
        if (e == null) {
            msgManager.sendMessage(sender, config.getString("Messages.eventDoesNotExists"), true);
            return;
        }
        String playerName = null;
        if (args.length >= 3) {
            playerName = args[2];
        }
        this.plugin.getInterruptEventManager().interruptEvent(eventName, playerName);
        if (playerName == null) {
            msgManager.sendMessage(sender, config.getString("Messages.commandInterruptCorrect").replace("%event%", eventName), true);
        } else {
            msgManager.sendMessage(sender, config.getString("Messages.commandInterruptCorrectPlayer").replace("%event%", eventName).replace("%player%", playerName), true);
        }
    }

    public static void help(CommandSender sender) {
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7[ [ &8[&bConditionalEvents&8] &7] ]"));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)""));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&6/ce help &8Shows this message."));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&6/ce reload &8Reloads the config."));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&6/ce verify &8Checks ALL events for errors."));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&6/ce debug <event> (optional)<player> &8Enables/disables debug information for an event."));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&6/ce reset <player>/* <event>/all &8Resets an event data for a player."));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&6/ce enable/disable <event> &8Enable or disables an event."));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&6/ce call <event> (optional)%variable1%=<value1>;%variableN%=<valueN> (optional)player:<player> (optional)silent:true &8Executes a 'call' event."));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&6/ce item <save/remove> <name> &8Save and remove items for some actions."));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&6/ce interrupt <event> (optional)<player> &8Stops the execution of actions for an event."));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)""));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7[ [ &8[&bConditionalEvents&8] &7] ]"));
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (sender.isOp() || sender.hasPermission("conditionalevents.admin")) {
            if (args.length == 1) {
                ArrayList<String> completions = new ArrayList<String>();
                ArrayList<String> commands = new ArrayList<String>();
                commands.add("help");
                commands.add("reload");
                commands.add("verify");
                commands.add("reset");
                commands.add("debug");
                commands.add("enable");
                commands.add("disable");
                commands.add("call");
                commands.add("item");
                commands.add("interrupt");
                for (String c : commands) {
                    if (!args[0].isEmpty() && !c.startsWith(args[0].toLowerCase())) continue;
                    completions.add(c);
                }
                return completions;
            }
            if ((args[0].equalsIgnoreCase("debug") || args[0].equalsIgnoreCase("enable") || args[0].equalsIgnoreCase("disable") || args[0].equalsIgnoreCase("interrupt")) && args.length == 2) {
                return this.getEventsCompletions(args, 1, false, null);
            }
            if (args[0].equalsIgnoreCase("call") && args.length == 2) {
                return this.getEventsCompletions(args, 1, false, EventType.CALL);
            }
            if (args[0].equalsIgnoreCase("reset") && args.length == 3) {
                return this.getEventsCompletions(args, 2, true, null);
            }
            if (args[0].equalsIgnoreCase("reset") && args.length == 2) {
                ArrayList<String> completions = new ArrayList<String>();
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (!args[1].isEmpty() && !p.getName().toLowerCase().startsWith(args[1].toLowerCase())) continue;
                    completions.add(p.getName());
                }
                if (args[1].isEmpty() || "*".startsWith(args[1].toLowerCase())) {
                    completions.add("*");
                }
                return completions;
            }
            if (args[0].equalsIgnoreCase("item") && args.length == 2) {
                ArrayList<String> completions = new ArrayList<String>();
                completions.add("remove");
                completions.add("save");
                return completions;
            }
            if (args.length == 3 && args[0].equalsIgnoreCase("item") && args[1].equalsIgnoreCase("remove")) {
                return this.getSavedItemsCompletions(args, 2);
            }
        }
        return null;
    }

    public List<String> getEventsCompletions(String[] args, int argEventPos, boolean addAll, EventType eventType) {
        ArrayList<String> completions = new ArrayList<String>();
        String argEvent = args[argEventPos];
        if (addAll && (argEvent.isEmpty() || "all".startsWith(argEvent.toLowerCase()))) {
            completions.add("all");
        }
        ArrayList<CEEvent> events = this.plugin.getEventsManager().getEvents();
        for (CEEvent event : events) {
            if (!argEvent.isEmpty() && !event.getName().toLowerCase().startsWith(argEvent.toLowerCase())) continue;
            if (eventType != null) {
                if (!event.getEventType().equals((Object)eventType)) continue;
                completions.add(event.getName());
                continue;
            }
            completions.add(event.getName());
        }
        if (completions.isEmpty()) {
            return null;
        }
        return completions;
    }

    public List<String> getSavedItemsCompletions(String[] args, int argItemPos) {
        ArrayList<String> completions = new ArrayList<String>();
        String argItem = args[argItemPos];
        for (Map.Entry<String, ItemStack> entry : this.plugin.getSavedItemsManager().getSavedItems().entrySet()) {
            if (!argItem.isEmpty() && !entry.getKey().toLowerCase().startsWith(argItem.toLowerCase())) continue;
            completions.add(entry.getKey());
        }
        if (completions.isEmpty()) {
            return null;
        }
        return completions;
    }
}

