/*
 * Decompiled with CFR 0.152.
 */
package ce.ajneb97.managers;

import ce.ajneb97.ConditionalEvents;
import ce.ajneb97.api.ConditionalEventsAction;
import ce.ajneb97.managers.MessagesManager;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.java.JavaPlugin;

public class APIManager {
    private ConditionalEvents plugin;
    private ArrayList<ConditionalEventsAction> apiActions;

    public APIManager(ConditionalEvents plugin) {
        this.plugin = plugin;
        this.apiActions = new ArrayList();
    }

    public void registerApiActions(JavaPlugin plugin, ConditionalEventsAction ... actions) {
        for (ConditionalEventsAction a : actions) {
            a.setPlugin(plugin);
            Bukkit.getConsoleSender().sendMessage(ConditionalEvents.prefix + MessagesManager.getColoredMessage(" &7Custom API Action &a" + a.getName() + " &7registered from plugin &e" + a.getPlugin().getName()));
            this.apiActions.add(a);
        }
        this.plugin.getConfigsManager().endRepetitiveEvents();
        this.plugin.getConfigsManager().configureEvents();
        this.plugin.getVerifyManager().verifyEvents();
    }

    public void unregisterApiActions(JavaPlugin plugin) {
        this.apiActions.removeIf(a -> a.getPlugin() == plugin);
        this.plugin.getConfigsManager().endRepetitiveEvents();
        this.plugin.getConfigsManager().configureEvents();
        this.plugin.getVerifyManager().verifyEvents();
    }

    public ConditionalEventsAction getApiAction(String actionName) {
        for (ConditionalEventsAction action : this.apiActions) {
            if (!action.getName().equals(actionName)) continue;
            return action;
        }
        return null;
    }

    public void executeAction(String actionName, Player player, String actionLine, Event minecraftEvent) {
        ConditionalEventsAction action = this.getApiAction(actionName);
        if (action != null) {
            action.execute(player, actionLine, minecraftEvent);
        }
    }
}

