/*
 * Decompiled with CFR 0.152.
 */
package ce.ajneb97.managers;

import ce.ajneb97.ConditionalEvents;
import ce.ajneb97.managers.DebugManager;
import ce.ajneb97.managers.MessagesManager;
import ce.ajneb97.managers.PlayerManager;
import ce.ajneb97.model.CEEvent;
import ce.ajneb97.model.ConditionalType;
import ce.ajneb97.model.EventType;
import ce.ajneb97.model.StoredVariable;
import ce.ajneb97.model.internal.CheckConditionsResult;
import ce.ajneb97.model.internal.ConditionEvent;
import ce.ajneb97.model.internal.ExecutedEvent;
import ce.ajneb97.model.internal.SeparatorType;
import ce.ajneb97.model.internal.VariablesProperties;
import ce.ajneb97.utils.MathUtils;
import ce.ajneb97.utils.TimeUtils;
import ce.ajneb97.utils.VariablesUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;

public class EventsManager {
    private ConditionalEvents plugin;
    private ArrayList<CEEvent> events;

    public EventsManager(ConditionalEvents plugin) {
        this.plugin = plugin;
        this.events = new ArrayList();
    }

    public void setEvents(ArrayList<CEEvent> events) {
        this.events = events;
    }

    public ArrayList<CEEvent> getEvents() {
        return this.events;
    }

    public CEEvent getEvent(String name) {
        for (CEEvent event : this.events) {
            if (!event.getName().equals(name)) continue;
            return event;
        }
        return null;
    }

    public void checkEvent(ConditionEvent conditionEvent) {
        ArrayList<CEEvent> validEvents = this.getValidEvents(conditionEvent.getEventType());
        for (CEEvent event : validEvents) {
            this.checkSingularEvent(conditionEvent, event);
        }
    }

    public void checkSingularEvent(ConditionEvent conditionEvent, CEEvent event) {
        Cancellable c;
        Event minecraftEvent;
        Player player = conditionEvent.getPlayer();
        boolean isPlaceholderAPI = this.plugin.getDependencyManager().isPlaceholderAPI();
        conditionEvent.setCurrentEvent(event);
        if (player != null && event.getIgnoreWithPermission() != null && player.hasPermission(event.getIgnoreWithPermission())) {
            return;
        }
        if (event.isIgnoreIfCancelled() && (minecraftEvent = conditionEvent.getMinecraftEvent()) instanceof Cancellable && (c = (Cancellable)minecraftEvent).isCancelled()) {
            return;
        }
        CheckConditionsResult conditionsResult = this.checkConditions(conditionEvent, isPlaceholderAPI);
        if (!conditionsResult.isConditionsAccomplished()) {
            return;
        }
        String executeActionGroup = conditionsResult.getExecuteActionGroup();
        PlayerManager playerManager = this.plugin.getPlayerManager();
        MessagesManager messagesManager = this.plugin.getMessagesManager();
        boolean bypassCooldown = false;
        if (player != null) {
            long currentTimeMillis;
            long eventCooldownMillis;
            boolean isOneTime;
            bypassCooldown = player.hasPermission("conditionalevents.bypasscooldown." + event.getName());
            if (event.isOneTime() && (isOneTime = playerManager.getEventOneTime(event.getName(), player))) {
                ExecutedEvent executedEvent = new ExecutedEvent(player, conditionEvent.getEventVariables(), event, "one_time", conditionEvent.getMinecraftEvent(), conditionEvent.getTarget(), this.plugin);
                executedEvent.executeActions();
                return;
            }
            if (event.getCooldown() != 0L && !bypassCooldown && (eventCooldownMillis = playerManager.getEventCooldown(event.getName(), player) + event.getCooldown() * 1000L) > (currentTimeMillis = System.currentTimeMillis())) {
                String timeString = TimeUtils.getTime((eventCooldownMillis - currentTimeMillis) / 1000L, messagesManager);
                conditionEvent.getEventVariables().add(new StoredVariable("%time%", timeString));
                ExecutedEvent executedEvent = new ExecutedEvent(player, conditionEvent.getEventVariables(), event, "cooldown", conditionEvent.getMinecraftEvent(), conditionEvent.getTarget(), this.plugin);
                executedEvent.executeActions();
                return;
            }
        }
        if (player != null) {
            String actionGroupWithoutParameters = executeActionGroup;
            int pos = actionGroupWithoutParameters.indexOf("{");
            if (pos != -1) {
                actionGroupWithoutParameters = actionGroupWithoutParameters.substring(0, pos);
            }
            if (event.isOneTime() && !event.getPreventOneTimeActivationActionGroups().contains(actionGroupWithoutParameters)) {
                playerManager.setEventOneTime(event.getName(), player);
            }
            if (event.getCooldown() != 0L && !bypassCooldown && !event.getPreventCooldownActivationActionGroups().contains(actionGroupWithoutParameters)) {
                playerManager.setEventCooldown(event.getName(), player);
            }
        }
        ExecutedEvent executedEvent = new ExecutedEvent(player, conditionEvent.getEventVariables(), event, executeActionGroup, conditionEvent.getMinecraftEvent(), conditionEvent.getTarget(), this.plugin);
        executedEvent.executeActions();
    }

    public ArrayList<CEEvent> getValidEvents(EventType eventType) {
        ArrayList<CEEvent> validEvents = new ArrayList<CEEvent>();
        for (CEEvent event : this.events) {
            if (!event.getEventType().equals((Object)eventType) || !event.isEnabled()) continue;
            validEvents.add(event);
        }
        return validEvents;
    }

    public ArrayList<CEEvent> getEventsByType(EventType eventType) {
        ArrayList<CEEvent> validEvents = new ArrayList<CEEvent>();
        for (CEEvent event : this.events) {
            if (!event.getEventType().equals((Object)eventType)) continue;
            validEvents.add(event);
        }
        return validEvents;
    }

    private CheckConditionsResult checkConditions(ConditionEvent conditionEvent, boolean isPlaceholderAPI) {
        ArrayList<String> conditions = new ArrayList<String>(conditionEvent.getCurrentEvent().getConditions());
        String eventName = conditionEvent.getCurrentEvent().getName();
        Player player = conditionEvent.getPlayer();
        Player target = conditionEvent.getTarget();
        CEEvent event = conditionEvent.getCurrentEvent();
        Event minecraftEvent = conditionEvent.getMinecraftEvent();
        DebugManager debugManager = this.plugin.getDebugManager();
        boolean mathFormulas = conditionEvent.getCurrentEvent().isAllowMathFormulasInConditions();
        ArrayList<StoredVariable> storedVariables = conditionEvent.getEventVariables();
        for (int i = 0; i < conditions.size(); ++i) {
            String conditionLine = (String)conditions.get(i);
            boolean approvedLine = false;
            String executedActionGroup = null;
            if (conditionLine.contains(" execute ")) {
                String[] sep = conditionLine.split(" execute ");
                conditionLine = sep[0];
                executedActionGroup = sep[1];
            }
            String[] separatedConditions = null;
            SeparatorType separatorType = SeparatorType.NONE;
            if (conditionLine.contains(" or ")) {
                separatedConditions = conditionLine.split(" or ");
                separatorType = SeparatorType.OR;
            } else if (conditionLine.contains(" and ")) {
                separatedConditions = conditionLine.split(" and ");
                separatorType = SeparatorType.AND;
            } else {
                separatedConditions = new String[]{conditionLine};
            }
            String conditionLineWithReplacements = "";
            for (int c = 0; c < separatedConditions.length; ++c) {
                String miniCondition = separatedConditions[c];
                for (ConditionalType conditionalType : ConditionalType.values()) {
                    String textToFind = " " + conditionalType.getText() + " ";
                    if (miniCondition.contains(textToFind)) {
                        int textToFindIndex = miniCondition.indexOf(textToFind);
                        String arg1 = miniCondition.substring(0, textToFindIndex);
                        String arg2 = miniCondition.substring(textToFindIndex + conditionalType.getText().length() + 2);
                        VariablesProperties variablesProperties = new VariablesProperties(storedVariables, player, target, isPlaceholderAPI, event, minecraftEvent);
                        arg1 = VariablesUtils.replaceAllVariablesInLine(arg1, variablesProperties, false);
                        arg2 = VariablesUtils.replaceAllVariablesInLine(arg2, variablesProperties, false);
                        String firstArg = !mathFormulas ? arg1 : MathUtils.calculate(arg1);
                        String secondArg = !mathFormulas ? arg2 : MathUtils.calculate(arg2);
                        conditionLineWithReplacements = conditionLineWithReplacements + "'" + firstArg + "'" + textToFind + "'" + secondArg + "'";
                        if (c != separatedConditions.length - 1) {
                            if (separatorType.equals((Object)SeparatorType.OR)) {
                                conditionLineWithReplacements = conditionLineWithReplacements + " or ";
                            } else if (separatorType.equals((Object)SeparatorType.AND)) {
                                conditionLineWithReplacements = conditionLineWithReplacements + " and ";
                            }
                        }
                        String firstArgLower = firstArg.toLowerCase();
                        String secondArgLower = secondArg.toLowerCase();
                        double firstArgNum = 0.0;
                        double secondArgNum = 0.0;
                        if (MathUtils.isParsable(firstArg)) {
                            firstArgNum = Double.parseDouble(firstArg);
                        }
                        if (MathUtils.isParsable(secondArg)) {
                            secondArgNum = Double.parseDouble(secondArg);
                        }
                        switch (conditionalType) {
                            case EQUALS: 
                            case EQUALS_LEGACY: {
                                if (!firstArg.equals(secondArg)) break;
                                approvedLine = true;
                                break;
                            }
                            case NOT_EQUALS: 
                            case NOT_EQUALS_LEGACY: {
                                if (firstArg.equals(secondArg)) break;
                                approvedLine = true;
                                break;
                            }
                            case EQUALS_IGNORE_CASE: {
                                if (!firstArg.equalsIgnoreCase(secondArg)) break;
                                approvedLine = true;
                                break;
                            }
                            case NOT_EQUALS_IGNORE_CASE: {
                                if (firstArg.equalsIgnoreCase(secondArg)) break;
                                approvedLine = true;
                                break;
                            }
                            case STARTS_WITH: {
                                if (!firstArgLower.startsWith(secondArgLower)) break;
                                approvedLine = true;
                                break;
                            }
                            case NOT_STARTS_WITH: {
                                if (firstArgLower.startsWith(secondArgLower)) break;
                                approvedLine = true;
                                break;
                            }
                            case CONTAINS: {
                                if (!firstArgLower.contains(secondArgLower)) break;
                                approvedLine = true;
                                break;
                            }
                            case NOT_CONTAINS: {
                                if (firstArgLower.contains(secondArgLower)) break;
                                approvedLine = true;
                                break;
                            }
                            case ENDS_WITH: {
                                if (!firstArgLower.endsWith(secondArgLower)) break;
                                approvedLine = true;
                                break;
                            }
                            case NOT_ENDS_WITH: {
                                if (firstArgLower.endsWith(secondArgLower)) break;
                                approvedLine = true;
                                break;
                            }
                            case MATCHES: {
                                if (!firstArgLower.matches(secondArgLower)) break;
                                approvedLine = true;
                                break;
                            }
                            case NOT_MATCHES: {
                                if (firstArgLower.matches(secondArgLower)) break;
                                approvedLine = true;
                                break;
                            }
                            case GREATER: {
                                if (!(firstArgNum > secondArgNum)) break;
                                approvedLine = true;
                                break;
                            }
                            case GREATER_EQUALS: {
                                if (!(firstArgNum >= secondArgNum)) break;
                                approvedLine = true;
                                break;
                            }
                            case LOWER: {
                                if (!(firstArgNum < secondArgNum)) break;
                                approvedLine = true;
                                break;
                            }
                            case LOWER_EQUALS: {
                                if (!(firstArgNum <= secondArgNum)) break;
                                approvedLine = true;
                            }
                        }
                    }
                    if (approvedLine) break;
                }
                if (separatorType.equals((Object)SeparatorType.AND)) {
                    if (!approvedLine) break;
                    if (c == separatedConditions.length - 1) continue;
                    approvedLine = false;
                    continue;
                }
                if (approvedLine) break;
            }
            debugManager.sendConditionMessage(eventName, conditionLineWithReplacements, approvedLine, conditionEvent.getPlayer(), i == 0);
            if (!approvedLine) {
                if (executedActionGroup != null) continue;
                return new CheckConditionsResult(false, null);
            }
            if (!approvedLine || executedActionGroup == null) continue;
            debugManager.sendActionsMessage(eventName, executedActionGroup, conditionEvent.getPlayer());
            return new CheckConditionsResult(true, executedActionGroup);
        }
        debugManager.sendActionsMessage(eventName, "default", conditionEvent.getPlayer());
        return new CheckConditionsResult(true, null);
    }

    public boolean checkToConditionAction(List<String> conditionGroup, Player player, boolean isPlaceholderAPI, CEEvent event, Event minecraftEvent) {
        boolean mathFormulas = event.isAllowMathFormulasInConditions();
        for (int i = 0; i < conditionGroup.size(); ++i) {
            String conditionLine = conditionGroup.get(i);
            boolean approvedLine = false;
            ArrayList<StoredVariable> storedVariables = new ArrayList<StoredVariable>();
            String[] separatedConditions = null;
            SeparatorType separatorType = SeparatorType.NONE;
            if (conditionLine.contains(" or ")) {
                separatedConditions = conditionLine.split(" or ");
                separatorType = SeparatorType.OR;
            } else if (conditionLine.contains(" and ")) {
                separatedConditions = conditionLine.split(" and ");
                separatorType = SeparatorType.AND;
            } else {
                separatedConditions = new String[]{conditionLine};
            }
            for (int c = 0; c < separatedConditions.length; ++c) {
                String miniCondition = separatedConditions[c];
                for (ConditionalType conditionalType : ConditionalType.values()) {
                    String textToFind = " " + conditionalType.getText() + " ";
                    if (miniCondition.contains(textToFind)) {
                        int textToFindIndex = miniCondition.indexOf(textToFind);
                        String arg1 = miniCondition.substring(0, textToFindIndex);
                        String arg2 = miniCondition.substring(textToFindIndex + conditionalType.getText().length() + 2);
                        VariablesProperties variablesProperties = new VariablesProperties(storedVariables, player, null, isPlaceholderAPI, event, minecraftEvent);
                        arg1 = VariablesUtils.replaceAllVariablesInLine(arg1, variablesProperties, false);
                        arg2 = VariablesUtils.replaceAllVariablesInLine(arg2, variablesProperties, false);
                        String firstArg = !mathFormulas ? arg1 : MathUtils.calculate(arg1);
                        String secondArg = !mathFormulas ? arg2 : MathUtils.calculate(arg2);
                        String firstArgLower = firstArg.toLowerCase();
                        String secondArgLower = secondArg.toLowerCase();
                        double firstArgNum = 0.0;
                        double secondArgNum = 0.0;
                        if (MathUtils.isParsable(firstArg)) {
                            firstArgNum = Double.parseDouble(firstArg);
                        }
                        if (MathUtils.isParsable(secondArg)) {
                            secondArgNum = Double.parseDouble(secondArg);
                        }
                        switch (conditionalType) {
                            case EQUALS: 
                            case EQUALS_LEGACY: {
                                if (!firstArg.equals(secondArg)) break;
                                approvedLine = true;
                                break;
                            }
                            case NOT_EQUALS: 
                            case NOT_EQUALS_LEGACY: {
                                if (firstArg.equals(secondArg)) break;
                                approvedLine = true;
                                break;
                            }
                            case EQUALS_IGNORE_CASE: {
                                if (!firstArg.equalsIgnoreCase(secondArg)) break;
                                approvedLine = true;
                                break;
                            }
                            case NOT_EQUALS_IGNORE_CASE: {
                                if (firstArg.equalsIgnoreCase(secondArg)) break;
                                approvedLine = true;
                                break;
                            }
                            case STARTS_WITH: {
                                if (!firstArgLower.startsWith(secondArgLower)) break;
                                approvedLine = true;
                                break;
                            }
                            case NOT_STARTS_WITH: {
                                if (firstArgLower.startsWith(secondArgLower)) break;
                                approvedLine = true;
                                break;
                            }
                            case CONTAINS: {
                                if (!firstArgLower.contains(secondArgLower)) break;
                                approvedLine = true;
                                break;
                            }
                            case NOT_CONTAINS: {
                                if (firstArgLower.contains(secondArgLower)) break;
                                approvedLine = true;
                                break;
                            }
                            case ENDS_WITH: {
                                if (!firstArgLower.endsWith(secondArgLower)) break;
                                approvedLine = true;
                                break;
                            }
                            case NOT_ENDS_WITH: {
                                if (firstArgLower.endsWith(secondArgLower)) break;
                                approvedLine = true;
                                break;
                            }
                            case MATCHES: {
                                if (!firstArgLower.matches(secondArgLower)) break;
                                approvedLine = true;
                                break;
                            }
                            case NOT_MATCHES: {
                                if (firstArgLower.matches(secondArgLower)) break;
                                approvedLine = true;
                                break;
                            }
                            case GREATER: {
                                if (!(firstArgNum > secondArgNum)) break;
                                approvedLine = true;
                                break;
                            }
                            case GREATER_EQUALS: {
                                if (!(firstArgNum >= secondArgNum)) break;
                                approvedLine = true;
                                break;
                            }
                            case LOWER: {
                                if (!(firstArgNum < secondArgNum)) break;
                                approvedLine = true;
                                break;
                            }
                            case LOWER_EQUALS: {
                                if (!(firstArgNum <= secondArgNum)) break;
                                approvedLine = true;
                            }
                        }
                    }
                    if (approvedLine) break;
                }
                if (separatorType.equals((Object)SeparatorType.AND)) {
                    if (!approvedLine) break;
                    if (c == separatedConditions.length - 1) continue;
                    approvedLine = false;
                    continue;
                }
                if (approvedLine) break;
            }
            if (approvedLine) continue;
            return false;
        }
        return true;
    }
}

