/*
 * Decompiled with CFR 0.152.
 */
package ce.ajneb97.managers;

import ce.ajneb97.ConditionalEvents;
import ce.ajneb97.utils.OtherUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SavedItemsManager {
    private ConditionalEvents plugin;
    private Map<String, ItemStack> savedItems;

    public SavedItemsManager(ConditionalEvents plugin) {
        this.plugin = plugin;
        this.savedItems = new HashMap<String, ItemStack>();
    }

    public Map<String, ItemStack> getSavedItems() {
        return this.savedItems;
    }

    public void setSavedItems(Map<String, ItemStack> savedItems) {
        this.savedItems = savedItems;
    }

    public ItemStack getItem(String name, Player player) {
        if (!this.savedItems.containsKey(name)) {
            return null;
        }
        ItemStack item = this.savedItems.get(name).clone();
        if (player == null) {
            return item;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta.hasDisplayName()) {
            String displayName = OtherUtils.replaceGlobalVariables(meta.getDisplayName(), player, this.plugin);
            meta.setDisplayName(displayName);
        }
        if (meta.hasLore()) {
            List lore = meta.getLore();
            lore.replaceAll(text -> OtherUtils.replaceGlobalVariables(text, player, this.plugin));
            meta.setLore(lore);
        }
        item.setItemMeta(meta);
        return item;
    }

    public void addItem(String name, ItemStack item) {
        this.savedItems.put(name, item);
        this.plugin.getConfigsManager().getSavedItemsConfigManager().saveItem(name, item);
    }

    public void removeItem(String name) {
        this.savedItems.remove(name);
        this.plugin.getConfigsManager().getSavedItemsConfigManager().removeItem(name);
    }
}

