/*
 * Decompiled with CFR 0.152.
 */
package ce.ajneb97.utils;

import ce.ajneb97.ConditionalEvents;
import ce.ajneb97.api.ConditionalEventsAPI;
import ce.ajneb97.api.ConditionalEventsCallEvent;
import ce.ajneb97.libs.actionbar.ActionBarAPI;
import ce.ajneb97.libs.titles.TitleAPI;
import ce.ajneb97.managers.InterruptEventManager;
import ce.ajneb97.managers.MessagesManager;
import ce.ajneb97.managers.dependencies.DiscordSRVManager;
import ce.ajneb97.model.StoredVariable;
import ce.ajneb97.model.internal.ExecutedEvent;
import ce.ajneb97.utils.BlockUtils;
import ce.ajneb97.utils.ItemUtils;
import ce.ajneb97.utils.MathUtils;
import ce.ajneb97.utils.OtherUtils;
import ce.ajneb97.utils.PlayerUtils;
import ce.ajneb97.utils.ServerVersion;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class ActionUtils {
    public static void message(Player player, String actionLine) {
        player.sendMessage(MessagesManager.getColoredMessage(actionLine));
    }

    public static void centeredMessage(Player player, String actionLine) {
        actionLine = MessagesManager.getColoredMessage(actionLine);
        player.sendMessage(MessagesManager.getCenteredMessage(actionLine));
    }

    public static void consoleMessage(String actionLine) {
        Bukkit.getConsoleSender().sendMessage(MessagesManager.getColoredMessage(actionLine));
    }

    public static void jsonMessage(Player player, String actionLine) {
        BaseComponent[] base = ComponentSerializer.parse((String)actionLine);
        player.spigot().sendMessage(base);
    }

    public static void miniMessage(Player player, String actionLine, ConditionalEvents plugin) {
        ServerVersion serverVersion = ConditionalEvents.serverVersion;
        if (plugin.getDependencyManager().isPaper() && serverVersion.serverVersionGreaterEqualThan(serverVersion, ServerVersion.v1_19_R3)) {
            player.sendRichMessage(actionLine);
        }
    }

    public static void consoleCommand(String actionLine) {
        ConsoleCommandSender sender = Bukkit.getConsoleSender();
        Bukkit.dispatchCommand((CommandSender)sender, (String)actionLine);
    }

    public static void playerCommand(Player player, String actionLine) {
        player.performCommand(actionLine);
    }

    public static void playerCommandAsOp(Player player, String actionLine) {
        boolean isOp = player.isOp();
        player.setOp(true);
        player.performCommand(actionLine);
        if (!isOp) {
            player.setOp(false);
        }
    }

    public static void playerSendChat(Player player, String actionLine) {
        player.chat(MessagesManager.getColoredMessage(actionLine));
    }

    public static void sendToServer(Player player, String actionLine, ConditionalEvents plugin) {
        plugin.getBungeeMessagingManager().sendToServer(player, actionLine);
    }

    public static void teleport(Player player, String actionLine, Event minecraftEvent) {
        String[] sep = actionLine.split(";");
        World world = Bukkit.getWorld((String)sep[0]);
        double x = Double.valueOf(sep[1]);
        double y = Double.valueOf(sep[2]);
        double z = Double.valueOf(sep[3]);
        float yaw = Float.valueOf(sep[4]).floatValue();
        float pitch = Float.valueOf(sep[5]).floatValue();
        Location l = new Location(world, x, y, z, yaw, pitch);
        if (minecraftEvent instanceof PlayerRespawnEvent) {
            PlayerRespawnEvent respawnEvent = (PlayerRespawnEvent)minecraftEvent;
            respawnEvent.setRespawnLocation(l);
        } else {
            player.teleport(l);
        }
    }

    public static void removeItemSlot(Player player, String actionLine) {
        String[] sep = actionLine.split(";");
        String slot = sep[0];
        int amount = Integer.parseInt(sep[1]);
        ItemStack item = PlayerUtils.getItemBySlot(player, slot);
        if (item != null) {
            int newAmount = item.getAmount() - amount;
            if (newAmount <= 0) {
                PlayerUtils.setItemBySlot(player, slot, null);
            } else {
                item.setAmount(newAmount);
            }
            PlayerUtils.updatePlayerInventory(player);
        }
    }

    public static void removeItem(Player player, String actionLine) {
        if (actionLine.equals("no") || actionLine.equals("yes")) {
            return;
        }
        String[] sep = actionLine.split(";");
        String material = sep[0];
        int amount = Integer.valueOf(sep[1]);
        short datavalue = 0;
        String name = null;
        String loreContainsLoreLine = null;
        for (String sepLine : sep) {
            if (sepLine.startsWith("datavalue: ")) {
                datavalue = Short.valueOf(sepLine.replace("datavalue: ", ""));
                continue;
            }
            if (sepLine.startsWith("name: ")) {
                name = sepLine.replace("name: ", "");
                continue;
            }
            if (!sepLine.startsWith("lorecontains: ")) continue;
            loreContainsLoreLine = sepLine.replace("lorecontains: ", "");
        }
        ItemStack[] contents = player.getInventory().getContents();
        for (int i = 0; i < contents.length; ++i) {
            int currentAmount;
            if (contents[i] == null || contents[i].getType().equals((Object)Material.AIR) || !contents[i].getType().name().equals(material) || contents[i].getDurability() != datavalue) continue;
            if (contents[i].hasItemMeta()) {
                ItemMeta meta = contents[i].getItemMeta();
                if (meta.hasDisplayName() && name != null && !ChatColor.stripColor((String)meta.getDisplayName()).equals(ChatColor.stripColor((String)name))) continue;
                if (meta.hasLore() && loreContainsLoreLine != null) {
                    List lore = meta.getLore();
                    boolean contains = false;
                    for (String linea : lore) {
                        if (!ChatColor.stripColor((String)linea).contains(loreContainsLoreLine)) continue;
                        contains = true;
                        break;
                    }
                    if (!contains) {
                        continue;
                    }
                }
            } else if (name != null || loreContainsLoreLine != null) continue;
            if ((currentAmount = contents[i].getAmount()) > amount) {
                contents[i].setAmount(currentAmount - amount);
                break;
            }
            amount -= currentAmount;
            if (!OtherUtils.isLegacy()) {
                contents[i].setAmount(0);
                continue;
            }
            player.getInventory().setItem(i, null);
        }
    }

    public static void givePotionEffect(Player player, String actionLine) {
        String[] sep = actionLine.split(";");
        PotionEffectType potionEffectType = PotionEffectType.getByName((String)sep[0]);
        int duration = Integer.valueOf(sep[1]);
        int level = Integer.valueOf(sep[2]) - 1;
        boolean showParticles = true;
        if (sep.length >= 4) {
            showParticles = Boolean.valueOf(sep[3]);
        }
        PotionEffect effect = new PotionEffect(potionEffectType, duration, level, false, showParticles);
        player.addPotionEffect(effect);
    }

    public static void removePotionEffect(Player player, String actionLine) {
        if (actionLine.equals("all")) {
            for (PotionEffect effect : player.getActivePotionEffects()) {
                player.removePotionEffect(effect.getType());
            }
        } else {
            PotionEffectType potionEffectType = PotionEffectType.getByName((String)actionLine);
            player.removePotionEffect(potionEffectType);
        }
    }

    public static void cancelEvent(String actionLine, Event minecraftEvent) {
        boolean cancel = Boolean.valueOf(actionLine);
        if (minecraftEvent != null && minecraftEvent instanceof Cancellable) {
            Cancellable cancellableEvent = (Cancellable)minecraftEvent;
            cancellableEvent.setCancelled(cancel);
        }
    }

    public static void kick(Player player, String actionLine) {
        player.kickPlayer(MessagesManager.getColoredMessage(actionLine));
    }

    public static void playSound(Player player, String actionLine) {
        String[] sep = actionLine.split(";");
        Sound sound = null;
        float volume = 0.0f;
        float pitch = 0.0f;
        try {
            sound = ActionUtils.getSoundByName(sep[0]);
            volume = Float.parseFloat(sep[1]);
            pitch = Float.parseFloat(sep[2]);
        }
        catch (Exception e) {
            Bukkit.getConsoleSender().sendMessage(ConditionalEvents.prefix + MessagesManager.getColoredMessage(" &7Sound Name: &c" + sep[0] + " &7is not valid. Change it in the config!"));
            return;
        }
        Location location = null;
        if (sep.length >= 4) {
            String[] locParameters = sep[3].split(",");
            location = new Location(Bukkit.getWorld((String)locParameters[3]), Double.parseDouble(locParameters[0]), Double.parseDouble(locParameters[1]), Double.parseDouble(locParameters[2]));
        }
        if (location != null) {
            location.getWorld().playSound(location, sound, volume, pitch);
        } else {
            player.playSound(player.getLocation(), sound, volume, pitch);
        }
    }

    public static void playSoundResourcePack(Player player, String actionLine) {
        String[] sep = actionLine.split(";");
        String sound = sep[0];
        float volume = Float.parseFloat(sep[1]);
        float pitch = Float.parseFloat(sep[2]);
        Location location = null;
        if (sep.length >= 4) {
            String[] locParameters = sep[3].split(",");
            location = new Location(Bukkit.getWorld((String)locParameters[3]), Double.parseDouble(locParameters[0]), Double.parseDouble(locParameters[1]), Double.parseDouble(locParameters[2]));
        }
        if (location != null) {
            location.getWorld().playSound(location, sound, volume, pitch);
        } else {
            player.playSound(player.getLocation(), sound, volume, pitch);
        }
    }

    public static void stopSound(Player player, String actionLine) {
        ServerVersion serverVersion = ConditionalEvents.serverVersion;
        if (serverVersion.serverVersionGreaterEqualThan(serverVersion, ServerVersion.v1_10_R1)) {
            Sound sound = null;
            if (actionLine.equals("all")) {
                if (!serverVersion.serverVersionGreaterEqualThan(serverVersion, ServerVersion.v1_17_R1)) {
                    return;
                }
                player.stopAllSounds();
            } else {
                try {
                    sound = ActionUtils.getSoundByName(actionLine);
                }
                catch (Exception e) {
                    Bukkit.getConsoleSender().sendMessage(ConditionalEvents.prefix + MessagesManager.getColoredMessage(" &7Sound Name: &c" + actionLine + " &7is not valid. Change it in the config!"));
                    return;
                }
                player.stopSound(sound);
            }
        }
    }

    private static Sound getSoundByName(String name) {
        try {
            Class<?> soundTypeClass = Class.forName("org.bukkit.Sound");
            Method valueOf = soundTypeClass.getMethod("valueOf", String.class);
            return (Sound)valueOf.invoke(null, name);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static void giveItem(Player player, String actionLine) {
        String[] sep = actionLine.replace("give_item: ", "").split(";");
        ItemStack item = ItemUtils.getItemFromProperties(sep, player);
        String slot = null;
        boolean replace = true;
        for (String property : sep) {
            if (property.startsWith("slot:")) {
                slot = property.replace("slot:", "");
                continue;
            }
            if (!property.startsWith("slot_replace:")) continue;
            replace = Boolean.parseBoolean(property.replace("slot_replace:", ""));
        }
        if (slot != null) {
            int newAmount;
            ItemStack itemSlot = PlayerUtils.getItemBySlot(player, slot);
            if (replace) {
                PlayerUtils.setItemBySlot(player, slot, item);
            } else if (itemSlot == null || itemSlot.getType().equals((Object)Material.AIR)) {
                PlayerUtils.setItemBySlot(player, slot, item);
            } else if (itemSlot != null && itemSlot.isSimilar(item) && (newAmount = itemSlot.getAmount() + 1) <= itemSlot.getType().getMaxStackSize()) {
                itemSlot.setAmount(newAmount);
            }
            PlayerUtils.updatePlayerInventory(player);
        } else {
            player.getInventory().addItem(new ItemStack[]{item});
        }
    }

    public static void dropItem(String actionLine) {
        String[] sep = actionLine.replace("drop_item: ", "").split(";");
        ItemStack item = ItemUtils.getItemFromProperties(sep, null);
        Location location = null;
        for (String property : sep) {
            if (!property.startsWith("location:")) continue;
            String[] locationSplit = property.replace("location:", "").split(",");
            location = new Location(Bukkit.getWorld((String)locationSplit[3]), Double.parseDouble(locationSplit[0]), Double.parseDouble(locationSplit[1]), Double.parseDouble(locationSplit[2]));
            break;
        }
        if (location != null) {
            location.getWorld().dropItemNaturally(location, item);
        }
    }

    public static void setItem(String actionLine, Event minecraftEvent) {
        PlayerFishEvent event;
        Entity caught;
        String[] sep = actionLine.replace("set_item: ", "").split(";");
        if (minecraftEvent instanceof PlayerFishEvent && (caught = (event = (PlayerFishEvent)minecraftEvent).getCaught()) != null && caught instanceof Item) {
            Item item = (Item)caught;
            item.setItemStack(ItemUtils.getItemFromProperties(sep, null));
        }
    }

    public static void setBlock(String actionLine) {
        String[] sep = actionLine.replace("set_block: ", "").split(";");
        Location location = null;
        Material material = Material.AIR;
        String blockData = null;
        String skullTexture = null;
        String skullOwner = null;
        for (String property : sep) {
            if (property.startsWith("location:")) {
                String[] locationSplit = property.replace("location:", "").split(",");
                location = new Location(Bukkit.getWorld((String)locationSplit[3]), Double.parseDouble(locationSplit[0]), Double.parseDouble(locationSplit[1]), Double.parseDouble(locationSplit[2]));
                continue;
            }
            if (property.startsWith("id:")) {
                material = Material.valueOf((String)property.replace("id:", ""));
                continue;
            }
            if (property.startsWith("block_data:")) {
                blockData = property.replace("block_data:", "");
                continue;
            }
            if (property.startsWith("skull_texture:")) {
                skullTexture = property.replace("skull_texture:", "");
                continue;
            }
            if (!property.startsWith("skull_owner:")) continue;
            skullOwner = property.replace("skull_owner:", "");
        }
        if (location != null) {
            Block block = location.getWorld().getBlockAt(location);
            block.setType(material);
            if (blockData != null) {
                block.setBlockData(BlockUtils.getBlockDataFromString(blockData, material));
            }
            if (skullTexture != null || skullOwner != null) {
                BlockUtils.setHeadTextureData(block, skullTexture, skullOwner);
            }
        }
    }

    public static void lightningStrike(String actionLine) {
        String[] sep = actionLine.split(";");
        World world = Bukkit.getWorld((String)sep[0]);
        double x = Double.parseDouble(sep[1]);
        double y = Double.parseDouble(sep[2]);
        double z = Double.parseDouble(sep[3]);
        Location l = new Location(world, x, y, z);
        l.getWorld().strikeLightningEffect(l);
    }

    public static void summon(String actionLine) {
        String[] sep = actionLine.replace("summon: ", "").split(";");
        Location location = null;
        EntityType type = null;
        String customName = null;
        double health = 0.0;
        String equipmentString = null;
        String handEquipmentString = null;
        int amount = 1;
        for (String property : sep) {
            if (property.startsWith("location:")) {
                String[] locationSplit = property.replace("location:", "").split(",");
                location = new Location(Bukkit.getWorld((String)locationSplit[3]), Double.parseDouble(locationSplit[0]), Double.parseDouble(locationSplit[1]), Double.parseDouble(locationSplit[2]));
                continue;
            }
            if (property.startsWith("entity:")) {
                type = EntityType.valueOf((String)property.replace("entity:", ""));
                continue;
            }
            if (property.startsWith("custom_name:")) {
                customName = property.replace("custom_name:", "");
                continue;
            }
            if (property.startsWith("health:")) {
                health = Double.parseDouble(property.replace("health:", ""));
                continue;
            }
            if (property.startsWith("equipment:")) {
                equipmentString = property.replace("equipment:", "");
                continue;
            }
            if (property.startsWith("hand_equipment:")) {
                handEquipmentString = property.replace("hand_equipment:", "");
                continue;
            }
            if (!property.startsWith("amount:")) continue;
            amount = Integer.parseInt(property.replace("amount:", ""));
        }
        if (location != null) {
            for (int i = 0; i < amount; ++i) {
                Entity entity = location.getWorld().spawnEntity(location, type);
                if (customName != null) {
                    entity.setCustomNameVisible(true);
                    entity.setCustomName(MessagesManager.getColoredMessage(customName));
                }
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                if (health != 0.0) {
                    livingEntity.setMaxHealth(health);
                    livingEntity.setHealth(health);
                }
                EntityEquipment equipment = livingEntity.getEquipment();
                if (equipmentString != null) {
                    String[] equipmentSplit = equipmentString.split(",");
                    equipment.setHelmet(!equipmentSplit[0].equals("none") ? ItemUtils.createItemFromString(equipmentSplit[0], null) : null);
                    equipment.setHelmetDropChance(0.0f);
                    equipment.setChestplate(!equipmentSplit[1].equals("none") ? ItemUtils.createItemFromString(equipmentSplit[1], null) : null);
                    equipment.setChestplateDropChance(0.0f);
                    equipment.setLeggings(!equipmentSplit[2].equals("none") ? ItemUtils.createItemFromString(equipmentSplit[2], null) : null);
                    equipment.setLeggingsDropChance(0.0f);
                    equipment.setBoots(!equipmentSplit[3].equals("none") ? ItemUtils.createItemFromString(equipmentSplit[3], null) : null);
                    equipment.setBootsDropChance(0.0f);
                }
                if (handEquipmentString == null) continue;
                String[] handEquipmentSplit = handEquipmentString.split(",");
                equipment.setItemInMainHand(!handEquipmentSplit[0].equals("none") ? ItemUtils.createItemFromString(handEquipmentSplit[0], null) : null);
                equipment.setItemInMainHandDropChance(0.0f);
                equipment.setItemInOffHand(!handEquipmentSplit[1].equals("none") ? ItemUtils.createItemFromString(handEquipmentSplit[1], null) : null);
                equipment.setItemInOffHandDropChance(0.0f);
            }
        }
    }

    public static void actionbar(Player player, String actionLine, ConditionalEvents plugin) {
        String[] sep = actionLine.split(";");
        String text = sep[0];
        int duration = Integer.valueOf(sep[1]);
        ActionBarAPI.sendActionBar(player, text, duration, plugin);
    }

    public static void title(Player player, String actionLine) {
        String[] sep = actionLine.split(";");
        int fadeIn = Integer.valueOf(sep[0]);
        int stay = Integer.valueOf(sep[1]);
        int fadeOut = Integer.valueOf(sep[2]);
        String title = sep[3];
        String subtitle = sep[4];
        if (title.equals("none")) {
            title = "";
        }
        if (subtitle.equals("none")) {
            subtitle = "";
        }
        TitleAPI.sendTitle(player, fadeIn, stay, fadeOut, title, subtitle);
    }

    public static void firework(Player player, String actionLine, ConditionalEvents plugin) {
        String[] sep;
        ArrayList<Color> colors = new ArrayList<Color>();
        FireworkEffect.Type type = null;
        ArrayList<Color> fadeColors = new ArrayList<Color>();
        Location location = null;
        int power = 0;
        boolean hasTrail = false;
        boolean hasFlicker = false;
        String shotDirection = null;
        for (String s : sep = actionLine.split(" ")) {
            String[] colorsSep;
            if (s.startsWith("colors:")) {
                s = s.replace("colors:", "");
                for (String colorSep : colorsSep = s.split(",")) {
                    colors.add(OtherUtils.getFireworkColorFromName(colorSep));
                }
                continue;
            }
            if (s.startsWith("type:")) {
                s = s.replace("type:", "");
                type = FireworkEffect.Type.valueOf((String)s);
                continue;
            }
            if (s.startsWith("fade:")) {
                s = s.replace("fade:", "");
                for (String colorSep : colorsSep = s.split(",")) {
                    fadeColors.add(OtherUtils.getFireworkColorFromName(colorSep));
                }
                continue;
            }
            if (s.startsWith("power:")) {
                s = s.replace("power:", "");
                power = Integer.parseInt(s);
                continue;
            }
            if (s.startsWith("trail:")) {
                s = s.replace("trail:", "");
                hasTrail = Boolean.parseBoolean(s);
                continue;
            }
            if (s.startsWith("flicker:")) {
                s = s.replace("flicker:", "");
                hasFlicker = Boolean.parseBoolean(s);
                continue;
            }
            if (s.startsWith("shot_direction:")) {
                shotDirection = s = s.replace("shot_direction:", "");
                continue;
            }
            if (!s.startsWith("location:")) continue;
            String[] sep2 = s.replace("location:", "").split(";");
            location = new Location(Bukkit.getWorld((String)sep2[3]), Double.parseDouble(sep2[0]), Double.parseDouble(sep2[1]), Double.parseDouble(sep2[2]));
        }
        if (location == null) {
            location = player.getLocation();
        }
        ServerVersion serverVersion = ConditionalEvents.serverVersion;
        EntityType entityType = null;
        entityType = serverVersion.serverVersionGreaterEqualThan(serverVersion, ServerVersion.v1_20_R4) ? EntityType.FIREWORK_ROCKET : EntityType.valueOf((String)"FIREWORK");
        Firework firework = (Firework)location.getWorld().spawnEntity(location, entityType);
        FireworkMeta fireworkMeta = firework.getFireworkMeta();
        FireworkEffect effect = FireworkEffect.builder().flicker(false).withColor(colors).with(type).withFade(fadeColors).trail(hasTrail).flicker(hasFlicker).build();
        fireworkMeta.addEffect(effect);
        fireworkMeta.setPower(power);
        firework.setFireworkMeta(fireworkMeta);
        if (shotDirection != null && serverVersion.serverVersionGreaterEqualThan(serverVersion, ServerVersion.v1_15_R1)) {
            firework.setShotAtAngle(true);
            String[] sepDirection = shotDirection.split(";");
            String[] offsetX = sepDirection[0].split(",");
            String[] offsetY = sepDirection[1].split(",");
            String[] offsetZ = sepDirection[2].split(",");
            String[] offsetVelocity = sepDirection[3].split("-");
            Vector direction = new Vector(MathUtils.getRandomNumberFloat(Float.parseFloat(offsetX[0]), Float.parseFloat(offsetX[1])), MathUtils.getRandomNumberFloat(Float.parseFloat(offsetY[0]), Float.parseFloat(offsetY[1])), MathUtils.getRandomNumberFloat(Float.parseFloat(offsetZ[0]), Float.parseFloat(offsetZ[1])));
            firework.setVelocity(direction.multiply(MathUtils.getRandomNumberFloat(Float.parseFloat(offsetVelocity[0]), Float.parseFloat(offsetVelocity[1]))));
        }
        firework.setMetadata("conditionalevents", (MetadataValue)new FixedMetadataValue((Plugin)plugin, (Object)"no_damage"));
    }

    public static void particle(Player player, String actionLine) {
        String[] sep;
        String effectName = null;
        double offsetX = 0.0;
        double offsetY = 0.0;
        double offsetZ = 0.0;
        double speed = 0.0;
        int amount = 1;
        Location location = null;
        boolean force = false;
        for (String s : sep = actionLine.split(" ")) {
            String[] sep2;
            if (s.startsWith("effect:")) {
                effectName = s.replace("effect:", "");
                continue;
            }
            if (s.startsWith("speed:")) {
                speed = Double.parseDouble(s.replace("speed:", ""));
                continue;
            }
            if (s.startsWith("amount:")) {
                amount = Integer.parseInt(s.replace("amount:", ""));
                continue;
            }
            if (s.startsWith("offset:")) {
                sep2 = s.replace("offset:", "").split(";");
                offsetX = Double.parseDouble(sep2[0]);
                offsetY = Double.parseDouble(sep2[1]);
                offsetZ = Double.parseDouble(sep2[2]);
                continue;
            }
            if (s.startsWith("location:")) {
                sep2 = s.replace("location:", "").split(";");
                location = new Location(Bukkit.getWorld((String)sep2[3]), Double.parseDouble(sep2[0]), Double.parseDouble(sep2[1]), Double.parseDouble(sep2[2]));
                continue;
            }
            if (!s.startsWith("force:")) continue;
            force = Boolean.parseBoolean(s.replace("force:", ""));
        }
        if (location == null) {
            location = player.getLocation();
        }
        if (Bukkit.getVersion().contains("1.8")) {
            return;
        }
        try {
            if (effectName.startsWith("REDSTONE;") || effectName.startsWith("DUST;")) {
                String[] effectSeparated = effectName.split(";");
                int red = Integer.parseInt(effectSeparated[1]);
                int green = Integer.parseInt(effectSeparated[2]);
                int blue = Integer.parseInt(effectSeparated[3]);
                Particle.DustOptions dustOptions = new Particle.DustOptions(Color.fromRGB((int)red, (int)green, (int)blue), 1.0f);
                location.getWorld().spawnParticle(Particle.valueOf((String)effectSeparated[0]), location, amount, offsetX, offsetY, offsetZ, speed, (Object)dustOptions, force);
            } else {
                location.getWorld().spawnParticle(Particle.valueOf((String)effectName), location, amount, offsetX, offsetY, offsetZ, speed, null, force);
            }
        }
        catch (Exception e) {
            Bukkit.getConsoleSender().sendMessage(ConditionalEvents.prefix + MessagesManager.getColoredMessage(" &7Particle Name: &c" + effectName + " &7is not valid. Change it in the config!"));
        }
    }

    public static void damage(Player player, String actionLine) {
        player.damage(Double.parseDouble(actionLine));
    }

    public static void gamemode(Player player, String actionLine) {
        player.setGameMode(GameMode.valueOf((String)actionLine));
    }

    public static void closeInventory(Player player) {
        player.closeInventory();
    }

    public static void clearInventory(Player player) {
        player.getInventory().clear();
    }

    public static void setOnFire(Player player, String actionLine) {
        player.setFireTicks(Integer.parseInt(actionLine));
    }

    public static void freeze(Player player, String actionLine) {
        ServerVersion serverVersion = ConditionalEvents.serverVersion;
        if (serverVersion.serverVersionGreaterEqualThan(serverVersion, ServerVersion.v1_17_R1)) {
            player.setFreezeTicks(Integer.parseInt(actionLine));
        }
    }

    public static void heal(Player player, String actionLine) {
        double maxHealth = player.getMaxHealth();
        double currentHealth = player.getHealth();
        double newHealth = currentHealth + Double.parseDouble(actionLine);
        if (newHealth >= maxHealth) {
            player.setHealth(maxHealth);
        } else {
            player.setHealth(newHealth);
        }
    }

    public static void setFoodLevel(Player player, String actionLine) {
        player.setFoodLevel(Integer.parseInt(actionLine));
    }

    public static void wait(String actionLine, final ExecutedEvent executedEvent) {
        executedEvent.setOnWait(true);
        int timeSeconds = Integer.parseInt(actionLine);
        final InterruptEventManager interruptEventManager = ConditionalEventsAPI.getPlugin().getInterruptEventManager();
        BukkitTask task = new BukkitRunnable(){

            public void run() {
                interruptEventManager.removeTaskById(this.getTaskId());
                executedEvent.continueWithActions();
            }
        }.runTaskLater((Plugin)executedEvent.getPlugin(), (long)timeSeconds * 20L);
        interruptEventManager.addTask(executedEvent.getPlayer() != null ? executedEvent.getPlayer().getName() : null, executedEvent.getEvent().getName(), task);
    }

    public static void waitTicks(String actionLine, final ExecutedEvent executedEvent) {
        executedEvent.setOnWait(true);
        long timeTicks = Long.parseLong(actionLine);
        final InterruptEventManager interruptEventManager = ConditionalEventsAPI.getPlugin().getInterruptEventManager();
        BukkitTask task = new BukkitRunnable(){

            public void run() {
                interruptEventManager.removeTaskById(this.getTaskId());
                executedEvent.continueWithActions();
            }
        }.runTaskLater((Plugin)executedEvent.getPlugin(), timeTicks);
        interruptEventManager.addTask(executedEvent.getPlayer() != null ? executedEvent.getPlayer().getName() : null, executedEvent.getEvent().getName(), task);
    }

    public static void keepItems(String actionLine, Event minecraftEvent) {
        if (minecraftEvent instanceof PlayerDeathEvent) {
            PlayerDeathEvent deathEvent = (PlayerDeathEvent)minecraftEvent;
            if (actionLine.equals("items") || actionLine.equals("all")) {
                deathEvent.setKeepInventory(true);
                deathEvent.getDrops().clear();
            }
            if (actionLine.equals("xp") || actionLine.equals("all")) {
                deathEvent.setKeepLevel(true);
                deathEvent.setDroppedExp(0);
            }
        }
    }

    public static void cancelDrop(String actionLine, Event minecraftEvent) {
        if (minecraftEvent instanceof BlockBreakEvent) {
            if (OtherUtils.isLegacy()) {
                return;
            }
            BlockBreakEvent blockBreakEvent = (BlockBreakEvent)minecraftEvent;
            boolean cancel = Boolean.parseBoolean(actionLine);
            if (cancel) {
                blockBreakEvent.setDropItems(false);
            }
        } else if (minecraftEvent instanceof EntityDeathEvent) {
            EntityDeathEvent entityDeathEvent = (EntityDeathEvent)minecraftEvent;
            boolean cancel = Boolean.parseBoolean(actionLine);
            if (cancel) {
                entityDeathEvent.getDrops().clear();
            }
        }
    }

    public static void setDamage(String actionLine, Event minecraftEvent) {
        if (minecraftEvent instanceof EntityDamageEvent) {
            EntityDamageEvent damageEvent = (EntityDamageEvent)minecraftEvent;
            double damage = damageEvent.getDamage();
            if (actionLine.contains("%")) {
                double modifier = Double.parseDouble(actionLine.substring(0, actionLine.length() - 1));
                double finalModifier = modifier / 100.0;
                damage *= finalModifier;
            } else {
                damage = Double.parseDouble(actionLine);
            }
            damageEvent.setDamage(damage);
        }
    }

    public static void hideJoinMessage(String actionLine, Event minecraftEvent) {
        if (minecraftEvent instanceof PlayerJoinEvent) {
            PlayerJoinEvent joinEvent = (PlayerJoinEvent)minecraftEvent;
            boolean hideMessage = Boolean.parseBoolean(actionLine);
            if (hideMessage) {
                joinEvent.setJoinMessage(null);
            }
        }
    }

    public static void hideLeaveMessage(String actionLine, Event minecraftEvent) {
        if (minecraftEvent instanceof PlayerQuitEvent) {
            PlayerQuitEvent quitEvent = (PlayerQuitEvent)minecraftEvent;
            boolean hideMessage = Boolean.parseBoolean(actionLine);
            if (hideMessage) {
                quitEvent.setQuitMessage(null);
            }
        }
    }

    public static void setDeathMessage(String actionLine, Event minecraftEvent) {
        if (minecraftEvent instanceof PlayerDeathEvent) {
            PlayerDeathEvent deathEvent = (PlayerDeathEvent)minecraftEvent;
            if (actionLine.equals("no")) {
                deathEvent.setDeathMessage(null);
            } else {
                deathEvent.setDeathMessage(MessagesManager.getColoredMessage(actionLine));
            }
        }
    }

    public static void preventJoin(String actionLine, Event minecraftEvent) {
        if (minecraftEvent instanceof AsyncPlayerPreLoginEvent) {
            AsyncPlayerPreLoginEvent preJoinEvent = (AsyncPlayerPreLoginEvent)minecraftEvent;
            preJoinEvent.setLoginResult(AsyncPlayerPreLoginEvent.Result.KICK_OTHER);
            preJoinEvent.setKickMessage(MessagesManager.getColoredMessage(actionLine));
        }
    }

    public static void discordSRVEmbed(String actionLine, ConditionalEvents plugin) {
        DiscordSRVManager discordSRVManager = plugin.getDependencyManager().getDiscordSRVManager();
        if (discordSRVManager != null) {
            discordSRVManager.sendEmbedMessage(actionLine);
        }
    }

    public static boolean callEvent(String actionLine, Player player, ConditionalEvents plugin) {
        ArrayList<StoredVariable> variables = new ArrayList<StoredVariable>();
        String eventName = null;
        try {
            String[] sep = actionLine.split(";");
            eventName = sep[0];
            if (sep.length > 1) {
                for (int i = 1; i < sep.length; ++i) {
                    String[] variableLineSep = sep[i].split("=");
                    variables.add(new StoredVariable(variableLineSep[0], variableLineSep[1]));
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        ConditionalEventsCallEvent event = new ConditionalEventsCallEvent(player, variables, eventName);
        plugin.getServer().getPluginManager().callEvent((Event)event);
        return true;
    }

    public static void executeActionGroup(String actionLine, ExecutedEvent executedEvent, ConditionalEvents plugin) {
        String[] sep;
        ArrayList<String> actionGroups = new ArrayList<String>();
        ArrayList<Integer> probs = new ArrayList<Integer>();
        for (String line : sep = actionLine.split(";")) {
            String[] sep2 = line.split(":");
            actionGroups.add(sep2[0]);
            probs.add(Integer.parseInt(sep2[1]));
        }
        for (int i = 0; i < probs.size(); ++i) {
            if (i == 0) continue;
            probs.set(i, (Integer)probs.get(i - 1) + (Integer)probs.get(i));
        }
        String actionGroup = null;
        Random random = new Random();
        int max = (Integer)probs.get(probs.size() - 1);
        int randomNumber = random.nextInt(max);
        for (int i = 0; i < probs.size(); ++i) {
            if (i == 0) {
                if (randomNumber >= (Integer)probs.get(i)) continue;
                actionGroup = (String)actionGroups.get(i);
                continue;
            }
            if (randomNumber <= (Integer)probs.get(i - 1) || randomNumber > (Integer)probs.get(i)) continue;
            actionGroup = (String)actionGroups.get(i);
        }
        if (actionGroup == null) {
            actionGroup = (String)actionGroups.get(0);
        }
        new ExecutedEvent(executedEvent.getPlayer(), executedEvent.getEventVariables(), executedEvent.getEvent(), actionGroup, executedEvent.getMinecraftEvent(), executedEvent.getTarget(), plugin).executeActions();
    }

    public static void setEventXp(String actionLine, Event minecraftEvent) {
        int xp = Integer.parseInt(actionLine.replace("set_event_xp: ", ""));
        if (minecraftEvent instanceof PlayerFishEvent) {
            PlayerFishEvent event = (PlayerFishEvent)minecraftEvent;
            event.setExpToDrop(xp);
        } else if (minecraftEvent instanceof BlockBreakEvent) {
            BlockBreakEvent event = (BlockBreakEvent)minecraftEvent;
            event.setExpToDrop(xp);
        }
    }
}

