/*
 * Decompiled with CFR 0.152.
 */
package ce.ajneb97.configs;

import ce.ajneb97.ConditionalEvents;
import ce.ajneb97.configs.EventsFolderConfigManager;
import ce.ajneb97.configs.MainConfigManager;
import ce.ajneb97.configs.PlayersConfigsManager;
import ce.ajneb97.configs.SavedItemsConfigManager;
import ce.ajneb97.configs.model.CommonConfig;
import ce.ajneb97.managers.RepetitiveManager;
import ce.ajneb97.model.CEEvent;
import ce.ajneb97.model.CustomEventProperties;
import ce.ajneb97.model.EventType;
import ce.ajneb97.model.actions.ActionGroup;
import ce.ajneb97.model.actions.ActionTargeter;
import ce.ajneb97.model.actions.ActionTargeterType;
import ce.ajneb97.model.actions.ActionType;
import ce.ajneb97.model.actions.CEAction;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigsManager {
    private MainConfigManager mainConfigManager;
    private PlayersConfigsManager playerConfigsManager;
    private EventsFolderConfigManager eventsFolderConfigManager;
    private SavedItemsConfigManager savedItemsConfigManager;
    private ConditionalEvents plugin;

    public ConfigsManager(ConditionalEvents plugin) {
        this.mainConfigManager = new MainConfigManager(plugin);
        this.playerConfigsManager = new PlayersConfigsManager(plugin, "players");
        this.eventsFolderConfigManager = new EventsFolderConfigManager(plugin, "events");
        this.savedItemsConfigManager = new SavedItemsConfigManager(plugin);
        this.plugin = plugin;
    }

    public void configure() {
        this.mainConfigManager.configure();
        this.playerConfigsManager.configure();
        this.eventsFolderConfigManager.configure();
        this.savedItemsConfigManager.configure();
        this.configureEvents();
    }

    public MainConfigManager getMainConfigManager() {
        return this.mainConfigManager;
    }

    public PlayersConfigsManager getPlayerConfigsManager() {
        return this.playerConfigsManager;
    }

    public SavedItemsConfigManager getSavedItemsConfigManager() {
        return this.savedItemsConfigManager;
    }

    public void configureEvents() {
        ArrayList<CommonConfig> ceConfigs = this.getEventConfigs();
        ArrayList<CEEvent> events = new ArrayList<CEEvent>();
        for (CommonConfig configFile : ceConfigs) {
            FileConfiguration config = configFile.getConfig();
            if (!config.contains("Events")) continue;
            for (String key : config.getConfigurationSection("Events").getKeys(false)) {
                String path = "Events." + key;
                String filePath = configFile.getPath();
                ArrayList<String> conditions = new ArrayList();
                ArrayList<ActionGroup> actionGroups = new ArrayList<ActionGroup>();
                boolean oneTime = false;
                String ignoreWithPermission = null;
                long cooldown = 0L;
                boolean enabled = true;
                boolean ignoreIfCancelled = false;
                boolean allowMathFormulasInConditions = false;
                ArrayList<String> preventCooldownActivationActionGroups = new ArrayList();
                ArrayList<String> preventOneTimeActivationActionGroups = new ArrayList();
                CEEvent event = new CEEvent(key);
                EventType eventType = null;
                try {
                    eventType = EventType.valueOf(config.getString(path + ".type").toUpperCase());
                }
                catch (Exception e) {
                    continue;
                }
                if (config.contains(path + ".conditions")) {
                    conditions = config.getStringList(path + ".conditions");
                }
                if (config.contains(path + ".actions")) {
                    for (String groupName : config.getConfigurationSection(path + ".actions").getKeys(false)) {
                        List actionsList = config.getStringList(path + ".actions." + groupName);
                        ArrayList<CEAction> ceActions = new ArrayList<CEAction>();
                        for (String action : actionsList) {
                            ActionTargeter targeter = new ActionTargeter(ActionTargeterType.NORMAL);
                            if (action.startsWith("to_all: ")) {
                                action = action.replace("to_all: ", "");
                                targeter.setType(ActionTargeterType.TO_ALL);
                            } else if (action.startsWith("to_target: ")) {
                                action = action.replace("to_target: ", "");
                                targeter.setType(ActionTargeterType.TO_TARGET);
                            } else if (action.startsWith("to_world: ") || action.startsWith("to_range: ") || action.startsWith("to_condition: ") || action.startsWith("to_player: ")) {
                                ActionTargeterType targeterType = null;
                                if (action.startsWith("to_world: ")) {
                                    targeterType = ActionTargeterType.TO_WORLD;
                                } else if (action.startsWith("to_range: ")) {
                                    targeterType = ActionTargeterType.TO_RANGE;
                                } else if (action.startsWith("to_condition: ")) {
                                    targeterType = ActionTargeterType.TO_CONDITION;
                                } else if (action.startsWith("to_player: ")) {
                                    targeterType = ActionTargeterType.TO_PLAYER;
                                }
                                targeter.setType(targeterType);
                                action = action.replace(targeterType.name().toLowerCase() + ": ", "");
                                String[] sep = action.split(" ");
                                String parameter = sep[0].substring(0, sep[0].length() - 1);
                                action = action.replace(sep[0] + " ", "");
                                targeter.setParameter(parameter);
                            }
                            String actionTypeText = null;
                            ActionType actionType = null;
                            String actionApiType = null;
                            try {
                                actionTypeText = action.equalsIgnoreCase("close_inventory") || action.equalsIgnoreCase("clear_inventory") ? action : action.substring(0, action.indexOf(":"));
                                if (this.plugin.getApiManager().getApiAction(actionTypeText) != null) {
                                    actionType = ActionType.API;
                                    actionApiType = actionTypeText;
                                } else {
                                    actionType = ActionType.valueOf(actionTypeText.toUpperCase());
                                }
                            }
                            catch (Exception e) {
                                continue;
                            }
                            String actionLine = action.replace(actionTypeText + ": ", "");
                            CEAction ceAction = new CEAction(actionType, actionLine, targeter);
                            ceAction.setApiType(actionApiType);
                            ceActions.add(ceAction);
                        }
                        ActionGroup actionGroup = new ActionGroup(groupName, ceActions);
                        actionGroups.add(actionGroup);
                    }
                }
                if (config.contains(path + ".cooldown")) {
                    cooldown = Long.valueOf(config.getString(path + ".cooldown"));
                }
                if (config.contains(path + ".ignore_with_permission")) {
                    ignoreWithPermission = config.getString(path + ".ignore_with_permission");
                }
                if (config.contains(path + ".one_time")) {
                    oneTime = Boolean.valueOf(config.getString(path + ".one_time"));
                }
                if (config.contains(path + ".enabled")) {
                    enabled = Boolean.valueOf(config.getString(path + ".enabled"));
                }
                if (config.contains(path + ".ignore_if_cancelled")) {
                    ignoreIfCancelled = Boolean.valueOf(config.getString(path + ".ignore_if_cancelled"));
                }
                if (config.contains(path + ".prevent_cooldown_activation")) {
                    preventCooldownActivationActionGroups = config.getStringList(path + ".prevent_cooldown_activation");
                }
                if (config.contains(path + ".prevent_one_time_activation")) {
                    preventOneTimeActivationActionGroups = config.getStringList(path + ".prevent_one_time_activation");
                }
                if (config.contains(path + ".allow_math_formulas_in_conditions")) {
                    allowMathFormulasInConditions = Boolean.valueOf(config.getString(path + ".allow_math_formulas_in_conditions"));
                }
                event.setFilePath(filePath);
                event.setEventType(eventType);
                event.setConditions(conditions);
                event.setActionGroups(actionGroups);
                event.setCooldown(cooldown);
                event.setIgnoreWithPermission(ignoreWithPermission);
                event.setOneTime(oneTime);
                event.setEnabled(enabled);
                event.setIgnoreIfCancelled(ignoreIfCancelled);
                event.setPreventCooldownActivationActionGroups(preventCooldownActivationActionGroups);
                event.setPreventOneTimeActivationActionGroups(preventOneTimeActivationActionGroups);
                event.setAllowMathFormulasInConditions(allowMathFormulasInConditions);
                if (event.getEventType().equals((Object)EventType.CUSTOM)) {
                    String eventPackage = config.getString(path + ".custom_event_data.event");
                    String playerVariable = null;
                    if (config.contains(path + ".custom_event_data.player_variable")) {
                        playerVariable = config.getString(path + ".custom_event_data.player_variable");
                    }
                    List<String> variablesToCapture = new ArrayList<String>();
                    if (config.contains(path + ".custom_event_data.variables_to_capture")) {
                        variablesToCapture = config.getStringList(path + ".custom_event_data.variables_to_capture");
                    }
                    event.setCustomEventProperties(new CustomEventProperties(eventPackage, playerVariable, variablesToCapture));
                }
                if (event.getEventType().equals((Object)EventType.REPETITIVE) || event.getEventType().equals((Object)EventType.REPETITIVE_SERVER)) {
                    int repetitiveTime = config.getInt(path + ".repetitive_time");
                    RepetitiveManager repetitiveManager = new RepetitiveManager(this.plugin, event, repetitiveTime);
                    event.setRepetitiveManager(repetitiveManager);
                    if (event.isEnabled()) {
                        repetitiveManager.start();
                    }
                }
                events.add(event);
            }
        }
        this.plugin.getEventsManager().setEvents(events);
    }

    public void saveEvent(CEEvent event) {
        String eventName = event.getName();
        String path = event.getFilePath();
        CommonConfig commonConfig = path.equals("config.yml") ? this.mainConfigManager.getConfigFile() : this.eventsFolderConfigManager.getConfigFile(path);
        FileConfiguration config = commonConfig.getConfig();
        config.set("Events." + eventName + ".enabled", (Object)event.isEnabled());
        commonConfig.saveConfig();
    }

    public ArrayList<CommonConfig> getEventConfigs() {
        ArrayList<CommonConfig> configs = new ArrayList<CommonConfig>();
        configs.add(this.mainConfigManager.getConfigFile());
        configs.addAll(this.eventsFolderConfigManager.getConfigs());
        return configs;
    }

    public void endRepetitiveEvents() {
        for (CEEvent event : this.plugin.getEventsManager().getEvents()) {
            if (event.getRepetitiveManager() == null) continue;
            event.getRepetitiveManager().end();
        }
    }

    public boolean reload() {
        this.endRepetitiveEvents();
        this.playerConfigsManager.saveConfigs();
        if (!this.mainConfigManager.reloadConfig()) {
            return false;
        }
        this.configureEvents();
        this.plugin.reloadEvents();
        this.plugin.getVerifyManager().verifyEvents();
        this.plugin.reloadPlayerDataSaveTask();
        return true;
    }
}

