/*
 * Decompiled with CFR 0.152.
 */
package ce.ajneb97.configs;

import ce.ajneb97.ConditionalEvents;
import ce.ajneb97.configs.model.CommonConfig;
import java.util.HashMap;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;

public class SavedItemsConfigManager {
    private CommonConfig configFile;
    private ConditionalEvents plugin;

    public SavedItemsConfigManager(ConditionalEvents plugin) {
        this.plugin = plugin;
        this.configFile = new CommonConfig("saved_items.yml", plugin, null, false);
        this.configFile.registerConfig();
    }

    public void configure() {
        HashMap<String, ItemStack> savedItems = new HashMap<String, ItemStack>();
        FileConfiguration config = this.configFile.getConfig();
        if (config.contains("items")) {
            for (String key : config.getConfigurationSection("items").getKeys(false)) {
                ItemStack item = config.getItemStack("items." + key);
                savedItems.put(key, item);
            }
        }
        this.plugin.getSavedItemsManager().setSavedItems(savedItems);
    }

    public void saveItem(String name, ItemStack item) {
        FileConfiguration config = this.configFile.getConfig();
        config.set("items." + name, (Object)item);
        this.saveConfig();
    }

    public void removeItem(String name) {
        FileConfiguration config = this.configFile.getConfig();
        config.set("items." + name, null);
        this.saveConfig();
    }

    public boolean reloadConfig() {
        if (!this.configFile.reloadConfig()) {
            return false;
        }
        this.configure();
        return true;
    }

    public FileConfiguration getConfig() {
        return this.configFile.getConfig();
    }

    public CommonConfig getConfigFile() {
        return this.configFile;
    }

    public void saveConfig() {
        this.configFile.saveConfig();
    }
}

