/*
 * Decompiled with CFR 0.152.
 */
package ce.ajneb97.managers;

import ce.ajneb97.ConditionalEvents;
import ce.ajneb97.managers.MessagesManager;
import ce.ajneb97.model.actions.ActionTargeter;
import ce.ajneb97.model.actions.ActionTargeterType;
import ce.ajneb97.model.actions.ActionType;
import ce.ajneb97.model.internal.DebugSender;
import java.util.ArrayList;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class DebugManager {
    private ConditionalEvents plugin;
    private ArrayList<DebugSender> debugSenders;

    public DebugManager(ConditionalEvents plugin) {
        this.plugin = plugin;
        this.debugSenders = new ArrayList();
    }

    public boolean setDebugSender(CommandSender sender, String event, String playerName) {
        DebugSender debugSender = this.getDebugSender(sender);
        if (debugSender == null) {
            this.debugSenders.add(new DebugSender(sender, event, playerName));
            return true;
        }
        if (debugSender.getEvent().equals(event)) {
            this.removeDebugSender(sender);
            return false;
        }
        debugSender.setEvent(event);
        return true;
    }

    public DebugSender getDebugSender(CommandSender sender) {
        for (DebugSender debugSender : this.debugSenders) {
            if (!debugSender.getSender().equals((Object)sender)) continue;
            return debugSender;
        }
        return null;
    }

    public void removeDebugSender(CommandSender sender) {
        for (int i = 0; i < this.debugSenders.size(); ++i) {
            if (!this.debugSenders.get(i).getSender().equals((Object)sender)) continue;
            this.debugSenders.remove(i);
            return;
        }
    }

    public void sendConditionMessage(String event, String condition, boolean approved, Player player, boolean start) {
        if (this.debugSenders.isEmpty()) {
            return;
        }
        if (condition.endsWith(" or ")) {
            condition = condition.substring(0, condition.length() - 4);
        } else if (condition.endsWith(" and ")) {
            condition = condition.substring(0, condition.length() - 5);
        }
        String result = "&a&lAPPROVED";
        if (!approved) {
            result = "&c&lDENIED";
        }
        String playerInfo = "";
        if (player != null) {
            playerInfo = "," + player.getName();
        }
        String startText = "";
        if (start) {
            startText = ",&estart";
        }
        String debugMessage = MessagesManager.getColoredMessage("&8[&c" + event + playerInfo + startText + "&8] &7Checking for: &f") + condition + MessagesManager.getColoredMessage(" &8| &7Result: " + result);
        for (DebugSender debugSender : this.debugSenders) {
            if (!debugSender.getEvent().equals(event) || player != null && debugSender.getPlayerName() != null && !debugSender.getPlayerName().equals(player.getName())) continue;
            debugSender.getSender().sendMessage(debugMessage);
        }
    }

    public void sendActionsMessage(String event, String actionGroup, Player player) {
        int pos;
        if (this.debugSenders.isEmpty()) {
            return;
        }
        String playerInfo = "";
        if (player != null) {
            playerInfo = "," + player.getName();
        }
        if ((pos = actionGroup.indexOf("{")) != -1) {
            actionGroup = actionGroup.substring(0, pos);
        }
        String debugMessage = "&8[&c" + event + playerInfo + "&8] ";
        debugMessage = actionGroup.equals("cooldown") ? MessagesManager.getColoredMessage(debugMessage + "&7Cooldown present, overriding.") : (actionGroup.equals("one_time") ? MessagesManager.getColoredMessage(debugMessage + "&7One Time present, overriding.") : MessagesManager.getColoredMessage(debugMessage + "&7Executing actions from action group: &f" + actionGroup));
        for (DebugSender debugSender : this.debugSenders) {
            if (!debugSender.getEvent().equals(event) || player != null && debugSender.getPlayerName() != null && !debugSender.getPlayerName().equals(player.getName())) continue;
            debugSender.getSender().sendMessage(debugMessage);
        }
    }

    public void sendActionMessage(String event, String actionLine, LivingEntity livingEntity, ActionType actionType, ActionTargeter actionTargeter) {
        if (this.debugSenders.isEmpty()) {
            return;
        }
        String playerInfo = "";
        if (livingEntity != null) {
            playerInfo = livingEntity instanceof Player ? "," + livingEntity.getName() : "," + livingEntity.getType().name();
        }
        String actionTargeterInfo = "";
        if (!actionTargeter.getType().equals((Object)ActionTargeterType.NORMAL)) {
            actionTargeterInfo = actionTargeter.getParameter() == null ? " &6(" + (Object)((Object)actionTargeter.getType()) + ")" : " &6(" + (Object)((Object)actionTargeter.getType()) + " " + actionTargeter.getParameter() + ")";
        }
        String debugMessage = MessagesManager.getColoredMessage("&8[&c" + event + playerInfo + ",&eaction&8] &7Executing action:" + actionTargeterInfo + " &6[" + (Object)((Object)actionType) + "&6] &f") + actionLine;
        for (DebugSender debugSender : this.debugSenders) {
            if (!debugSender.getEvent().equals(event) || livingEntity instanceof Player && debugSender.getPlayerName() != null && !debugSender.getPlayerName().equals(livingEntity.getName())) continue;
            debugSender.getSender().sendMessage(debugMessage);
        }
    }
}

