/*
 * Decompiled with CFR 0.152.
 */
package ce.ajneb97.managers;

import ce.ajneb97.ConditionalEvents;
import ce.ajneb97.model.internal.WaitActionTask;
import java.util.ArrayList;
import org.bukkit.scheduler.BukkitTask;

public class InterruptEventManager {
    private ConditionalEvents plugin;
    private ArrayList<WaitActionTask> tasks;

    public InterruptEventManager(ConditionalEvents plugin) {
        this.plugin = plugin;
        this.tasks = new ArrayList();
    }

    public void addTask(String playerName, String eventName, BukkitTask bukkitTask) {
        this.tasks.add(new WaitActionTask(playerName, eventName, bukkitTask));
    }

    public void removeTaskById(int taskId) {
        this.tasks.removeIf(task -> task.getTask().getTaskId() == taskId);
    }

    public void interruptEvent(String eventName, String playerName) {
        this.tasks.removeIf(task -> {
            if (playerName == null) {
                if (task.getEventName().equals(eventName)) {
                    task.getTask().cancel();
                    return true;
                }
            } else if (task.getPlayerName() != null && task.getPlayerName().equals(playerName) && task.getEventName().equals(eventName)) {
                task.getTask().cancel();
                return true;
            }
            return false;
        });
    }
}

