/*
 * Decompiled with CFR 0.152.
 */
package ce.ajneb97.utils;

import ce.ajneb97.ConditionalEvents;
import ce.ajneb97.api.ConditionalEventsAPI;
import ce.ajneb97.managers.MessagesManager;
import ce.ajneb97.utils.OtherUtils;
import ce.ajneb97.utils.ServerVersion;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;

public class ItemUtils {
    public static ItemStack createItemFromID(String id) {
        ItemStack item = null;
        if (id.contains(":")) {
            String[] sep = id.split(":");
            Material mat = Material.getMaterial((String)sep[0].toUpperCase());
            item = new ItemStack(mat, 1, Short.parseShort(sep[1]));
        } else {
            Material mat = Material.getMaterial((String)id.toUpperCase());
            item = new ItemStack(mat, 1);
        }
        return item;
    }

    public static ItemStack createItemFromString(String string, Player player) {
        ItemStack item = null;
        if (string.startsWith("e")) {
            item = ItemUtils.createHead();
            ItemUtils.setSkullData(item, string, null, null);
            return item;
        }
        if (string.startsWith("saved_item:")) {
            return ConditionalEventsAPI.getPlugin().getSavedItemsManager().getItem(string.replace("saved_item:", ""), player);
        }
        item = ItemUtils.createItemFromID(string);
        return item;
    }

    public static boolean isAir(Material material) {
        return material.name().contains("_AIR") || material.name().equals("AIR");
    }

    public static ItemStack createHead() {
        if (OtherUtils.isLegacy()) {
            return new ItemStack(Material.valueOf((String)"SKULL_ITEM"), 1, 3);
        }
        return new ItemStack(Material.PLAYER_HEAD);
    }

    public static void setSkullData(ItemStack item, String texture, String id, String owner) {
        String typeName = item.getType().name();
        if (!typeName.equals("PLAYER_HEAD") && !typeName.equals("SKULL_ITEM")) {
            return;
        }
        SkullMeta skullMeta = (SkullMeta)item.getItemMeta();
        if (owner != null) {
            skullMeta.setOwner(owner);
        }
        if (texture != null) {
            ServerVersion serverVersion = ConditionalEvents.serverVersion;
            if (serverVersion.serverVersionGreaterEqualThan(serverVersion, ServerVersion.v1_20_R2)) {
                URL url;
                UUID uuid = id != null ? UUID.fromString(id) : UUID.randomUUID();
                PlayerProfile profile = Bukkit.createPlayerProfile((UUID)uuid, (String)"ce");
                PlayerTextures textures = profile.getTextures();
                try {
                    String decoded = new String(Base64.getDecoder().decode(texture));
                    String decodedFormatted = decoded.replaceAll("\\s", "");
                    JsonObject jsonObject = (JsonObject)new Gson().fromJson(decodedFormatted, JsonObject.class);
                    String urlText = jsonObject.get("textures").getAsJsonObject().get("SKIN").getAsJsonObject().get("url").getAsString();
                    url = new URL(urlText);
                }
                catch (Exception error) {
                    error.printStackTrace();
                    return;
                }
                textures.setSkin(url);
                profile.setTextures(textures);
                skullMeta.setOwnerProfile(profile);
            } else {
                GameProfile profile = null;
                profile = id == null ? new GameProfile(UUID.randomUUID(), owner != null ? owner : "") : new GameProfile(UUID.fromString(id), owner != null ? owner : "");
                profile.getProperties().put((Object)"textures", (Object)new Property("textures", texture));
                try {
                    Field profileField = skullMeta.getClass().getDeclaredField("profile");
                    profileField.setAccessible(true);
                    profileField.set(skullMeta, profile);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException error) {
                    error.printStackTrace();
                }
            }
        }
        item.setItemMeta((ItemMeta)skullMeta);
    }

    public static ItemStack getItemFromProperties(String[] properties, Player player) {
        ServerVersion serverVersion;
        String id = null;
        int amount = 1;
        short durability = 0;
        String name = null;
        ArrayList<String> lore = new ArrayList<String>();
        ArrayList<String> flags = new ArrayList<String>();
        ArrayList<String> enchants = new ArrayList<String>();
        int customModelData = 0;
        String skullTexture = null;
        String skullId = null;
        String skullOwner = null;
        boolean hasCustomModelComponentData = false;
        ArrayList<String> customModelComponentDataStrings = new ArrayList<String>();
        ArrayList<String> customModelComponentDataFlags = new ArrayList<String>();
        ArrayList<String> customModelComponentDataFloats = new ArrayList<String>();
        ArrayList<String> customModelComponentDataColors = new ArrayList<String>();
        String itemModel = null;
        ItemStack savedItem = null;
        for (String property : properties) {
            String[] splitC;
            if (property.startsWith("id:")) {
                id = property.replace("id:", "");
                continue;
            }
            if (property.startsWith("amount:")) {
                amount = Integer.parseInt(property.replace("amount:", ""));
                continue;
            }
            if (property.startsWith("custom_model_data:")) {
                customModelData = Integer.parseInt(property.replace("custom_model_data:", ""));
                continue;
            }
            if (property.startsWith("custom_model_component_data_strings:")) {
                splitC = property.replace("custom_model_component_data_strings:", "").split("\\|");
                customModelComponentDataStrings.addAll(Arrays.asList(splitC));
                hasCustomModelComponentData = true;
                continue;
            }
            if (property.startsWith("custom_model_component_data_floats:")) {
                splitC = property.replace("custom_model_component_data_floats:", "").split("\\|");
                customModelComponentDataFloats.addAll(Arrays.asList(splitC));
                hasCustomModelComponentData = true;
                continue;
            }
            if (property.startsWith("custom_model_component_data_flags:")) {
                splitC = property.replace("custom_model_component_data_flags:", "").split("\\|");
                customModelComponentDataFlags.addAll(Arrays.asList(splitC));
                hasCustomModelComponentData = true;
                continue;
            }
            if (property.startsWith("custom_model_component_data_colors:")) {
                splitC = property.replace("custom_model_component_data_colors:", "").split("\\|");
                customModelComponentDataColors.addAll(Arrays.asList(splitC));
                hasCustomModelComponentData = true;
                continue;
            }
            if (property.startsWith("item_model:")) {
                itemModel = property.replace("item_model:", "");
                continue;
            }
            if (property.startsWith("durability:")) {
                durability = Short.parseShort(property.replace("durability:", ""));
                continue;
            }
            if (property.startsWith("name:")) {
                name = property.replace("name:", "");
                continue;
            }
            if (property.startsWith("lore:")) {
                String[] splitLore;
                for (String loreLine : splitLore = property.replace("lore:", "").split("\\|")) {
                    lore.add(loreLine);
                }
                continue;
            }
            if (property.startsWith("enchants:")) {
                String[] splitEnchants;
                for (String enchantLine : splitEnchants = property.replace("enchants:", "").split("\\|")) {
                    String[] splitEnchants2 = enchantLine.split("-");
                    enchants.add(splitEnchants2[0] + ";" + splitEnchants2[1]);
                }
                continue;
            }
            if (property.startsWith("flags:")) {
                String[] splitFlags;
                for (String flagLine : splitFlags = property.replace("flags:", "").split("\\|")) {
                    flags.add(flagLine);
                }
                continue;
            }
            if (property.startsWith("skull_texture:")) {
                skullTexture = property.replace("skull_texture:", "");
                continue;
            }
            if (property.startsWith("skull_owner:")) {
                skullOwner = property.replace("skull_owner:", "");
                continue;
            }
            if (property.startsWith("skull_id")) {
                skullId = property.replace("skull_id:", "");
                continue;
            }
            if (!property.startsWith("saved_item")) continue;
            savedItem = ConditionalEventsAPI.getPlugin().getSavedItemsManager().getItem(property.replace("saved_item:", ""), player);
        }
        if (savedItem != null) {
            savedItem.setAmount(amount);
            return savedItem;
        }
        ItemStack item = ItemUtils.createItemFromID(id);
        item.setAmount(amount);
        if (durability != 0) {
            item.setDurability(durability);
        }
        ItemMeta meta = item.getItemMeta();
        if (name != null) {
            meta.setDisplayName(MessagesManager.getColoredMessage(name));
        }
        if (!lore.isEmpty()) {
            ArrayList<String> loreCopy = new ArrayList<String>(lore);
            for (int i = 0; i < loreCopy.size(); ++i) {
                loreCopy.set(i, MessagesManager.getColoredMessage((String)loreCopy.get(i)));
            }
            meta.setLore(loreCopy);
        }
        if (customModelData != 0) {
            meta.setCustomModelData(Integer.valueOf(customModelData));
        }
        if ((serverVersion = ConditionalEvents.serverVersion).serverVersionGreaterEqualThan(serverVersion, ServerVersion.v1_21_R3) && hasCustomModelComponentData) {
            CustomModelDataComponent customModelDataComponent = meta.getCustomModelDataComponent();
            customModelDataComponent.setFlags(customModelComponentDataFlags.stream().map(Boolean::parseBoolean).collect(Collectors.toList()));
            customModelDataComponent.setFloats(customModelComponentDataFloats.stream().map(Float::parseFloat).collect(Collectors.toList()));
            customModelDataComponent.setColors(customModelComponentDataColors.stream().map(rgb -> Color.fromRGB((int)Integer.parseInt(rgb))).collect(Collectors.toList()));
            customModelDataComponent.setStrings(new ArrayList(customModelComponentDataStrings));
            meta.setCustomModelDataComponent(customModelDataComponent);
        }
        if (serverVersion.serverVersionGreaterEqualThan(serverVersion, ServerVersion.v1_21_R3) && itemModel != null) {
            String[] sep = itemModel.split("\\|");
            meta.setItemModel(new NamespacedKey(sep[0], sep[1]));
        }
        if (!enchants.isEmpty()) {
            for (int i = 0; i < enchants.size(); ++i) {
                String[] sep2 = ((String)enchants.get(i)).split(";");
                String enchantName = sep2[0];
                int enchantLevel = Integer.valueOf(sep2[1]);
                meta.addEnchant(Enchantment.getByName((String)enchantName), enchantLevel, true);
            }
        }
        if (!flags.isEmpty()) {
            for (int i = 0; i < flags.size(); ++i) {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.valueOf((String)((String)flags.get(i)))});
            }
        }
        item.setItemMeta(meta);
        ItemUtils.setSkullData(item, skullTexture, skullId, skullOwner);
        return item;
    }
}

