/*
 * Decompiled with CFR 0.152.
 */
package ce.ajneb97.model.internal;

import ce.ajneb97.ConditionalEvents;
import ce.ajneb97.configs.MainConfigManager;
import ce.ajneb97.model.CEEvent;
import ce.ajneb97.model.EventType;
import ce.ajneb97.model.StoredVariable;
import ce.ajneb97.utils.BlockUtils;
import ce.ajneb97.utils.OtherUtils;
import ce.ajneb97.utils.ServerVersion;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ConditionEvent {
    private ConditionalEvents plugin;
    private Player player;
    private LivingEntity target;
    private ArrayList<StoredVariable> eventVariables;
    private Event minecraftEvent;
    private EventType eventType;
    private CEEvent currentEvent;
    private boolean async;

    public ConditionEvent(ConditionalEvents plugin, Player player, Event minecraftEvent, EventType eventType, LivingEntity target) {
        this.plugin = plugin;
        this.player = player;
        this.eventVariables = new ArrayList();
        this.minecraftEvent = minecraftEvent;
        this.eventType = eventType;
        this.target = target;
        this.async = false;
    }

    public Player getPlayer() {
        return this.player;
    }

    public LivingEntity getTarget() {
        return this.target;
    }

    public ArrayList<StoredVariable> getEventVariables() {
        return this.eventVariables;
    }

    public Event getMinecraftEvent() {
        return this.minecraftEvent;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public CEEvent getCurrentEvent() {
        return this.currentEvent;
    }

    public void setCurrentEvent(CEEvent currentEvent) {
        this.currentEvent = currentEvent;
    }

    public void checkEvent() {
        this.plugin.getEventsManager().checkEvent(this);
    }

    public boolean containsValidEvents() {
        ArrayList<CEEvent> validEvents = this.plugin.getEventsManager().getValidEvents(this.eventType);
        return validEvents.size() != 0;
    }

    public ConditionEvent addVariables(StoredVariable ... storedVariables) {
        for (StoredVariable v : storedVariables) {
            this.eventVariables.add(v);
        }
        return this;
    }

    public ConditionEvent addVariables(ArrayList<StoredVariable> storedVariables) {
        this.eventVariables.addAll(storedVariables);
        return this;
    }

    public ConditionEvent setCommonBlockVariables(Block block) {
        Location l = block.getLocation();
        this.eventVariables.add(new StoredVariable("%block_x%", l.getBlockX() + ""));
        this.eventVariables.add(new StoredVariable("%block_y%", l.getBlockY() + ""));
        this.eventVariables.add(new StoredVariable("%block_z%", l.getBlockZ() + ""));
        this.eventVariables.add(new StoredVariable("%block_world%", l.getWorld().getName()));
        this.eventVariables.add(new StoredVariable("%block%", block.getType().name()));
        this.eventVariables.add(new StoredVariable("%block_head_texture%", BlockUtils.getHeadTextureData(block)));
        if (OtherUtils.isLegacy()) {
            this.eventVariables.add(new StoredVariable("%block_data%", block.getData() + ""));
        } else {
            this.eventVariables.add(new StoredVariable("%block_data%", BlockUtils.getBlockDataStringFromObject(block.getBlockData())));
        }
        return this;
    }

    public ConditionEvent setCommonActionVariables(Action action, Player player) {
        String actionVariable = null;
        String actionName = action.name();
        if (player.isSneaking()) {
            if (actionName.contains("RIGHT_CLICK")) {
                actionVariable = "SHIFT_RIGHT_CLICK";
            } else if (actionName.contains("LEFT_CLICK")) {
                actionVariable = "SHIFT_LEFT_CLICK";
            } else if (action.equals((Object)Action.PHYSICAL)) {
                actionVariable = "PHYSICAL";
            }
        } else if (actionName.contains("RIGHT_CLICK")) {
            actionVariable = "RIGHT_CLICK";
        } else if (actionName.contains("LEFT_CLICK")) {
            actionVariable = "LEFT_CLICK";
        } else if (action.equals((Object)Action.PHYSICAL)) {
            actionVariable = "PHYSICAL";
        }
        if (actionVariable != null) {
            this.eventVariables.add(new StoredVariable("%action_type%", actionVariable));
        }
        return this;
    }

    public ConditionEvent setCommonVictimVariables(Entity entity) {
        String victimType = entity.getType().name();
        String victimName = "";
        String victimNameColorFormat = "";
        String victimUuid = entity.getUniqueId().toString();
        if (entity.getCustomName() != null) {
            if (this.plugin.getConfigsManager().getMainConfigManager().isUseMiniMessage()) {
                victimName = PlainTextComponentSerializer.plainText().serialize(entity.customName());
                victimNameColorFormat = (String)MiniMessage.miniMessage().serialize(entity.customName());
            } else {
                victimName = ChatColor.stripColor((String)entity.getCustomName());
                victimNameColorFormat = entity.getCustomName().replace("\u00a7", "&");
            }
        }
        Location location = entity.getLocation();
        double health = 0.0;
        if (entity instanceof LivingEntity) {
            health = ((LivingEntity)entity).getHealth();
        }
        this.eventVariables.add(new StoredVariable("%victim%", victimType));
        this.eventVariables.add(new StoredVariable("%victim_name%", victimName));
        this.eventVariables.add(new StoredVariable("%victim_health%", health + ""));
        this.eventVariables.add(new StoredVariable("%victim_color_format_name%", victimNameColorFormat));
        this.eventVariables.add(new StoredVariable("%victim_block_x%", location.getBlockX() + ""));
        this.eventVariables.add(new StoredVariable("%victim_block_y%", location.getBlockY() + ""));
        this.eventVariables.add(new StoredVariable("%victim_block_z%", location.getBlockZ() + ""));
        this.eventVariables.add(new StoredVariable("%victim_block_world%", location.getWorld().getName()));
        this.eventVariables.add(new StoredVariable("%victim_uuid%", victimUuid));
        return this;
    }

    public ConditionEvent setCommonItemVariables(ItemStack item, String otherItemTag) {
        int i;
        String name = "";
        String colorFormatName = "";
        String material = "";
        String loreString = "";
        String colorFormatLoreString = "";
        short durability = 0;
        int amount = 0;
        ArrayList<String> loreList = new ArrayList<String>();
        ArrayList<String> colorFormatLoreList = new ArrayList<String>();
        int customModelData = 0;
        String itemModel = "";
        String metaString = "";
        if (item != null) {
            durability = item.getDurability();
            material = item.getType().name();
            amount = item.getAmount();
            if (item.hasItemMeta()) {
                ItemMeta meta = item.getItemMeta();
                MainConfigManager mainConfigManager = this.plugin.getConfigsManager().getMainConfigManager();
                boolean itemMetaVariableEnabled = mainConfigManager.isItemMetaVariableEnabled();
                boolean useMiniMessage = mainConfigManager.isUseMiniMessage();
                metaString = itemMetaVariableEnabled ? meta.toString() : "variable disabled";
                if (meta.hasDisplayName()) {
                    if (useMiniMessage) {
                        name = PlainTextComponentSerializer.plainText().serialize(meta.displayName());
                        colorFormatName = (String)MiniMessage.miniMessage().serialize(meta.displayName());
                    } else {
                        name = ChatColor.stripColor((String)meta.getDisplayName());
                        colorFormatName = meta.getDisplayName().replace("\u00a7", "&");
                    }
                }
                if (meta.hasLore()) {
                    List lore;
                    if (useMiniMessage) {
                        lore = meta.lore();
                        PlainTextComponentSerializer plainTextComponentSerializer = PlainTextComponentSerializer.plainText();
                        MiniMessage miniMessage = MiniMessage.miniMessage();
                        for (int i2 = 0; i2 < lore.size(); ++i2) {
                            String plainFormat = plainTextComponentSerializer.serialize((Component)lore.get(i2));
                            String tagFormat = (String)miniMessage.serialize((Component)lore.get(i2));
                            loreList.add(plainFormat);
                            colorFormatLoreList.add(tagFormat);
                            if (i2 == lore.size() - 1) {
                                loreString = loreString + plainFormat;
                                colorFormatLoreString = colorFormatLoreString + tagFormat;
                                continue;
                            }
                            loreString = loreString + plainFormat + " ";
                            colorFormatLoreString = colorFormatLoreString + tagFormat + " ";
                        }
                    } else {
                        lore = meta.getLore();
                        for (int i3 = 0; i3 < lore.size(); ++i3) {
                            loreList.add(ChatColor.stripColor((String)((String)lore.get(i3))));
                            colorFormatLoreList.add(((String)lore.get(i3)).replace("\u00a7", "&"));
                            if (i3 == lore.size() - 1) {
                                loreString = loreString + ChatColor.stripColor((String)((String)lore.get(i3)));
                                colorFormatLoreString = colorFormatLoreString + ((String)lore.get(i3)).replace("\u00a7", "&");
                                continue;
                            }
                            loreString = loreString + ChatColor.stripColor((String)((String)lore.get(i3))) + " ";
                            colorFormatLoreString = colorFormatLoreString + ((String)lore.get(i3)).replace("\u00a7", "&") + " ";
                        }
                    }
                }
                ServerVersion serverVersion = ConditionalEvents.serverVersion;
                if (OtherUtils.isNew() && meta.hasCustomModelData() && !serverVersion.serverVersionGreaterEqualThan(serverVersion, ServerVersion.v1_21_R3)) {
                    customModelData = meta.getCustomModelData();
                }
                if (serverVersion.serverVersionGreaterEqualThan(serverVersion, ServerVersion.v1_21_R3) && meta.hasItemModel()) {
                    NamespacedKey key = meta.getItemModel();
                    itemModel = key.getNamespace() + ":" + key.getKey();
                }
            }
        }
        otherItemTag = otherItemTag == null ? "%" : "%" + otherItemTag + ":";
        this.eventVariables.add(new StoredVariable(otherItemTag + "item%", material));
        this.eventVariables.add(new StoredVariable(otherItemTag + "item_name%", name));
        this.eventVariables.add(new StoredVariable(otherItemTag + "item_color_format_name%", colorFormatName));
        this.eventVariables.add(new StoredVariable(otherItemTag + "item_durability%", durability + ""));
        this.eventVariables.add(new StoredVariable(otherItemTag + "item_amount%", amount + ""));
        this.eventVariables.add(new StoredVariable(otherItemTag + "item_lore%", loreString));
        this.eventVariables.add(new StoredVariable(otherItemTag + "item_color_format_lore%", colorFormatLoreString));
        this.eventVariables.add(new StoredVariable(otherItemTag + "item_custom_model_data%", customModelData + ""));
        this.eventVariables.add(new StoredVariable(otherItemTag + "item_model%", itemModel));
        this.eventVariables.add(new StoredVariable(otherItemTag + "item_meta%", metaString));
        for (i = 0; i < loreList.size(); ++i) {
            this.eventVariables.add(new StoredVariable(otherItemTag + "item_lore_line_" + (i + 1) + "%", (String)loreList.get(i)));
        }
        for (i = 0; i < colorFormatLoreList.size(); ++i) {
            this.eventVariables.add(new StoredVariable(otherItemTag + "item_color_format_lore_line_" + (i + 1) + "%", (String)colorFormatLoreList.get(i)));
        }
        return this;
    }

    public ConditionEvent setCommonEntityVariables(Entity entity) {
        String entityType = entity.getType().name();
        String entityName = "";
        String entityNameColorFormat = "";
        String entityUuid = entity.getUniqueId().toString();
        if (entity.getCustomName() != null) {
            if (this.plugin.getConfigsManager().getMainConfigManager().isUseMiniMessage()) {
                entityName = PlainTextComponentSerializer.plainText().serialize(entity.customName());
                entityNameColorFormat = (String)MiniMessage.miniMessage().serialize(entity.customName());
            } else {
                entityName = ChatColor.stripColor((String)entity.getCustomName());
                entityNameColorFormat = entity.getCustomName().replace("\u00a7", "&");
            }
        }
        Location location = entity.getLocation();
        this.eventVariables.add(new StoredVariable("%entity%", entityType));
        this.eventVariables.add(new StoredVariable("%entity_name%", entityName));
        this.eventVariables.add(new StoredVariable("%entity_color_format_name%", entityNameColorFormat));
        this.eventVariables.add(new StoredVariable("%entity_x%", location.getBlockX() + ""));
        this.eventVariables.add(new StoredVariable("%entity_y%", location.getBlockY() + ""));
        this.eventVariables.add(new StoredVariable("%entity_z%", location.getBlockZ() + ""));
        this.eventVariables.add(new StoredVariable("%entity_world%", location.getWorld().getName()));
        this.eventVariables.add(new StoredVariable("%entity_uuid%", entityUuid));
        return this;
    }

    public boolean isAsync() {
        return this.async;
    }

    public ConditionEvent setAsync(boolean async) {
        this.async = async;
        return this;
    }
}

