/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.avmmod.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.mcreator.avmmod.client.model.Modelcobwebstaffprojectile;
import net.mcreator.avmmod.entity.CobwebProjectileEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Quaternionfc;

public class CobwebProjectileRenderer
extends EntityRenderer<CobwebProjectileEntity, LivingEntityRenderState> {
    private static final ResourceLocation texture = ResourceLocation.parse((String)"avm_mod:textures/entities/cobwebprojectile.png");
    private final Modelcobwebstaffprojectile model;

    public CobwebProjectileRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new Modelcobwebstaffprojectile(context.bakeLayer(Modelcobwebstaffprojectile.LAYER_LOCATION));
    }

    public void render(LivingEntityRenderState state, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        VertexConsumer vb = bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)texture));
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(state.yRot - 90.0f));
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(90.0f + state.xRot));
        this.model.setupAnim(state);
        this.model.renderToBuffer(poseStack, vb, packedLightIn, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        super.render((EntityRenderState)state, poseStack, bufferIn, packedLightIn);
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(CobwebProjectileEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((Entity)entity, (EntityRenderState)state, partialTicks);
        state.xRot = entity.getXRot(partialTicks);
        state.yRot = entity.getYRot(partialTicks);
    }
}

