/*
 * Decompiled with CFR 0.152.
 */
package com.tpautilities;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.tpautilities.JsonHandler;
import com.tpautilities.LanguageSuggestionProvider;
import com.tpautilities.PlayerData;
import com.tpautilities.StateSaverAndLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5454;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPAUtilities
implements ModInitializer {
    private static final String MOD_ID = "tpa-utilities";
    private static final ConcurrentHashMap<UUID, Queue<UUID>> playerTPAMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<UUID, Queue<UUID>> playerTPAHEREMap = new ConcurrentHashMap();
    private static final List<ScheduledExecutorService> schedulers = new ArrayList<ScheduledExecutorService>();
    private static final List<UUID> lockedTPAPlayers = new ArrayList<UUID>();
    private static JsonObject translations = new JsonObject();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"tpa-utilities");

    public static String getMOD_ID() {
        return MOD_ID;
    }

    public static Set<String> listTranslations() {
        return translations.keySet();
    }

    public static String getTranslation(String language, String sentence) {
        if (!translations.has(language)) {
            return "(Error : there is a problem in the tpa_translations.json, please delete the file and restart the server or correct your translation)";
        }
        return translations.get(language).getAsJsonObject().get(sentence).getAsString();
    }

    public void onInitialize() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"tpa").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(this::tpaExecute))));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"tpahere").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(this::tpahereExecute))));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"tpaccept").executes(this::tpacceptExecute)));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"tpadeny").executes(this::tpadenyExecute)));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"tpacancel").executes(this::tpacancelExecute)));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"tpalock").executes(this::tpalockExecute)));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"tpalanguage").then(class_2170.method_9244((String)"language", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new LanguageSuggestionProvider()).executes(this::tpalanguageExecute))));
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            for (ScheduledExecutorService scheduler : schedulers) {
                LOGGER.info("TPA Utilities is shutting down a scheduler, please wait...");
                scheduler.shutdownNow();
            }
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            translations = JsonHandler.loadTranslations(server);
        });
        LOGGER.info("TPA Utilities has been loaded successfully!");
    }

    private int tpaExecute(CommandContext<class_2168> context) throws CommandSyntaxException {
        if (((class_2168)context.getSource()).method_43737()) {
            UUID player_uuid = Objects.requireNonNull(((class_2168)context.getSource()).method_44023()).method_5667();
            String player_name = ((class_2168)context.getSource()).method_44023().method_5477().getString();
            UUID target_uuid = class_2186.method_9315(context, (String)"player").method_5667();
            String player_language = StateSaverAndLoader.getPlayerState((class_1309)((class_2168)context.getSource()).method_44023()).getLanguage();
            String target_language = StateSaverAndLoader.getPlayerState((class_1309)class_2186.method_9315(context, (String)"player")).getLanguage();
            if (((class_2168)context.getSource()).method_44023().method_5667() == target_uuid) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)TPAUtilities.getTranslation(player_language, "error_tpa_yourself")).method_27692(class_124.field_1061), false);
                return 1;
            }
            if (lockedTPAPlayers.contains(target_uuid)) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)TPAUtilities.getTranslation(player_language, "error_tpa_disabled")).method_27692(class_124.field_1061), false);
                return 1;
            }
            if (playerTPAMap.containsKey(target_uuid)) {
                if (playerTPAMap.get(target_uuid).contains(player_uuid)) {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)TPAUtilities.getTranslation(player_language, "error_tpa_already_asked")).method_27692(class_124.field_1061), false);
                    return 1;
                }
                playerTPAMap.get(target_uuid).add(player_uuid);
            } else {
                LinkedList<UUID> newStack = new LinkedList<UUID>();
                newStack.add(player_uuid);
                playerTPAMap.put(target_uuid, newStack);
            }
            class_3222 player_target = ((class_2168)context.getSource()).method_9211().method_3760().method_14602(target_uuid);
            assert (player_target != null);
            player_target.method_64398((class_2561)class_2561.method_43470((String)String.format(TPAUtilities.getTranslation(target_language, "wants_tpa_teleport"), player_name)).method_27692(class_124.field_1065).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/tpaccept"))));
            player_target.method_17356(class_3417.field_26979, class_3419.field_15250, 1.0f, 1.0f);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)TPAUtilities.getTranslation(player_language, "tpa_sent")).method_27692(class_124.field_1060), false);
            ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
            schedulers.add(scheduler);
            scheduler.schedule(() -> {
                if (playerTPAMap.containsKey(target_uuid) && playerTPAMap.get(target_uuid).contains(player_uuid)) {
                    playerTPAMap.get(target_uuid).remove(player_uuid);
                    if (playerTPAMap.get(target_uuid).isEmpty()) {
                        playerTPAMap.remove(target_uuid);
                    }
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)TPAUtilities.getTranslation(player_language, "tpa_expired")).method_27692(class_124.field_1061), false);
                }
                schedulers.remove(scheduler);
                scheduler.shutdown();
            }, 60L, TimeUnit.SECONDS);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"This command can't be called by server.").method_27692(class_124.field_1061), false);
        }
        return 1;
    }

    private int tpahereExecute(CommandContext<class_2168> context) throws CommandSyntaxException {
        if (((class_2168)context.getSource()).method_43737()) {
            UUID player_uuid = Objects.requireNonNull(((class_2168)context.getSource()).method_44023()).method_5667();
            String player_name = ((class_2168)context.getSource()).method_44023().method_5477().getString();
            UUID target_uuid = class_2186.method_9315(context, (String)"player").method_5667();
            String player_language = StateSaverAndLoader.getPlayerState((class_1309)((class_2168)context.getSource()).method_44023()).getLanguage();
            String target_language = StateSaverAndLoader.getPlayerState((class_1309)class_2186.method_9315(context, (String)"player")).getLanguage();
            if (((class_2168)context.getSource()).method_44023().method_5667() == target_uuid) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)TPAUtilities.getTranslation(player_language, "error_tpahere_yourself")).method_27692(class_124.field_1061), false);
                return 1;
            }
            if (lockedTPAPlayers.contains(target_uuid)) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)TPAUtilities.getTranslation(player_language, "error_tpahere_disabled")).method_27692(class_124.field_1061), false);
                return 1;
            }
            if (playerTPAHEREMap.containsKey(target_uuid)) {
                if (playerTPAHEREMap.get(target_uuid).contains(player_uuid)) {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)TPAUtilities.getTranslation(player_language, "error_tpahere_already_asked")).method_27692(class_124.field_1061), false);
                    return 1;
                }
                playerTPAHEREMap.get(target_uuid).add(player_uuid);
            } else {
                LinkedList<UUID> newStack = new LinkedList<UUID>();
                newStack.add(player_uuid);
                playerTPAHEREMap.put(target_uuid, newStack);
            }
            class_3222 player_target = ((class_2168)context.getSource()).method_9211().method_3760().method_14602(target_uuid);
            assert (player_target != null);
            player_target.method_64398((class_2561)class_2561.method_43470((String)String.format(TPAUtilities.getTranslation(target_language, "wants_tpahere_teleport"), player_name)).method_27692(class_124.field_1065).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/tpaccept"))));
            player_target.method_17356(class_3417.field_43154, class_3419.field_15250, 1.0f, 1.0f);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)TPAUtilities.getTranslation(player_language, "tpa_here_sent")).method_27692(class_124.field_1060), false);
            ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
            schedulers.add(scheduler);
            scheduler.schedule(() -> {
                if (playerTPAHEREMap.containsKey(target_uuid) && playerTPAHEREMap.get(target_uuid).contains(player_uuid)) {
                    playerTPAHEREMap.get(target_uuid).remove(player_uuid);
                    if (playerTPAHEREMap.get(target_uuid).isEmpty()) {
                        playerTPAHEREMap.remove(target_uuid);
                    }
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)TPAUtilities.getTranslation(player_language, "tpahere_expired")).method_27692(class_124.field_1061), false);
                    ((class_2168)context.getSource()).method_44023().method_17356(class_3417.field_15008, class_3419.field_15250, 1.0f, 1.0f);
                }
                schedulers.remove(scheduler);
                scheduler.shutdown();
            }, 60L, TimeUnit.SECONDS);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"This command can't be called by server.").method_27692(class_124.field_1061), false);
        }
        return 1;
    }

    private int tpacceptExecute(CommandContext<class_2168> context) {
        if (((class_2168)context.getSource()).method_43737()) {
            class_3222 player = Objects.requireNonNull(((class_2168)context.getSource()).method_44023());
            String player_language = StateSaverAndLoader.getPlayerState((class_1309)player).getLanguage();
            if (playerTPAMap.containsKey(player.method_5667())) {
                UUID target_uuid = playerTPAMap.get(player.method_5667()).poll();
                class_3222 target_player = Objects.requireNonNull(((class_2168)context.getSource()).method_9211().method_3760().method_14602(target_uuid));
                String target_language = StateSaverAndLoader.getPlayerState((class_1309)target_player).getLanguage();
                class_5454 teleport_target = new class_5454(player.method_51469(), player.method_19538(), target_player.method_18798(), target_player.method_36454(), target_player.method_36455(), class_5454.field_52247);
                target_player.method_61275(teleport_target);
                if (playerTPAMap.get(player.method_5667()).isEmpty()) {
                    playerTPAMap.remove(player.method_5667());
                }
                target_player.method_64398((class_2561)class_2561.method_43470((String)TPAUtilities.getTranslation(target_language, "teleport_success")).method_27692(class_124.field_1060));
                target_player.method_17356(class_3417.field_15210, class_3419.field_15250, 1.0f, 1.0f);
            } else if (playerTPAHEREMap.containsKey(player.method_5667())) {
                UUID target_uuid = playerTPAHEREMap.get(player.method_5667()).poll();
                class_3222 target_player = Objects.requireNonNull(((class_2168)context.getSource()).method_9211().method_3760().method_14602(target_uuid));
                class_5454 teleport_target = new class_5454(target_player.method_51469(), target_player.method_19538(), player.method_18798(), player.method_36454(), player.method_36455(), class_5454.field_52247);
                player.method_61275(teleport_target);
                if (playerTPAHEREMap.get(player.method_5667()).isEmpty()) {
                    playerTPAHEREMap.remove(player.method_5667());
                }
                player.method_64398((class_2561)class_2561.method_43470((String)TPAUtilities.getTranslation(player_language, "teleport_success")).method_27692(class_124.field_1060));
                player.method_17356(class_3417.field_15210, class_3419.field_15250, 1.0f, 1.0f);
            } else {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)TPAUtilities.getTranslation(player_language, "error_tpaccept")).method_27692(class_124.field_1061), false);
            }
        } else {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"This command can't be called by server.").method_27692(class_124.field_1061), false);
        }
        return 1;
    }

    private int tpadenyExecute(CommandContext<class_2168> context) {
        if (((class_2168)context.getSource()).method_43737()) {
            class_3222 player = Objects.requireNonNull(((class_2168)context.getSource()).method_44023());
            String player_language = StateSaverAndLoader.getPlayerState((class_1309)player).getLanguage();
            if (playerTPAMap.containsKey(player.method_5667())) {
                UUID target_uuid = playerTPAMap.get(player.method_5667()).poll();
                class_3222 target_player = Objects.requireNonNull(((class_2168)context.getSource()).method_9211().method_3760().method_14602(target_uuid));
                String target_language = StateSaverAndLoader.getPlayerState((class_1309)target_player).getLanguage();
                if (playerTPAMap.get(player.method_5667()).isEmpty()) {
                    playerTPAMap.remove(player.method_5667());
                }
                target_player.method_64398((class_2561)class_2561.method_43470((String)TPAUtilities.getTranslation(target_language, "tpa_refused")).method_27692(class_124.field_1061));
                target_player.method_17356(class_3417.field_15008, class_3419.field_15250, 1.0f, 1.0f);
            } else if (playerTPAHEREMap.containsKey(player.method_5667())) {
                UUID target_uuid = playerTPAHEREMap.get(player.method_5667()).poll();
                class_3222 target_player = Objects.requireNonNull(((class_2168)context.getSource()).method_9211().method_3760().method_14602(target_uuid));
                String target_language = StateSaverAndLoader.getPlayerState((class_1309)target_player).getLanguage();
                if (playerTPAHEREMap.get(player.method_5667()).isEmpty()) {
                    playerTPAHEREMap.remove(player.method_5667());
                }
                target_player.method_64398((class_2561)class_2561.method_43470((String)TPAUtilities.getTranslation(target_language, "tpahere_refused")).method_27692(class_124.field_1061));
                target_player.method_17356(class_3417.field_15008, class_3419.field_15250, 1.0f, 1.0f);
            } else {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)TPAUtilities.getTranslation(player_language, "error_tpadeny")).method_27692(class_124.field_1061), false);
            }
        } else {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"This command can't be called by server.").method_27692(class_124.field_1061), false);
        }
        return 1;
    }

    private int tpacancelExecute(CommandContext<class_2168> context) {
        UUID player_uuid = Objects.requireNonNull(((class_2168)context.getSource()).method_44023()).method_5667();
        String player_language = StateSaverAndLoader.getPlayerState((class_1309)((class_2168)context.getSource()).method_44023()).getLanguage();
        ArrayList<UUID> keysTPA = Collections.list(playerTPAMap.keys());
        ArrayList<UUID> keysTPAHERE = Collections.list(playerTPAHEREMap.keys());
        for (UUID target_uuid : keysTPA) {
            playerTPAMap.get(target_uuid).remove(player_uuid);
            if (!playerTPAMap.get(target_uuid).isEmpty()) continue;
            playerTPAMap.remove(target_uuid);
        }
        for (UUID target_uuid : keysTPAHERE) {
            playerTPAHEREMap.get(target_uuid).remove(player_uuid);
            if (!playerTPAHEREMap.get(target_uuid).isEmpty()) continue;
            playerTPAHEREMap.remove(target_uuid);
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)TPAUtilities.getTranslation(player_language, "tpacancel_success")).method_27692(class_124.field_1060), false);
        return 1;
    }

    private int tpalockExecute(CommandContext<class_2168> context) {
        UUID player_uuid = Objects.requireNonNull(((class_2168)context.getSource()).method_44023()).method_5667();
        String player_language = StateSaverAndLoader.getPlayerState((class_1309)((class_2168)context.getSource()).method_44023()).getLanguage();
        if (lockedTPAPlayers.contains(player_uuid)) {
            lockedTPAPlayers.remove(player_uuid);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)TPAUtilities.getTranslation(player_language, "tpalock_activated")).method_27692(class_124.field_1060), false);
        } else {
            lockedTPAPlayers.add(player_uuid);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)TPAUtilities.getTranslation(player_language, "tpalock_deactivated")).method_27692(class_124.field_1060), false);
        }
        return 1;
    }

    private int tpalanguageExecute(CommandContext<class_2168> context) {
        PlayerData playerData = StateSaverAndLoader.getPlayerState((class_1309)Objects.requireNonNull(((class_2168)context.getSource()).method_44023()));
        String new_language = StringArgumentType.getString(context, (String)"language");
        if (translations.has(new_language)) {
            playerData.setLanguage(new_language);
            StateSaverAndLoader.saveState(Objects.requireNonNull(((class_2168)context.getSource()).method_9211()));
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)TPAUtilities.getTranslation(playerData.getLanguage(), "tpalanguage_success")).method_27692(class_124.field_1060), false);
            ((class_2168)context.getSource()).method_44023().method_17356(class_3417.field_14709, class_3419.field_15250, 1.0f, 1.0f);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)TPAUtilities.getTranslation(playerData.getLanguage(), "tpalanguage_failure")).method_27692(class_124.field_1061), false);
            ((class_2168)context.getSource()).method_44023().method_17356(class_3417.field_15008, class_3419.field_15250, 1.0f, 1.0f);
        }
        return 1;
    }
}

