package io.github.viciscat.guiscalekey;

import io.github.viciscat.guiscalekey.platform.Services;
import java.util.function.Consumer;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_6599;
import net.minecraft.class_7172;

// This class is part of the common project meaning it is shared between all supported loaders. Code written here can only
// import and access the vanilla codebase, libraries used by vanilla, and optionally third party libraries that provide
// common compatible binaries. This means common code can not directly use loader specific concepts such as Forge events
// however it will be compatible with all supported mod loaders.
public class CommonClass {

    // The loader specific projects are able to import and use any code from the common project. This allows you to
    // write the majority of your code here and load it from your loader specific projects. This example has some
    // code that gets invoked by the entry point of the loader specific projects.
    public static void init() {

        Constants.LOG.info("Starting GuiScaleKeys mod on {}!", Services.PLATFORM.getPlatformName());
        //Constants.LOG.info("The ID for diamonds is {}", BuiltInRegistries.ITEM.getKey(Items.DIAMOND));

        // It is common for all supported loaders to provide a similar feature that can not be used directly in the
        // common code. A popular way to get around this is using Java's built-in service loader feature to create
        // your own abstraction layer. You can learn more about this in our provided services class. In this example
        // we have an interface in the common code and use a loader specific implementation to delegate our call to
        // the platform specific approach.
        /*if (Services.PLATFORM.isModLoaded("guiscalekey")) {

            Constants.LOG.info("Hello to guiscalekey");
        }*/
    }

    public static void registerKeys(Consumer<class_304> consumer) {
        consumer.accept(Constants.DECREASE_SCALE_KEY);
        consumer.accept(Constants.INCREASE_SCALE_KEY);
    }

    public static void checkKeyPresses() {
        while (Constants.INCREASE_SCALE_KEY.method_1436()) {
            changeGuiScale(true);
        }
        while (Constants.DECREASE_SCALE_KEY.method_1436()) {
            changeGuiScale(false);
        }
    }

    public static void checkKeyPressesScreen(class_11908 keyEvent) {
        if (class_310.method_1551().field_1755 instanceof class_6599) return;
        if (Constants.INCREASE_SCALE_KEY.method_1417(keyEvent)) {
            changeGuiScale(true);
        }
        if (Constants.DECREASE_SCALE_KEY.method_1417(keyEvent)) {
            changeGuiScale(false);
        }
    }

    public static void checkMouseScreen(class_11909 button) {
        if (class_310.method_1551().field_1755 instanceof class_6599) return;
        if (Constants.INCREASE_SCALE_KEY.method_1433(button)) {
            changeGuiScale(true);
        }
        if (Constants.DECREASE_SCALE_KEY.method_1433(button)) {
            changeGuiScale(false);
        }
    }

    public static void changeGuiScale(boolean up) {
        class_310 mc = class_310.method_1551();
        class_7172<Integer> scale = mc.field_1690.method_42474();
        int i = scale.method_41753();
        i = i == 0 ? mc.method_22683().method_4476(0, mc.method_1573()) : i;
        scale.method_41748(Math.max(1, i + (up ? 1 : -1)));
        mc.field_1690.method_1640();
    }
}