/*
 * Decompiled with CFR 0.152.
 */
package io.github.viciscat.guiscalekey;

import io.github.viciscat.guiscalekey.Constants;
import io.github.viciscat.guiscalekey.platform.Services;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.screens.options.controls.KeyBindsScreen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;

public class CommonClass {
    public static void init() {
        Constants.LOG.info("Starting GuiScaleKeys mod on {}!", (Object)Services.PLATFORM.getPlatformName());
    }

    public static void registerKeys(Consumer<KeyMapping> consumer) {
        consumer.accept(Constants.DECREASE_SCALE_KEY);
        consumer.accept(Constants.INCREASE_SCALE_KEY);
    }

    public static void checkKeyPresses() {
        while (Constants.INCREASE_SCALE_KEY.consumeClick()) {
            CommonClass.changeGuiScale(true);
        }
        while (Constants.DECREASE_SCALE_KEY.consumeClick()) {
            CommonClass.changeGuiScale(false);
        }
    }

    public static void checkKeyPressesScreen(KeyEvent keyEvent) {
        if (Minecraft.getInstance().screen instanceof KeyBindsScreen) {
            return;
        }
        if (Constants.INCREASE_SCALE_KEY.matches(keyEvent)) {
            CommonClass.changeGuiScale(true);
        }
        if (Constants.DECREASE_SCALE_KEY.matches(keyEvent)) {
            CommonClass.changeGuiScale(false);
        }
    }

    public static void checkMouseScreen(MouseButtonEvent button) {
        if (Minecraft.getInstance().screen instanceof KeyBindsScreen) {
            return;
        }
        if (Constants.INCREASE_SCALE_KEY.matchesMouse(button)) {
            CommonClass.changeGuiScale(true);
        }
        if (Constants.DECREASE_SCALE_KEY.matchesMouse(button)) {
            CommonClass.changeGuiScale(false);
        }
    }

    public static void changeGuiScale(boolean up) {
        Minecraft mc = Minecraft.getInstance();
        OptionInstance scale = mc.options.guiScale();
        int i = (Integer)scale.get();
        i = i == 0 ? mc.getWindow().calculateScale(0, mc.isEnforceUnicode()) : i;
        scale.set((Object)Math.max(1, i + (up ? 1 : -1)));
        mc.options.save();
    }
}

