/*
 * Decompiled with CFR 0.152.
 */
package dev.omialien.revervoxmod;

import com.mojang.logging.LogUtils;
import dev.omialien.revervoxmod.config.RevervoxModServerConfigs;
import dev.omialien.revervoxmod.entity.custom.RevervoxFakeBatEntity;
import dev.omialien.revervoxmod.events.CommonEventBus;
import dev.omialien.revervoxmod.networking.RevervoxPacketHandler;
import dev.omialien.revervoxmod.registries.CreativeTabRegistry;
import dev.omialien.revervoxmod.registries.EntityRegistry;
import dev.omialien.revervoxmod.registries.ItemRegistry;
import dev.omialien.revervoxmod.registries.ParticleRegistry;
import dev.omialien.revervoxmod.registries.SoundRegistry;
import dev.omialien.revervoxmod.registries.TriggerRegistry;
import dev.omialien.revervoxmod.voicechat.AudioStorage;
import dev.omialien.voicechatrecording.api.VoiceChatRecordingApi;
import dev.omialien.voicechatrecording.taskscheduler.TaskScheduler;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="revervox_mod")
public class RevervoxMod {
    public static final String MOD_ID = "revervox_mod";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final LevelResource AUDIO_DIRECTORY = new LevelResource("player_audios");
    public static final TaskScheduler TASKS = new TaskScheduler();
    public static AudioStorage AUDIOS = new AudioStorage();
    public static VoiceChatRecordingApi RECORDING_API = null;

    public RevervoxMod() {
        LOGGER.warn("Old forge version!");
        this.commonSetup(FMLJavaModLoadingContext.get().getModEventBus());
        ModLoadingContext context = ModLoadingContext.get();
        context.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)RevervoxModServerConfigs.SPEC, "revervox-server.toml");
    }

    public RevervoxMod(FMLJavaModLoadingContext context) {
        this.commonSetup(context.getModEventBus());
        context.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)RevervoxModServerConfigs.SPEC, "revervox-server.toml");
    }

    private void commonSetup(IEventBus bus) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new CommonEventBus());
        EntityRegistry.register(bus);
        SoundRegistry.register(bus);
        ItemRegistry.register(bus);
        CreativeTabRegistry.register(bus);
        ParticleRegistry.register(bus);
        TriggerRegistry.init();
        RevervoxPacketHandler.registerPackets();
    }

    public static void summonBatWave(Player player) {
        if (!player.m_9236_().m_5776_()) {
            Vec3 playerPos = player.m_20318_(0.0f);
            for (int i = 0; i <= 2; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    RevervoxFakeBatEntity ent = new RevervoxFakeBatEntity((EntityType<? extends FlyingMob>)((EntityType)EntityRegistry.REVERVOX_FAKE_BAT.get()), player.m_9236_());
                    Vec3 batpos = RevervoxMod.applyLocalCoordinates(player.m_146908_(), playerPos, 10.0f, i, j);
                    float rotat = player.m_146908_() + 180.0f;
                    ent.m_5618_(rotat);
                    ent.m_5616_(rotat);
                    ent.m_7678_(batpos.f_82479_, batpos.f_82480_, batpos.f_82481_, rotat, 0.0f);
                    ent.setRotation(rotat);
                    ent.setTarget(player);
                    player.m_9236_().m_7967_((Entity)ent);
                    player.m_147207_(new MobEffectInstance(MobEffects.f_19610_, 27, 100, false, false), (Entity)player);
                }
            }
        }
    }

    public static Vec3 applyLocalCoordinates(float yRot, Vec3 vec3, float forwards, float up, float left) {
        Vec2 vec2 = new Vec2(0.0f, yRot);
        float f = Mth.m_14089_((float)((vec2.f_82471_ + 90.0f) * ((float)Math.PI / 180)));
        float f1 = Mth.m_14031_((float)((vec2.f_82471_ + 90.0f) * ((float)Math.PI / 180)));
        float f2 = Mth.m_14089_((float)(-vec2.f_82470_ * ((float)Math.PI / 180)));
        float f3 = Mth.m_14031_((float)(-vec2.f_82470_ * ((float)Math.PI / 180)));
        float f4 = Mth.m_14089_((float)((-vec2.f_82470_ + 90.0f) * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)((-vec2.f_82470_ + 90.0f) * ((float)Math.PI / 180)));
        Vec3 vec31 = new Vec3((double)(f * f2), (double)f3, (double)(f1 * f2));
        Vec3 vec32 = new Vec3((double)(f * f4), (double)f5, (double)(f1 * f4));
        Vec3 vec33 = vec31.m_82537_(vec32).m_82490_(-1.0);
        double d0 = vec31.f_82479_ * (double)forwards + vec32.f_82479_ * (double)up + vec33.f_82479_ * (double)left;
        double d1 = vec31.f_82480_ * (double)forwards + vec32.f_82480_ * (double)up + vec33.f_82480_ * (double)left;
        double d2 = vec31.f_82481_ * (double)forwards + vec32.f_82481_ * (double)up + vec33.f_82481_ * (double)left;
        return new Vec3(vec3.f_82479_ + d0, vec3.f_82480_ + d1, vec3.f_82481_ + d2);
    }
}

