/*
 * Decompiled with CFR 0.152.
 */
package dev.omialien.revervoxmod.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.omialien.revervoxmod.entity.animations.ModAnimationDefinitions;
import dev.omialien.revervoxmod.entity.custom.ThingyEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class ThingyModel<T extends Entity>
extends HierarchicalModel<T> {
    private final ModelPart thingy;
    private final ModelPart body;
    private final ModelPart r_arm;
    private final ModelPart l_arm;
    private final ModelPart r_leg;
    private final ModelPart l_leg;
    private final ModelPart head;
    private final ModelPart tail;

    public ThingyModel(ModelPart root) {
        this.thingy = root.m_171324_("thingy");
        this.body = this.thingy.m_171324_("body");
        this.r_arm = this.body.m_171324_("r_arm");
        this.l_arm = this.body.m_171324_("l_arm");
        this.r_leg = this.body.m_171324_("r_leg");
        this.l_leg = this.body.m_171324_("l_leg");
        this.head = this.body.m_171324_("head");
        this.tail = this.head.m_171324_("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition thingy = partdefinition.m_171599_("thingy", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = thingy.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition r_arm = body.m_171599_("r_arm", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)-11.0f, (float)0.0f));
        PartDefinition l_arm = body.m_171599_("l_arm", CubeListBuilder.m_171558_().m_171514_(8, 16).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)-11.0f, (float)0.0f));
        PartDefinition r_leg = body.m_171599_("r_leg", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)-6.0f, (float)0.0f));
        PartDefinition l_leg = body.m_171599_("l_leg", CubeListBuilder.m_171558_().m_171514_(24, 16).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)-6.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-11.0f, (float)0.0f));
        PartDefinition l_ear_r1 = head.m_171599_("l_ear_r1", CubeListBuilder.m_171558_().m_171514_(1, 1).m_171488_(-1.0f, -5.0f, 0.0f, 2.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4363f));
        PartDefinition r_ear_r1 = head.m_171599_("r_ear_r1", CubeListBuilder.m_171558_().m_171514_(1, 1).m_171480_().m_171488_(-1.0f, -5.0f, 0.0f, 2.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-3.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.4363f));
        PartDefinition tail = head.m_171599_("tail", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)4.0f));
        PartDefinition cube_r1 = tail.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(26, 29).m_171480_().m_171488_(1.25f, -1.3721f, -1.2205f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(16, 33).m_171488_(-1.0f, 0.8779f, -1.2205f, 2.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(23, 2).m_171488_(-1.0f, -1.6221f, -1.2205f, 2.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(10, 27).m_171488_(-1.25f, -1.3721f, -1.2205f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 27).m_171488_(-1.0f, -1.3721f, -1.2205f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.0f, (float)4.0f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = tail.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(13, 21).m_171480_().m_171488_(1.25f, -1.0f, -1.0f, 0.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(14, 25).m_171488_(-1.0f, 1.25f, -1.0f, 2.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(22, 25).m_171488_(-1.0f, -1.25f, -1.0f, 2.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(7, 23).m_171488_(-1.25f, -1.0f, -1.0f, 0.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(18, 25).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void m_6973_(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.applyHeadRotation(netHeadYaw, headPitch, ageInTicks);
        this.m_267799_(ModAnimationDefinitions.THINGY_WALK, limbSwing, limbSwingAmount, 2.0f, 2.5f);
        this.m_233385_(((ThingyEntity)((Object)entity)).idleAnimationState, ModAnimationDefinitions.THINGY_IDLE, ageInTicks, 1.0f);
    }

    private void applyHeadRotation(float pNetHeadYaw, float pHeadPitch, float pAgeInTicks) {
        pNetHeadYaw = Mth.m_14036_((float)pNetHeadYaw, (float)-30.0f, (float)30.0f);
        pHeadPitch = Mth.m_14036_((float)pHeadPitch, (float)-25.0f, (float)45.0f);
        this.head.f_104204_ = pNetHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = pHeadPitch * ((float)Math.PI / 180);
    }

    public void m_7695_(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.thingy.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @NotNull
    public ModelPart m_142109_() {
        return this.thingy;
    }
}

