/*
 * Decompiled with CFR 0.152.
 */
package dev.omialien.revervoxmod.entity.custom;

import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.audiochannel.AudioChannel;
import de.maxhenkel.voicechat.api.audiochannel.LocationalAudioChannel;
import dev.omialien.revervoxmod.RevervoxMod;
import dev.omialien.revervoxmod.config.RevervoxModServerConfigs;
import dev.omialien.revervoxmod.entity.custom.HearingEntity;
import dev.omialien.revervoxmod.entity.custom.SpeakingEntity;
import dev.omialien.revervoxmod.entity.goals.TargetSpokeGoal;
import dev.omialien.revervoxmod.particle.ParticleManager;
import dev.omialien.revervoxmod.registries.ItemRegistry;
import dev.omialien.revervoxmod.registries.ParticleRegistry;
import dev.omialien.revervoxmod.registries.SoundRegistry;
import dev.omialien.voicechatrecording.VoiceChatRecording;
import dev.omialien.voicechatrecording.api.AudioEffect;
import dev.omialien.voicechatrecording.api.IRecordedAudio;
import dev.omialien.voicechatrecording.api.IRecordedPlayer;
import dev.omialien.voicechatrecording.api.util.AudioPlayingUtil;
import dev.omialien.voicechatrecording.voicechat.audio.AudioPlayer;
import java.util.EnumSet;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RevervoxBatGeoEntity
extends FlyingMob
implements GeoEntity,
NeutralMob,
HearingEntity,
SpeakingEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    public static final int TICKS_PER_FLAP = Mth.m_14167_((float)2.4166098f);
    private static final EntityDataAccessor<Byte> DATA_ID_FLAGS = SynchedEntityData.m_135353_(RevervoxBatGeoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private int remainingPersistentAngerTime;
    private AudioPlayer currentAudioPlayer;
    @Nullable
    private UUID persistentAngerTarget;
    private long spawnTime;
    @Nullable
    private BlockPos targetPosition;
    final Random dropRng = new Random();

    public RevervoxBatGeoEntity(EntityType<? extends FlyingMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19804_.m_135372_(DATA_ID_FLAGS, (Object)0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new RVBatSweepAttackGoal());
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f));
        this.f_21346_.m_25352_(1, new TargetSpokeGoal<RevervoxBatGeoEntity>(this, arg_0 -> ((RevervoxBatGeoEntity)this).m_21674_(arg_0), (SoundEvent)SoundRegistry.REVERVOX_BAT_ALERT.get(), SoundEvents.f_11734_, 32));
        this.f_21346_.m_25352_(2, (Goal)new RVHurtByTargetGoal(this, Player.class));
        super.m_8099_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22280_, 3.5).m_22268_(Attributes.f_22283_, 1.8);
    }

    public int m_21304_() {
        int ANIMATION_TICKS = 13;
        int TRANSITION_TICKS = 5;
        int IDK_TICKS = 1;
        return ANIMATION_TICKS + TRANSITION_TICKS + IDK_TICKS;
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return pDistanceToClosestPlayer > 200.0;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_7870_(int pRemainingPersistentAngerTime) {
        this.remainingPersistentAngerTime = pRemainingPersistentAngerTime;
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID pPersistentAngerTarget) {
        this.persistentAngerTarget = pPersistentAngerTarget;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "Attack", 5, state -> {
            if (this.f_20911_) {
                return state.setAndContinue(DefaultAnimations.ATTACK_BITE);
            }
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        });
        controller.triggerableAnim("attack.bite", DefaultAnimations.ATTACK_BITE);
        controllers.add(new AnimationController[]{DefaultAnimations.genericFlyIdleController((GeoAnimatable)this).transitionLength(5), controller});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public void m_5993_(@NotNull Entity pKilled, int pScoreValue, @NotNull DamageSource pSource) {
        if (pKilled instanceof Player) {
            Player player = (Player)pKilled;
            this.playPlayerAudio(player, VoiceChatRecording.vcApi, () -> this.createLocationalAudioChannel(VoiceChatRecording.vcApi), new AudioEffect().changePitch(1.7f));
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        super.m_5993_(pKilled, pScoreValue, pSource);
    }

    private AudioChannel createLocationalAudioChannel(VoicechatServerApi api) {
        Vec3 loc = this.m_146892_();
        LocationalAudioChannel channel = api.createLocationalAudioChannel(UUID.randomUUID(), api.fromServerLevel((Object)this.m_9236_()), api.createPosition(loc.f_82479_, loc.f_82480_, loc.f_82481_));
        if (channel == null) {
            RevervoxMod.LOGGER.error("Couldn't create disappearing channel");
            return null;
        }
        channel.setCategory("revervox_mod");
        return channel;
    }

    public void m_142687_(@NotNull Entity.RemovalReason pReason) {
        IRecordedAudio audio;
        if (!this.m_9236_().m_5776_() && (audio = RevervoxMod.AUDIOS.getRandomAudio(false)) != null) {
            AudioPlayingUtil.playLocationalAudio((IRecordedAudio)audio, (Vec3)this.m_146892_(), (ServerLevel)((ServerLevel)this.m_9236_()), (AudioEffect)new AudioEffect().changePitch(1.3f).makeReverb(0.5f, 160, 1), (String)"revervox_mod", (float)32.0f);
        }
        super.m_142687_(pReason);
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        ParticleManager.addParticlesAroundSelf((ParticleOptions)ParticleRegistry.REVERVOX_PARTICLES.get(), 0.7, (Entity)this);
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor pLevel, @NotNull DifficultyInstance pDifficulty, @NotNull MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.spawnTime = System.currentTimeMillis();
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public long getSpawnTime() {
        return this.spawnTime;
    }

    public long getGracePeriodEnd() {
        long grace = (long)((Double)RevervoxModServerConfigs.REVERVOX_BAT_AFTER_SPAWN_GRACE_PERIOD.get() * 1000.0);
        return this.getSpawnTime() + grace;
    }

    public void m_6667_(@NotNull DamageSource damageSource) {
        super.m_6667_(damageSource);
        if (this.f_20890_) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    @Override
    public boolean isSpeakingAtMe(Player player) {
        long time = System.currentTimeMillis();
        if (time >= this.getGracePeriodEnd()) {
            IRecordedPlayer rec = RevervoxMod.RECORDING_API.getRecordedPlayer(player.m_20148_());
            if (rec != null) {
                return rec.isSpeaking() && rec.getLastSpoke() >= this.getGracePeriodEnd();
            }
            return false;
        }
        return false;
    }

    protected boolean m_142039_() {
        return this.f_19797_ % TICKS_PER_FLAP == 0;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        if (pDamageSource.m_276093_(DamageTypes.f_268671_)) {
            return null;
        }
        return (SoundEvent)SoundRegistry.REVERVOX_BAT_HURT.get();
    }

    @Nullable
    public SoundEvent m_7515_() {
        return this.f_19796_.m_188503_(4) != 0 ? null : (SoundEvent)SoundRegistry.REVERVOX_BAT_IDLE.get();
    }

    @Override
    public AudioPlayer getCurrentAudioPlayer() {
        return this.currentAudioPlayer;
    }

    @Override
    public void setCurrentAudioPlayer(AudioPlayer player) {
        this.currentAudioPlayer = player;
    }

    public boolean m_7327_(@NotNull Entity target) {
        int rand;
        boolean result = super.m_7327_(target);
        this.triggerAnim("Attack", "attack.bite");
        Level level = this.m_9236_();
        if (!level.m_5776_() && (rand = this.dropRng.nextInt((Integer)RevervoxModServerConfigs.REVERVOX_BAT_TOOTH_DROP_CHANCE.get())) == 0) {
            ItemEntity item = new ItemEntity(level, this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)ItemRegistry.REVERVOX_BAT_TOOTH.get()));
            level.m_7967_((Entity)item);
        }
        return result;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isResting()) {
            this.m_20256_(Vec3.f_82478_);
            this.m_20343_(this.m_20185_(), (double)Mth.m_14107_((double)this.m_20186_()) + 1.0 - (double)this.m_20206_(), this.m_20189_());
        } else {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
        }
    }

    public boolean isResting() {
        return ((Byte)this.f_19804_.m_135370_(DATA_ID_FLAGS) & 1) != 0;
    }

    public void setResting(boolean pIsResting) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_ID_FLAGS);
        if (pIsResting) {
            this.f_19804_.m_135381_(DATA_ID_FLAGS, (Object)((byte)(b0 | 1)));
        } else {
            this.f_19804_.m_135381_(DATA_ID_FLAGS, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.f_19804_.m_135381_(DATA_ID_FLAGS, (Object)pCompound.m_128445_("BatFlags"));
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128344_("BatFlags", ((Byte)this.f_19804_.m_135370_(DATA_ID_FLAGS)).byteValue());
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.m_5448_() == null) {
            if (!(this.targetPosition == null || this.m_9236_().m_46859_(this.targetPosition) && this.targetPosition.m_123342_() > this.m_9236_().m_141937_())) {
                this.targetPosition = null;
            }
            if (this.targetPosition == null || this.f_19796_.m_188503_(30) == 0 || this.targetPosition.m_203195_((Position)this.m_20182_(), 2.0)) {
                this.targetPosition = BlockPos.m_274561_((double)(this.m_20185_() + (double)this.f_19796_.m_188503_(7) - (double)this.f_19796_.m_188503_(7)), (double)(this.m_20186_() + (double)this.f_19796_.m_188503_(6) - 2.0), (double)(this.m_20189_() + (double)this.f_19796_.m_188503_(7) - (double)this.f_19796_.m_188503_(7)));
            }
            this.moveToTarget();
        }
    }

    public void moveToTarget() {
        BlockPos blockpos = this.targetPosition;
        if (blockpos != null) {
            double d2 = (double)blockpos.m_123341_() + 0.5 - this.m_20185_();
            double d0 = (double)blockpos.m_123342_() + 0.1 - this.m_20186_();
            double d1 = (double)blockpos.m_123343_() + 0.5 - this.m_20189_();
            Vec3 vec3 = this.m_20184_();
            double xzSpeed = 0.5;
            double ySpeed = 0.7;
            float accel = 0.1f;
            if (this.m_5448_() != null) {
                xzSpeed = 0.75;
                ySpeed = 1.05;
                accel = 0.15f;
            }
            Vec3 vec31 = vec3.m_82520_((Math.signum(d2) * xzSpeed - vec3.f_82479_) * (double)accel, (Math.signum(d0) * ySpeed - vec3.f_82480_) * (double)accel, (Math.signum(d1) * xzSpeed - vec3.f_82481_) * (double)accel);
            this.m_20256_(vec31);
            float f = (float)(Mth.m_14136_((double)vec31.f_82481_, (double)vec31.f_82479_) * 57.29577951308232) - 90.0f;
            float f1 = Mth.m_14177_((float)(f - this.m_146908_()));
            this.f_20902_ = 0.5f;
            this.m_146922_(this.m_146908_() + f1);
        }
    }

    @Override
    public void onSpeak(long audioDuration) {
    }

    class RVBatSweepAttackGoal
    extends Goal {
        private int attackCooldown = 0;

        public RVBatSweepAttackGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return RevervoxBatGeoEntity.this.m_5448_() != null;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = RevervoxBatGeoEntity.this.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (livingentity instanceof Player) {
                Player player = (Player)livingentity;
                if (livingentity.m_5833_() || player.m_7500_()) {
                    return false;
                }
            }
            return this.m_8036_();
        }

        public void m_8056_() {
        }

        public void m_8041_() {
            RevervoxBatGeoEntity.this.m_6710_(null);
        }

        public void m_8037_() {
            LivingEntity livingentity = RevervoxBatGeoEntity.this.m_5448_();
            if (livingentity != null) {
                Vec3i moveTargetPoint = new Vec3i((int)Math.round(livingentity.m_20185_()), (int)Math.round(livingentity.m_20227_(0.5)), (int)Math.round(livingentity.m_20189_()));
                RevervoxBatGeoEntity.this.targetPosition = new BlockPos(moveTargetPoint);
                RevervoxBatGeoEntity.this.moveToTarget();
                if (this.attackCooldown <= 0 && RevervoxBatGeoEntity.this.m_20191_().m_82377_(0.5, 0.0, 0.5).m_82381_(livingentity.m_20191_())) {
                    RevervoxBatGeoEntity.this.m_7327_((Entity)livingentity);
                    double attackSpeed = RevervoxBatGeoEntity.this.m_21133_(Attributes.f_22283_);
                    this.attackCooldown = (int)((double)RevervoxBatGeoEntity.this.m_21304_() / attackSpeed);
                    if (!RevervoxBatGeoEntity.this.m_20067_()) {
                        RevervoxBatGeoEntity.this.m_9236_().m_46796_(1039, RevervoxBatGeoEntity.this.m_20183_(), 0);
                    }
                }
                if (this.attackCooldown > 0) {
                    --this.attackCooldown;
                }
            }
        }
    }

    static class RVHurtByTargetGoal
    extends TargetGoal {
        private static final TargetingConditions HURT_BY_TARGETING = TargetingConditions.m_148352_().m_148355_().m_26893_();
        private int timestamp;
        private final Class<?>[] toTarget;

        public RVHurtByTargetGoal(RevervoxBatGeoEntity pMob, Class<?> ... target) {
            super((Mob)pMob, true);
            this.toTarget = target;
        }

        public boolean m_8036_() {
            int i = this.f_26135_.m_21213_();
            LivingEntity livingentity = this.f_26135_.m_21188_();
            if (i != this.timestamp && livingentity != null) {
                if (livingentity.m_6095_() == EntityType.f_20532_ && this.f_26135_.m_9236_().m_46469_().m_46207_(GameRules.f_46127_)) {
                    return false;
                }
                for (Class<?> oclass : this.toTarget) {
                    if (!oclass.isAssignableFrom(livingentity.getClass())) continue;
                    return this.m_26150_(livingentity, HURT_BY_TARGETING);
                }
                return false;
            }
            return false;
        }

        public void m_8056_() {
            this.f_26135_.m_6710_(this.f_26135_.m_21188_());
            this.f_26137_ = this.f_26135_.m_5448_();
            this.timestamp = this.f_26135_.m_21213_();
            this.f_26138_ = 300;
            super.m_8056_();
        }
    }
}

