/*
 * Decompiled with CFR 0.152.
 */
package dev.omialien.revervoxmod.entity.custom;

import de.maxhenkel.voicechat.api.audiochannel.AudioChannel;
import de.maxhenkel.voicechat.api.audiochannel.LocationalAudioChannel;
import dev.omialien.revervoxmod.RevervoxMod;
import dev.omialien.revervoxmod.entity.custom.SpeakingEntity;
import dev.omialien.revervoxmod.networking.RevervoxPacketHandler;
import dev.omialien.revervoxmod.networking.packets.AddSoundInstancePacket;
import dev.omialien.revervoxmod.particle.ParticleManager;
import dev.omialien.revervoxmod.registries.ParticleRegistry;
import dev.omialien.revervoxmod.registries.SoundRegistry;
import dev.omialien.voicechatrecording.VoiceChatRecording;
import dev.omialien.voicechatrecording.api.AudioEffect;
import dev.omialien.voicechatrecording.api.IRecordedAudio;
import dev.omialien.voicechatrecording.voicechat.audio.AudioPlayer;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RevervoxFakeBatEntity
extends FlyingMob
implements GeoEntity,
SpeakingEntity {
    private final AnimatableInstanceCache geoCache;
    private final int TICKS_TO_UPDATE_ROTATION = 200;
    private int ticksLeft = 3;
    private final float MOVE_SPEED = 0.6f;
    private Vec3 movement = new Vec3(0.0, 0.0, (double)0.6f);
    private int ticksToDie = 20;
    private boolean hasPlayedSpawnSound = false;
    public static final EntityDataAccessor<Optional<UUID>> TARGET_ACCESSOR = SynchedEntityData.m_135353_(RevervoxFakeBatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private Player targetCache;
    private AudioPlayer currentAudioPlayer;

    public RevervoxFakeBatEntity(EntityType<? extends FlyingMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
        this.f_19794_ = true;
    }

    @Nullable
    public LivingEntity m_5448_() {
        UUID tgt = ((Optional)this.f_19804_.m_135370_(TARGET_ACCESSOR)).orElse(null);
        if (this.targetCache != null && tgt != null && this.targetCache.m_20148_().equals(tgt)) {
            return this.targetCache;
        }
        if (tgt == null) {
            return null;
        }
        this.targetCache = this.m_9236_().m_46003_(tgt);
        return this.targetCache;
    }

    private Player getPlayerTarget() {
        Player ta;
        LivingEntity t = this.m_5448_();
        return t instanceof Player ? (ta = (Player)t) : null;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TARGET_ACCESSOR, Optional.empty());
    }

    public void setTarget(Player player) {
        RevervoxMod.LOGGER.debug("setting target! {}", (Object)player.m_7755_());
        this.f_19804_.m_135381_(TARGET_ACCESSOR, Optional.of(player.m_20148_()));
    }

    public void m_7334_(@NotNull Entity pEntity) {
    }

    protected void m_6138_() {
    }

    protected void m_7324_(@NotNull Entity p_20971_) {
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_5997_(double pX, double pY, double pZ) {
    }

    public void m_8119_() {
        Player target = this.getPlayerTarget();
        if (target != null && target.m_6084_() && !this.m_9236_().m_5776_() && !this.hasPlayedSpawnSound) {
            RevervoxPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)target), (Object)new AddSoundInstancePacket(this.m_19879_(), (SoundEvent)SoundRegistry.REVERVOX_BAT_ALERT.get(), SoundSource.HOSTILE, false));
            this.hasPlayedSpawnSound = true;
        }
        super.m_8119_();
    }

    protected void m_8024_() {
        --this.ticksLeft;
        if (this.ticksLeft <= 0) {
            this.ticksLeft = 200;
            this.setRotation(this.m_146908_());
        }
        this.m_20256_(this.movement);
        --this.ticksToDie;
        if (this.ticksToDie <= 0) {
            Player target = this.getPlayerTarget();
            if (target != null && target.m_6084_()) {
                target.m_6469_(this.m_9236_().m_269111_().m_269333_((LivingEntity)this), 1.0f);
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        super.m_8024_();
    }

    public void onRemovedFromWorld() {
        if (!this.m_20145_()) {
            ParticleManager.addParticlesAroundSelf((ParticleOptions)ParticleRegistry.REVERVOX_PARTICLES.get(), (Entity)this);
        }
        super.onRemovedFromWorld();
    }

    public void m_142687_(@NotNull Entity.RemovalReason pReason) {
        LocationalAudioChannel channel;
        IRecordedAudio audio;
        Player target;
        if (!this.m_9236_().m_5776_() && pReason == Entity.RemovalReason.KILLED && (target = this.getPlayerTarget()) != null && (audio = RevervoxMod.AUDIOS.getRandomAudio(false)) != null && (channel = VoiceChatRecording.vcApi.createLocationalAudioChannel(UUID.randomUUID(), VoiceChatRecording.vcApi.fromServerLevel((Object)this.m_9236_()), VoiceChatRecording.vcApi.createPosition(this.m_20185_(), this.m_20186_(), this.m_20189_()))) != null) {
            channel.setFilter(plr -> ((ServerPlayer)plr.getPlayer()).m_7306_((Entity)target));
            channel.setCategory("revervox_mod");
            this.playAudio(audio.getAudio(), VoiceChatRecording.vcApi, (AudioChannel)channel, new AudioEffect().changePitch(1.5f).makeReverb(0.5f, 160, 2));
        }
        super.m_142687_(pReason);
    }

    public void setRotation(float degrees) {
        this.m_146922_(degrees);
        float yaw = (float)((double)degrees * (Math.PI / 180));
        float sz = Mth.m_14089_((float)yaw) * 0.6f;
        float sx = Mth.m_14031_((float)yaw) * 0.6f;
        this.movement = new Vec3((double)(-sx), 0.0, (double)sz);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "Attack", 5, state -> {
            if (this.f_20911_) {
                return state.setAndContinue(DefaultAnimations.ATTACK_BITE);
            }
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        });
        controller.triggerableAnim("attack.bite", DefaultAnimations.ATTACK_BITE);
        controllers.add(new AnimationController[]{DefaultAnimations.genericFlyIdleController((GeoAnimatable)this).transitionLength(5), controller});
    }

    public boolean m_7327_(@NotNull Entity target) {
        boolean result = super.m_7327_(target);
        this.triggerAnim("Attack", "attack.bite");
        this.m_142687_(Entity.RemovalReason.DISCARDED);
        return result;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public boolean m_20145_() {
        if (this.m_9236_().f_46443_ && Minecraft.m_91087_().f_91074_ != null) {
            Player target = this.getPlayerTarget();
            if (target == null) {
                return false;
            }
            return !Minecraft.m_91087_().f_91074_.m_20148_().equals(target.m_20148_());
        }
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 5.0).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22280_, 3.5).m_22268_(Attributes.f_22283_, 1.8);
    }

    @Override
    public AudioPlayer getCurrentAudioPlayer() {
        return this.currentAudioPlayer;
    }

    @Override
    public void setCurrentAudioPlayer(AudioPlayer player) {
        this.currentAudioPlayer = player;
    }

    @Override
    public void onSpeak(long audioDuration) {
    }
}

