/*
 * Decompiled with CFR 0.152.
 */
package dev.omialien.revervoxmod.entity.custom;

import de.maxhenkel.voicechat.api.audiochannel.LocationalAudioChannel;
import dev.omialien.revervoxmod.RevervoxMod;
import dev.omialien.revervoxmod.config.RevervoxModServerConfigs;
import dev.omialien.revervoxmod.entity.ai.MMEntityMoveHelper;
import dev.omialien.revervoxmod.entity.ai.RVClimbNavigation;
import dev.omialien.revervoxmod.entity.custom.HearingEntity;
import dev.omialien.revervoxmod.entity.custom.SpeakingEntity;
import dev.omialien.revervoxmod.entity.goals.EatFoodGoal;
import dev.omialien.revervoxmod.entity.goals.RandomRepeatGoal;
import dev.omialien.revervoxmod.entity.goals.RevervoxHurtByTargetGoal;
import dev.omialien.revervoxmod.entity.goals.RevervoxSonicBoomGoal;
import dev.omialien.revervoxmod.entity.goals.RevervoxStunGoal;
import dev.omialien.revervoxmod.entity.goals.TargetSpokeGoal;
import dev.omialien.revervoxmod.particle.ParticleManager;
import dev.omialien.revervoxmod.registries.DamageTypeRegistry;
import dev.omialien.revervoxmod.registries.ParticleRegistry;
import dev.omialien.revervoxmod.registries.RevervoxTags;
import dev.omialien.revervoxmod.registries.SoundRegistry;
import dev.omialien.voicechatrecording.VoiceChatRecording;
import dev.omialien.voicechatrecording.api.AudioEffect;
import dev.omialien.voicechatrecording.api.IRecordedPlayer;
import dev.omialien.voicechatrecording.voicechat.audio.AudioPlayer;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.fluids.IFluidBlock;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RevervoxGeoEntity
extends Monster
implements GeoEntity,
NeutralMob,
HearingEntity,
SpeakingEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final EntityDataAccessor<Boolean> CLIMBING_ACCESSOR = SynchedEntityData.m_135353_(RevervoxGeoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)50, (int)60);
    private final RawAnimation REVERVO_CLIMB = RawAnimation.begin().thenLoop("move.climb");
    private int remainingPersistentAngerTime;
    private long firstSpeak;
    private boolean shouldDisappear;
    private static final long NOT_SPOKEN_YET = -1L;
    private AudioPlayer currentAudioPlayer;
    private long noLineOfSightTicks;
    private boolean stunned;
    @Nullable
    private UUID persistentAngerTarget;
    private int breakCooldown;

    public RevervoxGeoEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21342_ = new MMEntityMoveHelper((Mob)this, 90.0f);
        this.firstSpeak = -1L;
        this.breakCooldown = 0;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CLIMBING_ACCESSOR, (Object)false);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericWalkRunIdleController((Entity)this).transitionLength(5).triggerableAnim("Stun", RawAnimation.begin().then("misc.stun", Animation.LoopType.PLAY_ONCE)).triggerableAnim("SonicBoom", DefaultAnimations.ATTACK_CAST), DefaultAnimations.genericAttackAnimation((LivingEntity)this, (RawAnimation)DefaultAnimations.ATTACK_SWING).transitionLength(5), new AnimationController((GeoAnimatable)this, "Climb", 5, state -> {
            if (this.isClimbing()) {
                return state.setAndContinue(this.REVERVO_CLIMB);
            }
            state.resetCurrentAnimation();
            return PlayState.STOP;
        })});
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        ParticleManager.addParticlesAroundSelf((ParticleOptions)ParticleRegistry.REVERVOX_PARTICLES.get(), 2.0, (Entity)this);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    protected void m_8099_() {
        RevervoxMod.LOGGER.debug("Revervox Spawned");
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new RandomRepeatGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new TemptGoal((PathfinderMob)this, 0.4, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42591_}), false));
        this.f_21345_.m_25352_(6, (Goal)new TemptGoal((PathfinderMob)this, 0.4, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42592_}), false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.addBehaviourGoals();
    }

    protected void addBehaviourGoals() {
        this.f_21345_.m_25352_(0, (Goal)new RevervoxStunGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new RevervoxSonicBoomGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new EatFoodGoal((Mob)this, RevervoxTags.Items.ATTRACTS_REVERVOX));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.7, false));
        this.f_21346_.m_25352_(1, new TargetSpokeGoal<RevervoxGeoEntity>(this, arg_0 -> ((RevervoxGeoEntity)this).m_21674_(arg_0), (SoundEvent)SoundRegistry.REVERVOX_ALERT.get(), (SoundEvent)SoundRegistry.REVERVOX_LOOP.get(), 50));
        this.f_21346_.m_25352_(2, (Goal)new RevervoxHurtByTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, true, entity -> entity.m_6095_().m_204039_(RevervoxTags.Entities.INSECTS)));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21183_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22285_, 1.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22281_, 14.0).m_22268_(Attributes.f_22283_, 0.3).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22278_, 1.0);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        RVClimbNavigation navigation = new RVClimbNavigation(this, pLevel);
        navigation.m_26529_(4.0f);
        return navigation;
    }

    public int m_21304_() {
        int ANIMATION_TICKS = 5;
        int TRANSITION_TICKS = 5;
        int IDK_TICKS = 1;
        return ANIMATION_TICKS + TRANSITION_TICKS + IDK_TICKS;
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return pDistanceToClosestPlayer > 200.0;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_7870_(int pTime) {
        this.remainingPersistentAngerTime = pTime;
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID pTarget) {
        this.persistentAngerTarget = pTarget;
    }

    public void m_6825_() {
        RevervoxMod.LOGGER.debug("Starting persistent anger timer!");
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.REVERVOX_DEATH.get();
    }

    protected SoundEvent m_7975_(@NotNull DamageSource dmgSrc) {
        return (SoundEvent)SoundRegistry.REVERVOX_HURT.get();
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        float amount = pAmount;
        if (pSource.m_269415_() != this.m_269291_().m_269079_(DamageTypeRegistry.REVERVOX_BONUS).m_269415_()) {
            amount /= 2.0f;
        }
        return super.m_6469_(pSource, amount);
    }

    @NotNull
    public ItemStack m_5584_(Level pLevel, @NotNull ItemStack pFood) {
        pLevel.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_7866_(pFood), SoundSource.NEUTRAL, 1.0f, 1.0f + (pLevel.f_46441_.m_188501_() - pLevel.f_46441_.m_188501_()) * 0.4f);
        this.m_146850_(GameEvent.f_157806_);
        return pFood;
    }

    public void m_5993_(@NotNull Entity pEntity, int pScoreValue, @NotNull DamageSource pSource) {
        if (pEntity instanceof Player) {
            Player player = (Player)pEntity;
            Vec3 loc = this.m_146892_();
            this.playPlayerAudio(player, VoiceChatRecording.vcApi, () -> {
                LocationalAudioChannel channel = VoiceChatRecording.vcApi.createLocationalAudioChannel(UUID.randomUUID(), VoiceChatRecording.vcApi.fromServerLevel((Object)this.m_9236_()), VoiceChatRecording.vcApi.createPosition(loc.f_82479_, loc.f_82480_, loc.f_82481_));
                if (channel == null) {
                    RevervoxMod.LOGGER.error("Couldn't create disappearing channel");
                    return null;
                }
                channel.setCategory("revervox_mod");
                return channel;
            }, new AudioEffect().addRandomEffects());
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        super.m_5993_(pEntity, pScoreValue, pSource);
    }

    @Override
    public boolean hasSpoken() {
        return this.firstSpeak != -1L;
    }

    @Override
    public long getFirstSpoken() {
        return this.firstSpeak;
    }

    @Override
    public void onSpeak(long audioDuration) {
        if (!this.hasSpoken() && !this.m_9236_().m_5776_()) {
            this.firstSpeak = System.currentTimeMillis() + audioDuration;
        }
    }

    @Override
    public AudioPlayer getCurrentAudioPlayer() {
        return this.currentAudioPlayer;
    }

    @Override
    public void setCurrentAudioPlayer(AudioPlayer player) {
        this.currentAudioPlayer = player;
    }

    @Override
    public boolean isSpeakingAtMe(Player player) {
        long time = System.currentTimeMillis();
        if (this.hasSpoken() && time >= this.getGracePeriodEnd()) {
            IRecordedPlayer rec = RevervoxMod.RECORDING_API.getRecordedPlayer(player.m_20148_());
            if (rec != null) {
                return rec.isSpeaking() && rec.getLastSpoke() >= this.getGracePeriodEnd();
            }
            return false;
        }
        return false;
    }

    public void m_6710_(@org.jetbrains.annotations.Nullable LivingEntity target) {
        if (target instanceof Player) {
            this.setShouldDisappear(true);
        }
        super.m_6710_(target);
    }

    public boolean teleportTowards(Entity pTarget) {
        Vec3 vec3 = new Vec3(this.m_20185_() - pTarget.m_20185_(), this.m_20227_(0.5) - pTarget.m_20188_(), this.m_20189_() - pTarget.m_20189_());
        vec3 = vec3.m_82541_();
        double d1 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vec3.f_82479_ * 16.0;
        double d2 = this.m_20186_() + (double)(this.f_19796_.m_188503_(16) - 8) - vec3.f_82480_ * 16.0;
        double d3 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vec3.f_82481_ * 16.0;
        return this.teleport(d1, d2, d3);
    }

    private boolean teleport(double pX, double pY, double pZ) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(pX, pY, pZ);
        while (blockpos$mutableblockpos.m_123342_() > this.m_9236_().m_141937_() && !this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos).m_60804_((BlockGetter)this.m_9236_(), (BlockPos)blockpos$mutableblockpos)) {
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos);
        boolean flag = blockstate.m_60804_((BlockGetter)this.m_9236_(), (BlockPos)blockpos$mutableblockpos);
        boolean flag1 = blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)pX, (double)pY, (double)pZ);
            if (event.isCanceled()) {
                return false;
            }
            Vec3 vec3 = this.m_20182_();
            boolean flag2 = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), false);
            if (flag2) {
                this.m_9236_().m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)this));
            }
            return flag2;
        }
        return false;
    }

    public float getStepHeight() {
        return 1.0f;
    }

    private boolean isFluid(Block block) {
        return block instanceof LiquidBlock || block instanceof IFluidBlock;
    }

    protected boolean m_6129_() {
        return this.isFluid(this.m_9236_().m_8055_(this.m_20183_().m_7494_()).m_60734_()) || this.isFluid(this.m_9236_().m_8055_(this.m_20183_().m_7494_().m_7494_()).m_60734_());
    }

    public boolean m_6063_() {
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            boolean isOffsetFacingTwoAboveSolid;
            boolean isFacingSolid;
            Vec3i offset = this.m_6350_().m_122436_();
            boolean bl = isFacingSolid = !this.m_9236_().m_8055_(this.m_20183_().m_121945_(this.m_6350_())).m_60795_();
            if (isFacingSolid) {
                offset = offset.m_7918_(0, 1, 0);
            }
            if (this.m_5448_() != null) {
                if (!this.m_142582_((Entity)this.m_5448_())) {
                    ++this.noLineOfSightTicks;
                } else {
                    this.resetLineOfSight();
                }
            }
            boolean isFacingBelowSolid = !this.m_9236_().m_8055_(this.m_20183_().m_121945_(this.m_6350_()).m_7495_()).m_60795_();
            boolean bl2 = isOffsetFacingTwoAboveSolid = !this.m_9236_().m_8055_(this.m_20183_().m_121955_(offset).m_6630_(2)).m_60795_();
            if (this.isInFluidType()) {
                this.m_20256_(this.m_20184_().m_82490_(1.0));
            }
            this.setClimbing(this.f_19862_ && this.m_5448_() != null && (isOffsetFacingTwoAboveSolid || !isFacingBelowSolid) && this.breakCooldown <= 0 && this.m_5448_().m_20186_() > this.m_20186_());
            this.m_6858_(this.m_5448_() != null);
        }
    }

    public boolean lostLineOfSightFor(long pTicks) {
        return this.noLineOfSightTicks >= pTicks;
    }

    public void resetLineOfSight() {
        this.noLineOfSightTicks = 0L;
    }

    public void resetNavigation() {
        if (this.m_5448_() == null) {
            return;
        }
        this.m_21573_().m_5624_((Entity)this.m_5448_(), this.m_21133_(Attributes.f_22279_));
    }

    public void m_21666_(@NotNull ServerLevel pServerLevel, boolean pUpdateAnger) {
        if (this.m_5448_() == null || !this.m_142582_((Entity)this.m_5448_())) {
            super.m_21666_(pServerLevel, pUpdateAnger);
        }
    }

    protected void m_8024_() {
        boolean targetDirectlyAboveThreeBlocks;
        boolean bl = targetDirectlyAboveThreeBlocks = this.m_5448_() != null && this.m_5448_().m_20186_() - this.m_20186_() >= 3.0;
        if (this.m_5448_() != null) {
            double playerDirectionOffset = this.m_5448_().m_20186_() - this.m_20186_();
            double offset = Double.compare(playerDirectionOffset, 0.0);
            double d = offset < 0.0 ? -1.0 : (offset = offset == 0.0 ? 0.0 : 1.0);
            if (((Boolean)RevervoxModServerConfigs.REVERVOX_BREAKS_BLOCKS.get()).booleanValue() || ((Boolean)RevervoxModServerConfigs.REVERVOX_BREAKS_NONSOLID.get()).booleanValue()) {
                if (this.breakCooldown > 0) {
                    --this.breakCooldown;
                }
                this.checkWalls(this.m_20191_().m_82377_(0.4, 0.0, 0.2).m_82386_(0.0, offset, 0.0), (Boolean)RevervoxModServerConfigs.REVERVOX_BREAKS_BLOCKS.get() != false && this.breakCooldown <= 0 && !this.m_142582_((Entity)this.m_5448_()) && !targetDirectlyAboveThreeBlocks);
            }
        } else if (this.shouldDisappear()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        super.m_8024_();
    }

    private void checkWalls(AABB pArea, boolean breakSolid) {
        int i = Mth.m_14107_((double)pArea.f_82288_);
        int j = Mth.m_14107_((double)pArea.f_82289_);
        int k = Mth.m_14107_((double)pArea.f_82290_);
        int l = Mth.m_14107_((double)pArea.f_82291_);
        int i1 = Mth.m_14107_((double)pArea.f_82292_);
        int j1 = Mth.m_14107_((double)pArea.f_82293_);
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                if (this.m_5448_() != null && (double)l1 < this.m_5448_().m_20186_() && (double)l1 <= this.m_20186_()) continue;
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockpos = new BlockPos(k1, l1, i2);
                    BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                    if (blockstate.m_60795_() || blockstate.m_204336_(BlockTags.f_215822_) || blockstate.m_204336_(BlockTags.f_13069_) && !blockstate.m_60713_(Blocks.f_50183_) || !ForgeHooks.canEntityDestroy((Level)this.m_9236_(), (BlockPos)blockpos, (LivingEntity)this)) continue;
                    if (breakSolid && this.m_20186_() <= (double)this.m_9236_().m_5736_()) {
                        if (this.m_20186_() < 0.0 || blockstate.m_204336_(BlockTags.f_215825_)) {
                            this.m_9236_().m_46953_(blockpos, true, (Entity)this);
                            continue;
                        }
                        RevervoxMod.TASKS.schedule(() -> {
                            if (this.m_6084_() && !this.m_213877_()) {
                                this.m_9236_().m_46953_(blockpos, true, (Entity)this);
                            }
                        }, 5L);
                        this.breakCooldown = 6;
                        continue;
                    }
                    if (!((Boolean)RevervoxModServerConfigs.REVERVOX_BREAKS_NONSOLID.get()).booleanValue() || blockstate.m_280296_() && !blockstate.m_204336_(BlockTags.f_13035_)) continue;
                    this.m_9236_().m_46953_(blockpos, true, (Entity)this);
                }
            }
        }
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    public boolean isClimbing() {
        return (Boolean)this.f_19804_.m_135370_(CLIMBING_ACCESSOR);
    }

    public void setClimbing(boolean pClimbing) {
        this.f_19804_.m_135381_(CLIMBING_ACCESSOR, (Object)pClimbing);
    }

    public boolean isStunned() {
        return this.stunned;
    }

    public void setStunned(boolean pStunned) {
        this.stunned = pStunned;
    }

    public long getGracePeriodEnd() {
        long grace = (long)((Double)RevervoxModServerConfigs.REVERVOX_AFTER_SPEAK_GRACE_PERIOD.get() * 1000.0);
        return this.getFirstSpoken() + grace;
    }

    public static boolean checkRevervoxSpawnRules(EntityType<RevervoxGeoEntity> pRevervox, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        boolean flag1;
        Player player;
        if (pLevel.m_45963_(RevervoxGeoEntity.class, TargetingConditions.f_26872_, null, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), new AABB(pPos).m_82400_((double)((Integer)RevervoxModServerConfigs.REVERVOX_SPAWN_CHANCE.get()).intValue())) != null) {
            return false;
        }
        if (pLevel.m_46803_(pPos) < 4 && (player = pLevel.m_45941_(TargetingConditions.f_26872_, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_())) != null && !((Boolean)RevervoxModServerConfigs.REVERVOX_ABOVE_GROUND.get()).booleanValue() && player.m_20182_().f_82480_ <= (double)(pLevel.m_5736_() - 10) && player.m_9236_().m_45955_(TargetingConditions.f_26872_, (LivingEntity)player, player.m_20191_().m_82377_(100.0, 50.0, 100.0)).isEmpty()) {
            boolean flag = RevervoxGeoEntity.m_217057_(pRevervox, (LevelAccessor)pLevel, (MobSpawnType)pSpawnType, (BlockPos)pPos, (RandomSource)pRandom);
            if (flag) {
                RevervoxMod.LOGGER.debug("Trying to Spawn Revervox on alone player: " + player.m_7755_() + " at " + pPos);
            }
            return flag;
        }
        if (!((Boolean)RevervoxModServerConfigs.REVERVOX_ABOVE_GROUND.get()).booleanValue() && pPos.m_123342_() >= pLevel.m_5736_() - 10) {
            return false;
        }
        int i = pLevel.m_46803_(pPos);
        int j = 4;
        if (pRandom.m_188499_()) {
            return false;
        }
        boolean bl = flag1 = i <= pRandom.m_188503_(j) && RevervoxGeoEntity.m_217057_(pRevervox, (LevelAccessor)pLevel, (MobSpawnType)pSpawnType, (BlockPos)pPos, (RandomSource)pRandom);
        if (flag1) {
            RevervoxMod.LOGGER.debug("Trying to Spawn Revervox at " + pPos);
        }
        return flag1;
    }

    public boolean shouldDisappear() {
        return this.shouldDisappear;
    }

    private void setShouldDisappear(boolean shouldDisappear) {
        this.shouldDisappear = shouldDisappear;
    }
}

