/*
 * Decompiled with CFR 0.152.
 */
package dev.omialien.revervoxmod.entity.custom;

import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.audiochannel.AudioChannel;
import dev.omialien.revervoxmod.RevervoxMod;
import dev.omialien.voicechatrecording.api.AudioEffect;
import dev.omialien.voicechatrecording.api.IRecordedAudio;
import dev.omialien.voicechatrecording.voicechat.audio.AudioPlayer;
import java.util.function.Supplier;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.NotNull;

public interface SpeakingEntity {
    public AudioPlayer getCurrentAudioPlayer();

    public void setCurrentAudioPlayer(AudioPlayer var1);

    default public boolean hasSpoken() {
        throw new NotImplementedException("hasSpoken");
    }

    default public long getFirstSpoken() {
        throw new NotImplementedException("getFirstSpoken");
    }

    public void onSpeak(long var1);

    default public void playAudio(short @NotNull [] audio, VoicechatServerApi api, AudioChannel channel, AudioEffect effect) {
        int SAMPLE_RATE = 48000;
        short[] audioWithAppliedEffects = effect.applyEffects(audio);
        RevervoxMod.LOGGER.debug("Playing audio with {}s", (Object)(audio.length / 48000));
        this.setCurrentAudioPlayer(new AudioPlayer(audioWithAppliedEffects, api, channel));
        this.getCurrentAudioPlayer().start();
        this.onSpeak(audio.length / 48000 * 1000);
    }

    default public void playPlayerAudio(Player player, VoicechatServerApi api, Supplier<AudioChannel> channelSupp) {
        this.playPlayerAudio(player, api, channelSupp, new AudioEffect());
    }

    default public void playPlayerAudio(Player player, VoicechatServerApi api, Supplier<AudioChannel> channelSupp, AudioEffect effect) {
        AudioChannel channel;
        IRecordedAudio audio = RevervoxMod.AUDIOS.getRandomAudio(player.m_20148_(), true);
        if (audio == null) {
            RevervoxMod.LOGGER.error("No audio found for {}, choosing random player", (Object)player.m_7755_());
            audio = RevervoxMod.AUDIOS.getRandomAudio(true);
            if (audio == null) {
                return;
            }
        }
        if ((channel = channelSupp.get()) == null) {
            return;
        }
        RevervoxMod.LOGGER.debug("Playing audio from player: " + player.m_7755_());
        this.playAudio(audio.getAudio(), api, channel, effect);
    }
}

