/*
 * Decompiled with CFR 0.152.
 */
package dev.omialien.revervoxmod.entity.goals;

import dev.omialien.revervoxmod.RevervoxMod;
import dev.omialien.revervoxmod.registries.TriggerRegistry;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.AABB;

public class EatFoodGoal
extends Goal {
    private final Mob entity;
    private final TagKey<Item> itemTypesToFollow;
    private List<? extends ItemEntity> nearbyItems;
    private ItemEntity currentItemToFollow;
    private final Set<ItemEntity> ignoreItems;

    public EatFoodGoal(Mob entity, TagKey<Item> item) {
        this.entity = entity;
        this.itemTypesToFollow = item;
        this.ignoreItems = new HashSet<ItemEntity>();
        this.m_7684_().add(Goal.Flag.MOVE);
    }

    public boolean m_8036_() {
        AABB entityAABB = this.entity.m_20191_().m_82377_(20.0, 5.0, 20.0);
        if (!this.ignoreItems.isEmpty()) {
            this.ignoreItems.removeIf(Entity::m_213877_);
        }
        this.nearbyItems = this.entity.m_9236_().m_6443_(ItemEntity.class, entityAABB, itemEntity -> {
            boolean isValidItem = itemEntity.m_32055_().m_204117_(this.itemTypesToFollow);
            boolean isIgnored = this.ignoreItems.contains(itemEntity);
            return isValidItem && !isIgnored;
        });
        if (!this.nearbyItems.isEmpty()) {
            ItemEntity closestItem = null;
            for (ItemEntity itemEntity2 : this.nearbyItems) {
                if (closestItem == null) {
                    closestItem = itemEntity2;
                    continue;
                }
                if (!(this.entity.m_20280_((Entity)itemEntity2) < this.entity.m_20280_((Entity)closestItem))) continue;
                closestItem = itemEntity2;
            }
            if (this.entity.m_20182_().m_82554_(closestItem.m_20182_()) > 20.0) {
                return false;
            }
            RevervoxMod.LOGGER.debug("Nearby Items: " + this.nearbyItems.size());
            this.currentItemToFollow = closestItem;
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        if (this.currentItemToFollow == null) {
            return false;
        }
        if (this.entity.m_21573_().m_26571_() && this.nearbyItems.contains(this.currentItemToFollow) && this.currentItemToFollow.m_6084_()) {
            this.ignoreItems.add(this.currentItemToFollow);
        }
        return this.nearbyItems.contains(this.currentItemToFollow) && this.currentItemToFollow.m_6084_() && !this.entity.m_21573_().m_26571_();
    }

    public void m_8056_() {
        super.m_8056_();
        if (this.currentItemToFollow != null) {
            this.entity.m_21573_().m_5624_((Entity)this.currentItemToFollow, Objects.requireNonNull(this.entity.m_21051_(Attributes.f_22279_)).m_22135_());
        }
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.currentItemToFollow == null || !this.currentItemToFollow.m_6084_()) {
            return;
        }
        if (this.entity.m_21573_().m_26571_() || this.entity.m_20182_().m_82557_(this.currentItemToFollow.m_20182_()) > 25.0) {
            this.entity.m_21573_().m_5624_((Entity)this.currentItemToFollow, Objects.requireNonNull(this.entity.m_21051_(Attributes.f_22279_)).m_22135_());
        }
        if (this.entity.m_20182_().m_82554_(this.currentItemToFollow.m_20182_()) < 2.5) {
            RevervoxMod.LOGGER.debug("Eating");
            if (this.currentItemToFollow.m_32055_().getFoodProperties((LivingEntity)this.entity) != null) {
                this.entity.m_5584_(this.entity.m_9236_(), this.currentItemToFollow.m_32055_());
            } else {
                this.entity.m_9236_().m_247517_(null, this.entity.m_20183_(), SoundEvents.f_11912_, SoundSource.HOSTILE);
            }
            Entity entity = this.currentItemToFollow.m_19749_();
            if (entity instanceof ServerPlayer) {
                ServerPlayer spTarget = (ServerPlayer)entity;
                TriggerRegistry.REVERVOX_ATE_FOOD_TRIGGER.trigger(spTarget);
            }
            this.currentItemToFollow.m_146870_();
            this.nearbyItems.remove(this.currentItemToFollow);
        }
    }

    public void m_8041_() {
        super.m_8041_();
        RevervoxMod.LOGGER.debug("Stopping EatFoodGoal");
    }
}

