/*
 * Decompiled with CFR 0.152.
 */
package dev.omialien.revervoxmod.entity.goals;

import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.audiochannel.AudioChannel;
import de.maxhenkel.voicechat.api.audiochannel.EntityAudioChannel;
import dev.omialien.revervoxmod.RevervoxMod;
import dev.omialien.revervoxmod.config.RevervoxModServerConfigs;
import dev.omialien.revervoxmod.entity.custom.RevervoxGeoEntity;
import dev.omialien.voicechatrecording.VoiceChatRecording;
import dev.omialien.voicechatrecording.api.AudioEffect;
import dev.omialien.voicechatrecording.api.IRecordedAudio;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class RandomRepeatGoal
extends Goal {
    private final RevervoxGeoEntity mob;
    private static final int CHANNEL_DISTANCE = 50;
    private EntityAudioChannel channel;
    private int audiosPlayed = 0;
    private boolean canSpeak = true;

    public RandomRepeatGoal(RevervoxGeoEntity revervoxGeoEntity) {
        this.mob = revervoxGeoEntity;
        RevervoxMod.TASKS.schedule(this.setCanSpeak(), 0L);
    }

    public boolean m_8036_() {
        return this.canSpeak && this.mob.m_5448_() == null;
    }

    private AudioChannel getChannel() {
        if (this.channel == null) {
            UUID channelID = UUID.randomUUID();
            this.channel = RandomRepeatGoal.createChannel(VoiceChatRecording.vcApi, channelID, (Entity)this.mob);
        }
        return this.channel;
    }

    public void m_8041_() {
        this.channel = null;
        super.m_8041_();
    }

    public boolean m_8045_() {
        return false;
    }

    public void m_8037_() {
        this.canSpeak = false;
        if (this.audiosPlayed >= (Integer)RevervoxModServerConfigs.REVERVOX_MAX_AUDIOS.get()) {
            this.mob.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        RevervoxMod.LOGGER.debug("Less than " + RevervoxModServerConfigs.REVERVOX_MAX_AUDIOS.get() + " audios!");
        if (this.mob.getCurrentAudioPlayer() != null && this.mob.getCurrentAudioPlayer().isPlaying()) {
            return;
        }
        ArrayList nearbyPlayers = new ArrayList(this.mob.m_9236_().m_45955_(TargetingConditions.m_148353_(), (LivingEntity)this.mob, this.mob.m_20191_().m_82400_(50.0)));
        RevervoxMod.LOGGER.debug("Nearby Players: " + Arrays.toString(nearbyPlayers.toArray()));
        if (nearbyPlayers.isEmpty()) {
            RevervoxMod.LOGGER.debug("No players nearby");
            Level level = this.mob.m_9236_();
            Player nearestPlayer = null;
            for (Player player : Objects.requireNonNull(level.m_7654_()).m_6846_().m_11314_()) {
                if (!player.m_9236_().equals(this.mob.m_9236_())) continue;
                if (nearestPlayer != null) {
                    nearestPlayer = this.mob.m_20280_((Entity)player) < this.mob.m_20280_((Entity)nearestPlayer) ? player : nearestPlayer;
                    continue;
                }
                nearestPlayer = player;
            }
            if (nearestPlayer != null && this.mob.teleportTowards((Entity)nearestPlayer)) {
                RevervoxMod.LOGGER.debug("Teleporting towards nearest player: " + nearestPlayer.m_7755_());
                this.mob.playPlayerAudio(nearestPlayer, VoiceChatRecording.vcApi, this::getChannel);
                ++this.audiosPlayed;
            }
        } else {
            if (nearbyPlayers.size() <= 4 && nearbyPlayers.size() > 1) {
                RevervoxMod.LOGGER.debug("Atleast 2 players nearby");
                for (int i = 0; i < nearbyPlayers.size(); ++i) {
                    for (int k = i + 1; k < nearbyPlayers.size(); ++k) {
                        Player player2;
                        Player player1 = (Player)nearbyPlayers.get(i);
                        if (!(player1.m_20280_((Entity)(player2 = (Player)nearbyPlayers.get(k))) > 25.0)) continue;
                        RevervoxMod.LOGGER.debug("Atleast 2 players with distance greater than 25");
                        Player furthestPlayer = player1.m_20280_((Entity)this.mob) > player2.m_20280_((Entity)this.mob) ? player1 : player2;
                        this.mob.playPlayerAudio(furthestPlayer, VoiceChatRecording.vcApi, this::getChannel);
                        ++this.audiosPlayed;
                        return;
                    }
                }
            }
            RevervoxMod.LOGGER.debug("Playing audio from random player that is not near...");
            Set nearbyPlayerUUIDs = nearbyPlayers.stream().map(Entity::m_20148_).collect(Collectors.toSet());
            IRecordedAudio audio = RevervoxMod.AUDIOS.getRandomAudio(u -> !nearbyPlayerUUIDs.contains(u), true);
            if (audio == null) {
                audio = RevervoxMod.AUDIOS.getRandomAudio(true);
            }
            if (audio == null) {
                return;
            }
            this.mob.playAudio(audio.getAudio(), VoiceChatRecording.vcApi, this.getChannel(), new AudioEffect());
            ++this.audiosPlayed;
        }
    }

    private static EntityAudioChannel createChannel(VoicechatServerApi api, UUID channelID, Entity nearestEntity) {
        EntityAudioChannel channel = api.createEntityAudioChannel(channelID, api.fromEntity((Object)nearestEntity));
        if (channel == null) {
            RevervoxMod.LOGGER.error("Couldn't create channel");
            return null;
        }
        channel.setCategory("revervox_mod");
        channel.setDistance(50.0f);
        return channel;
    }

    private Runnable setCanSpeak() {
        return () -> {
            if (this.mob.m_6084_()) {
                this.canSpeak = true;
                int ticksToSpeak = new Random().nextInt(100, 200);
                RevervoxMod.TASKS.schedule(this.setCanSpeak(), (long)ticksToSpeak);
            }
        };
    }
}

