/*
 * Decompiled with CFR 0.152.
 */
package dev.omialien.revervoxmod.entity.goals;

import dev.omialien.revervoxmod.RevervoxMod;
import dev.omialien.revervoxmod.config.RevervoxModServerConfigs;
import dev.omialien.revervoxmod.entity.custom.RevervoxGeoEntity;
import dev.omialien.revervoxmod.registries.ParticleRegistry;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class RevervoxSonicBoomGoal
extends Goal {
    private final RevervoxGeoEntity mob;

    public RevervoxSonicBoomGoal(RevervoxGeoEntity mob) {
        this.m_7684_().add(Goal.Flag.MOVE);
        this.mob = mob;
    }

    public boolean m_8036_() {
        Player player = this.mob.m_5448_() instanceof Player ? (Player)this.mob.m_5448_() : null;
        boolean isTargetAboveGroundAndMobBelow = this.mob.m_20182_().m_7098_() < (double)this.mob.m_9236_().m_5736_() && player != null && player.m_20182_().m_7098_() > (double)this.mob.m_9236_().m_5736_();
        return (Boolean)RevervoxModServerConfigs.REVERVOX_SONIC_BOOM.get() != false && player != null && this.mob.m_20270_((Entity)player) <= (float)((Integer)RevervoxModServerConfigs.REVERVOX_SONIC_BOOM_RANGE.get()).intValue() && !this.mob.m_142582_((Entity)player) && this.mob.lostLineOfSightFor((Integer)RevervoxModServerConfigs.REVERVOX_SONIC_BOOM_COOLDOWN.get() * 20) && !isTargetAboveGroundAndMobBelow;
    }

    public void m_8056_() {
        this.startSonicBoom();
    }

    public void startSonicBoom() {
        this.mob.triggerAnim("Walk/Run/Idle", "SonicBoom");
        if (this.mob.m_5448_() == null) {
            return;
        }
        this.mob.m_7618_(EntityAnchorArgument.Anchor.FEET, this.mob.m_5448_().m_146892_());
        this.mob.m_21573_().m_26573_();
        int SONIC_BOOM_ANIM_DURATION_TICKS = 45;
        this.mob.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)this.mob.m_20182_()), SoundEvents.f_215772_, SoundSource.HOSTILE, 1.0f, 1.0f);
        RevervoxMod.TASKS.schedule(this.mob::resetNavigation, (long)SONIC_BOOM_ANIM_DURATION_TICKS);
        RevervoxMod.TASKS.schedule(this::doSonicBoom, 20L);
    }

    private void doSonicBoom() {
        Vec3 vec3 = this.mob.m_20182_().m_82549_(this.getChestAttachmentPos());
        if (this.mob.m_5448_() == null) {
            return;
        }
        Vec3 targetPosition = this.mob.m_5448_().m_146892_();
        Vec3 vec31 = targetPosition.m_82546_(vec3);
        Vec3 vec32 = vec31.m_82541_();
        int i = Mth.m_14107_((double)vec31.m_82553_()) + 7;
        LivingEntity target = this.mob.m_5448_();
        for (int j = 1; j < i; ++j) {
            Vec3 vec33 = vec3.m_82549_(vec32.m_82490_((double)j));
            ((ServerLevel)this.mob.m_9236_()).m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.REVERVOX_SONIC_BOOM_PARTICLES.get()), vec33.f_82479_, vec33.f_82480_, vec33.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (target.m_6469_(this.mob.m_9236_().m_269111_().m_269285_((Entity)this.mob), 10.0f)) {
            double d1 = 0.5 * (1.0 - target.m_21133_(Attributes.f_22278_));
            double d0 = 2.5 * (1.0 - target.m_21133_(Attributes.f_22278_));
            target.m_5997_(vec32.m_7096_() * d0, vec32.m_7098_() * d1, vec32.m_7094_() * d0);
        }
        this.mob.resetLineOfSight();
        this.mob.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)this.mob.m_20182_()), SoundEvents.f_215771_, SoundSource.HOSTILE, 1.0f, 1.0f);
    }

    public Vec3 getChestAttachmentPos() {
        return this.mob.m_20182_().m_82520_(0.0, (double)this.mob.m_20206_() * 0.7, 0.0);
    }
}

