/*
 * Decompiled with CFR 0.152.
 */
package dev.omialien.revervoxmod.entity.goals;

import dev.omialien.revervoxmod.RevervoxMod;
import dev.omialien.revervoxmod.entity.custom.HearingEntity;
import dev.omialien.revervoxmod.networking.RevervoxPacketHandler;
import dev.omialien.revervoxmod.networking.packets.AddSoundInstancePacket;
import dev.omialien.revervoxmod.registries.TriggerRegistry;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;

public class TargetSpokeGoal<M extends Mob & NeutralMob>
extends NearestAttackableTargetGoal<Player> {
    protected LivingEntity target;
    private final M entity;
    private int aggroTime;
    private Player pendingTarget;
    private final SoundEvent soundToPlay;
    private final SoundEvent soundToLoop;
    private final Predicate<LivingEntity> isAngerInducing;
    private final TargetingConditions startAggroTargetConditions;
    private final TargetingConditions continueAggroTargetConditions = TargetingConditions.m_148352_().m_148355_();

    public TargetSpokeGoal(M entity, Predicate<LivingEntity> pSelectionPredicate, SoundEvent soundToPlay, SoundEvent soundToLoop, int range) {
        super(entity, Player.class, 10, false, false, pSelectionPredicate);
        this.entity = entity;
        this.soundToPlay = soundToPlay;
        this.soundToLoop = soundToLoop;
        this.isAngerInducing = player -> {
            boolean isSpeakingAtMe = ((HearingEntity)entity).isSpeakingAtMe((Player)player);
            boolean isAngryAt = ((NeutralMob)entity).m_21674_(player);
            boolean hasIndirectPassenger = entity.m_20367_((Entity)player);
            return (isSpeakingAtMe || isAngryAt) && !hasIndirectPassenger;
        };
        this.startAggroTargetConditions = TargetingConditions.m_148352_().m_26883_((double)range).m_26888_(this.isAngerInducing).m_148355_();
    }

    public TargetSpokeGoal(M entity, Predicate<LivingEntity> pSelectionPredicate, SoundEvent soundToPlay, int range) {
        this(entity, pSelectionPredicate, soundToPlay, null, range);
    }

    public TargetSpokeGoal(M entity, Predicate<LivingEntity> pSelectionPredicate, int range) {
        this(entity, pSelectionPredicate, null, null, range);
    }

    public boolean m_8036_() {
        this.pendingTarget = this.entity.m_9236_().m_45946_(this.startAggroTargetConditions, this.entity);
        return this.pendingTarget != null && !(this.entity.m_5448_() instanceof Player);
    }

    public void m_8056_() {
        this.aggroTime = this.m_183277_(5);
        if (this.soundToPlay != null) {
            this.entity.m_9236_().m_6263_(null, this.entity.m_20185_(), this.entity.m_20186_(), this.entity.m_20189_(), this.soundToPlay, SoundSource.HOSTILE, 1.0f, 1.0f);
        }
        if (this.soundToLoop != null) {
            RevervoxPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this.f_26135_), (Object)new AddSoundInstancePacket(this.f_26135_.m_19879_(), this.soundToLoop, SoundSource.HOSTILE, true));
        }
        super.m_8056_();
    }

    public void m_8041_() {
        this.pendingTarget = null;
        super.m_8041_();
    }

    public boolean m_8045_() {
        if (this.pendingTarget != null) {
            if (!this.isAngerInducing.test((LivingEntity)this.pendingTarget)) {
                return false;
            }
            this.entity.m_21391_((Entity)this.pendingTarget, 10.0f, 10.0f);
            return true;
        }
        if (this.target != null) {
            if (this.entity.m_20367_((Entity)this.target)) {
                return false;
            }
            if (this.continueAggroTargetConditions.m_26885_(this.entity, this.target)) {
                return true;
            }
        }
        return super.m_8045_();
    }

    public void m_8037_() {
        if (this.entity.m_5448_() == null) {
            super.m_26070_(null);
        }
        if (this.pendingTarget != null) {
            if (--this.aggroTime <= 0) {
                this.target = this.pendingTarget;
                super.m_26070_(this.target);
                RevervoxMod.LOGGER.debug("Target: " + this.target.m_7755_());
                this.pendingTarget = null;
                super.m_8056_();
                LivingEntity livingEntity = this.target;
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer spTarget = (ServerPlayer)livingEntity;
                    TriggerRegistry.HEARD_REVERVOX_TRIGGER.trigger(spTarget);
                }
            }
        } else {
            super.m_8037_();
        }
    }
}

