/*
 * Decompiled with CFR 0.152.
 */
package dev.omialien.revervoxmod.events;

import com.mojang.brigadier.CommandDispatcher;
import dev.omialien.revervoxmod.RevervoxMod;
import dev.omialien.revervoxmod.commands.SummonFakeEntityCommand;
import dev.omialien.revervoxmod.config.RevervoxModServerConfigs;
import dev.omialien.revervoxmod.entity.custom.RevervoxBatGeoEntity;
import dev.omialien.revervoxmod.registries.EntityRegistry;
import dev.omialien.revervoxmod.registries.ItemRegistry;
import dev.omialien.revervoxmod.registries.RevervoxTags;
import dev.omialien.revervoxmod.voicechat.AudioStorage;
import dev.omialien.revervoxmod.voicechat.AudioUtil;
import dev.omialien.revervoxmod.voicechat.PlayerStateManager;
import dev.omialien.voicechatrecording.api.IRecordedAudio;
import dev.omialien.voicechatrecording.api.events.AudioLoadedEvent;
import dev.omialien.voicechatrecording.api.events.AudioRecordedEvent;
import dev.omialien.voicechatrecording.api.events.MicPacketReceivedEvent;
import dev.omialien.voicechatrecording.api.events.RecordingSetupEvent;
import dev.omialien.voicechatrecording.api.util.AudioPlayingUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="revervox_mod")
public class CommonEventBus {
    @SubscribeEvent
    public static void tickEvent(TickEvent.ServerTickEvent event) {
        RevervoxMod.TASKS.tick();
    }

    @SubscribeEvent
    public static void revervoxBatSpawnEvent(MobSpawnEvent.FinalizeSpawn event) {
        if (event.getEntity() instanceof Bat && !event.getLevel().m_5776_() && new Random().nextInt((Integer)RevervoxModServerConfigs.REVERVOX_BAT_SPAWN_CHANCE.get()) == 0) {
            RevervoxBatGeoEntity bat = new RevervoxBatGeoEntity((EntityType<? extends FlyingMob>)((EntityType)EntityRegistry.REVERVOX_BAT.get()), (Level)event.getLevel().m_6018_());
            bat.m_6027_(event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_());
            RevervoxMod.LOGGER.debug("Spawning Revervox Bat! at " + event.getEntity().m_20185_() + ", " + event.getEntity().m_20186_() + ", " + event.getEntity().m_20189_());
            event.setSpawnCancelled(true);
            event.getLevel().m_7967_((Entity)bat);
        }
    }

    @SubscribeEvent
    public static void onRegisterEvents(ServerStartingEvent event) {
        int nextEvent = new Random().nextInt((int)(12000.0 * (Double)RevervoxModServerConfigs.FAKE_BAT_EVENT_CHANCE.get()), (int)(24000.0 * (Double)RevervoxModServerConfigs.FAKE_BAT_EVENT_CHANCE.get()));
        RevervoxMod.LOGGER.debug("Scheduling bat for {} ticks", (Object)nextEvent);
        RevervoxMod.TASKS.schedule(CommonEventBus.fakeBatEventSpawnRequest(event.getServer().m_129880_(Level.f_46428_)), (long)nextEvent);
    }

    private static Runnable fakeBatEventSpawnRequest(ServerLevel level) {
        return () -> {
            RevervoxMod.LOGGER.debug("Starting fake bat event!");
            if (((Boolean)RevervoxModServerConfigs.ENABLE_FAKE_BAT_EVENT.get()).booleanValue()) {
                List playerList = level.m_7654_().m_6846_().m_11314_();
                if (!playerList.isEmpty()) {
                    int randomPlayer = new Random().nextInt(playerList.size());
                    if (((ServerPlayer)playerList.get(randomPlayer)).m_9236_().equals(level) && ((ServerPlayer)playerList.get(randomPlayer)).m_20186_() < (double)(level.m_5736_() - 25)) {
                        RevervoxMod.LOGGER.debug("Player met requirements, starting bat event!");
                        RevervoxMod.summonBatWave((Player)playerList.get(randomPlayer));
                    } else {
                        RevervoxMod.LOGGER.debug("Player didn't meet requirements, skipping bat event!");
                    }
                } else {
                    RevervoxMod.LOGGER.debug("(Fake Bat Event) playerList is empty");
                }
            }
            int nextRandomTick = new Random().nextInt((int)(12000.0 * (Double)RevervoxModServerConfigs.FAKE_BAT_EVENT_CHANCE.get()), (int)(24000.0 * (Double)RevervoxModServerConfigs.FAKE_BAT_EVENT_CHANCE.get()));
            RevervoxMod.LOGGER.debug("next bat event scheduled for {} ticks", (Object)nextRandomTick);
            RevervoxMod.TASKS.schedule(CommonEventBus.fakeBatEventSpawnRequest(level), (long)nextRandomTick);
        };
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        SummonFakeEntityCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onRecordingApiInitialized(RecordingSetupEvent event) {
        RevervoxMod.RECORDING_API = event.getApi();
        event.addCategory("revervox_mod", "Revervox", "The volume of monsters", null);
        RevervoxMod.AUDIOS = new AudioStorage();
    }

    @SubscribeEvent
    public static void onAudioRecordedEvent(AudioRecordedEvent event) {
        if (event.getAudio().getFilterResult() == IRecordedAudio.FilterResult.PASSED) {
            if (RevervoxMod.AUDIOS.getTotalAudioCount() >= (Integer)RevervoxModServerConfigs.RECORDING_LIMIT.get()) {
                RevervoxMod.AUDIOS.removeRandomAudio();
            }
            RevervoxMod.LOGGER.debug("Audio recorded and stored!");
            RevervoxMod.AUDIOS.addAudio(event.getAudio());
        }
    }

    @SubscribeEvent
    public static void onAudioLoadedEvent(AudioLoadedEvent event) {
        if (RevervoxMod.AUDIOS.getTotalAudioCount() < (Integer)RevervoxModServerConfigs.RECORDING_LIMIT.get() && event.getLoadReason() == AudioLoadedEvent.LoadType.NAMESPACE && event.getNamespace().equals("revervox_mod")) {
            RevervoxMod.LOGGER.debug("Storing namespace-loaded audio");
            RevervoxMod.AUDIOS.addAudio(event.getAudio());
        }
    }

    @SubscribeEvent
    public static void onMicrophonePacket(MicPacketReceivedEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        if (event.getPlayer().m_6117_() && event.getPlayer().m_21211_().m_150930_((Item)ItemRegistry.MEGAPHONE.get())) {
            short[] packet = PlayerStateManager.getPlayerDecoder(event.getPlayer().m_20148_()).decode(event.getPacket().getOpusEncodedData());
            double packetRMS = AudioUtil.calculateRMS(packet);
            if (!Double.isNaN(packetRMS)) {
                RevervoxMod.LOGGER.debug("Packet RMS: " + packetRMS);
                event.getPacket().setOpusEncodedData(PlayerStateManager.getPlayerEncoder(event.getPlayer().m_20148_()).encode(AudioUtil.applyRadioEffect(packet, 50.0)));
            }
            if (packetRMS > 4000.0) {
                PlayerStateManager.addScreamingPlayer(event.getPlayer().m_20148_());
            } else {
                PlayerStateManager.removeScreamingPlayer(event.getPlayer().m_20148_());
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        PlayerStateManager.removeState(event.getEntity().m_20148_());
        RevervoxMod.AUDIOS.savePlayerAudios(event.getEntity().m_20148_());
    }

    @SubscribeEvent
    public static void onPlayerConnect(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerStateManager.createState(event.getEntity().m_20148_());
        RevervoxMod.AUDIOS.loadPlayerAudios(event.getEntity().m_20148_());
    }

    @SubscribeEvent
    public static void repeatOnKill(LivingDeathEvent e) {
        LivingEntity livingEntity = e.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer plr = (ServerPlayer)livingEntity;
            Level level = e.getEntity().m_9236_();
            if (level instanceof ServerLevel) {
                IRecordedAudio audio;
                ServerLevel level2 = (ServerLevel)level;
                ItemStack weapon = ItemStack.f_41583_;
                Entity directEntity = e.getSource().m_7640_();
                if (directEntity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)directEntity;
                    weapon = living.m_21205_();
                }
                if (!weapon.m_41619_() && weapon.m_204117_(RevervoxTags.Items.AUDIO_ON_KILL) && (audio = RevervoxMod.AUDIOS.getRandomAudio(plr.m_20148_(), false)) != null) {
                    AudioPlayingUtil.playLocationalAudio((IRecordedAudio)audio, (Vec3)e.getEntity().m_20182_(), (ServerLevel)level2, (String)"revervox_mod");
                }
            }
        }
    }
}

