/*
 * Decompiled with CFR 0.152.
 */
package dev.omialien.revervoxmod.items;

import dev.omialien.revervoxmod.config.RevervoxModServerConfigs;
import dev.omialien.revervoxmod.entity.custom.RevervoxGeoEntity;
import dev.omialien.revervoxmod.items.client.MegaphoneItemExtensions;
import dev.omialien.revervoxmod.registries.ParticleRegistry;
import dev.omialien.revervoxmod.registries.TriggerRegistry;
import dev.omialien.revervoxmod.voicechat.PlayerStateManager;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MegaphoneItem
extends Item
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean usedItem = false;

    public MegaphoneItem(Item.Properties properties) {
        super(properties);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand usedHand) {
        ItemStack itemstack = player.m_21120_(usedHand);
        player.m_6672_(usedHand);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public void m_5929_(@NotNull Level level, @NotNull LivingEntity livingEntity, @NotNull ItemStack stack, int remainingUseDuration) {
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!(level.f_46443_ || this.usedItem || player.m_6047_() && ((Boolean)RevervoxModServerConfigs.CROUCH_PREVENTS_MEGAPHONE_BOOM.get()).booleanValue() || !PlayerStateManager.isScreaming(player.m_20148_()))) {
            this.doSonicBoom(level, player);
            this.usedItem = true;
            player.m_36335_().m_41524_((Item)this, (Integer)RevervoxModServerConfigs.MEGAPHONE_COOLDOWN.get() * 20);
        }
    }

    public void onStopUsing(@NotNull ItemStack stack, @NotNull LivingEntity entity, int count) {
        this.usedItem = false;
        super.onStopUsing(stack, entity, count);
    }

    private void doSonicBoom(Level level, Player player) {
        Vec3 vec3 = player.m_20182_().m_82520_(0.0, (double)player.m_20206_() * 0.7, 0.0);
        Vec3 playerFowardsPosition = player.m_146892_().m_82549_(player.m_20154_().m_82490_(10.0));
        Vec3 vec31 = playerFowardsPosition.m_82546_(vec3);
        Vec3 vec32 = vec31.m_82541_();
        int i = Mth.m_14107_((double)vec31.m_82553_()) + 7;
        ArrayList entitiesToHit = new ArrayList();
        for (int j = 1; j < i; ++j) {
            Vec3 vec33 = vec3.m_82549_(vec32.m_82490_((double)j));
            ((ServerLevel)level).m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.REVERVOX_SONIC_BOOM_PARTICLES.get()), vec33.f_82479_, vec33.f_82480_, vec33.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            AABB currentParticleAABB = new AABB(new BlockPos((int)vec33.f_82479_, (int)vec33.f_82480_, (int)vec33.f_82481_)).m_82377_(2.0, 2.0, 2.0);
            List nearbyEntities = level.m_45971_(LivingEntity.class, TargetingConditions.f_26872_, null, currentParticleAABB);
            entitiesToHit.addAll(nearbyEntities);
        }
        for (LivingEntity entity : entitiesToHit) {
            if (entity == player || !entity.m_6469_(level.m_269111_().m_269285_((Entity)player), 10.0f)) continue;
            double d1 = 0.5 * (1.0 - entity.m_21133_(Attributes.f_22278_));
            double d0 = 2.5 * (1.0 - entity.m_21133_(Attributes.f_22278_));
            entity.m_5997_(vec32.m_7096_() * d0, vec32.m_7098_() * d1, vec32.m_7094_() * d0);
            if (!(entity instanceof RevervoxGeoEntity)) continue;
            RevervoxGeoEntity revervox = (RevervoxGeoEntity)entity;
            revervox.setStunned(true);
            if (!(player instanceof ServerPlayer)) continue;
            ServerPlayer sp = (ServerPlayer)player;
            TriggerRegistry.REVERVOX_STUNNED_TRIGGER.trigger(sp);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            Vec3 look = player.m_20154_();
            Vec3 recoil = look.m_82548_().m_82541_().m_82490_(1.0);
            sp.m_5997_(recoil.f_82479_, recoil.f_82480_, recoil.f_82481_);
            sp.f_19864_ = true;
        }
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_215771_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public int m_8105_(@NotNull ItemStack pStack) {
        return (Integer)RevervoxModServerConfigs.MEGAPHONE_COOLDOWN.get() * 20;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.CUSTOM;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new MegaphoneItemExtensions());
    }
}

