/*
 * Decompiled with CFR 0.152.
 */
package dev.omialien.revervoxmod.items;

import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.audiochannel.AudioChannel;
import dev.omialien.revervoxmod.RevervoxMod;
import dev.omialien.voicechatrecording.VoiceChatRecording;
import dev.omialien.voicechatrecording.api.IRecordedAudio;
import dev.omialien.voicechatrecording.voicechat.audio.AudioPlayer;
import java.util.UUID;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class RevervoxVoiceBoxItem
extends Item {
    private int audioDuration = 0;
    private AudioChannel audioChannel;
    private Player playingPlayer;

    private AudioChannel getChannel(Player plr) {
        if (this.audioChannel == null || !plr.m_7306_((Entity)this.playingPlayer)) {
            this.playingPlayer = plr;
            this.audioChannel = VoiceChatRecording.vcApi.createEntityAudioChannel(UUID.randomUUID(), VoiceChatRecording.vcApi.fromEntity((Object)plr));
        }
        return this.audioChannel;
    }

    public RevervoxVoiceBoxItem(Item.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull InteractionHand pUsedHand) {
        ItemStack item = pPlayer.m_21120_(pUsedHand);
        boolean audioPlayed = false;
        if (!pLevel.m_5776_()) {
            IRecordedAudio audio = RevervoxMod.AUDIOS.getRandomAudio(false);
            if (audio != null) {
                this.audioDuration = audio.getAudio().length / 48000;
                this.playAudio(pPlayer, VoiceChatRecording.vcApi, audio.getAudio());
                audioPlayed = true;
                pPlayer.m_6672_(pUsedHand);
            } else {
                this.audioDuration = 1;
            }
            int cd = (int)Math.round(((double)this.audioDuration + 0.5) * 20.0);
            pPlayer.m_36335_().m_41524_((Item)this, cd);
            this.audioDuration = cd;
            pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
        return audioPlayed ? InteractionResultHolder.m_19098_((Object)item) : InteractionResultHolder.m_19100_((Object)item);
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack pStack) {
        return UseAnim.TOOT_HORN;
    }

    public int m_8105_(@NotNull ItemStack pStack) {
        return (this.audioDuration + 1) * 20;
    }

    private void playAudio(Player pPlayer, VoicechatServerApi api, short[] audio) {
        if (audio != null && this.getChannel(pPlayer) != null) {
            new AudioPlayer(audio, api, this.getChannel(pPlayer)).start();
        }
    }
}

