/*
 * Decompiled with CFR 0.152.
 */
package dev.omialien.revervoxmod.networking.packets;

import dev.omialien.revervoxmod.RevervoxMod;
import dev.omialien.revervoxmod.entity.custom.sound.EntityFollowingSoundInstance;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class AddSoundInstancePacket {
    private final int entityID;
    private final SoundEvent sound;
    private final SoundSource soundSource;
    private final boolean looping;

    public AddSoundInstancePacket(int entityID, SoundEvent sound, SoundSource soundSource, boolean looping) {
        RevervoxMod.LOGGER.debug("Created AddSoundInstancePacket");
        this.entityID = entityID;
        this.sound = sound;
        this.soundSource = soundSource;
        this.looping = looping;
    }

    public void encode(FriendlyByteBuf buffer) {
        RevervoxMod.LOGGER.debug("Encoded AddSoundInstancePacket");
        buffer.writeInt(this.entityID);
        buffer.m_130085_(this.sound.m_11660_());
        buffer.writeInt(this.soundSource.ordinal());
        buffer.writeBoolean(this.looping);
    }

    public static AddSoundInstancePacket decode(FriendlyByteBuf buffer) {
        RevervoxMod.LOGGER.debug("Decoded AddSoundInstancePacket");
        return new AddSoundInstancePacket(buffer.readInt(), SoundEvent.m_262824_((ResourceLocation)buffer.m_130281_()), SoundSource.values()[buffer.readInt()], buffer.readBoolean());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handle(Supplier<NetworkEvent.Context> ctx) {
        RevervoxMod.LOGGER.debug("Handling AddSoundInstancePacket");
        ctx.get().enqueueWork(() -> {
            RevervoxMod.LOGGER.debug("Sound instance packet received!");
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                Entity patt2410$temp;
                ClientLevel level = Minecraft.m_91087_().f_91073_;
                if (level != null && (patt2410$temp = level.m_6815_(this.entityID)) instanceof LivingEntity) {
                    LivingEntity entity = (LivingEntity)patt2410$temp;
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new EntityFollowingSoundInstance(entity, this.sound, this.soundSource, this.looping));
                } else {
                    RevervoxMod.LOGGER.error("Could not find entity with id {}", (Object)this.entityID);
                }
            });
        });
        ctx.get().setPacketHandled(true);
    }
}

