/*
 * Decompiled with CFR 0.152.
 */
package dev.omialien.revervoxmod.registries;

import dev.omialien.revervoxmod.items.MegaphoneItem;
import dev.omialien.revervoxmod.items.RevervoxBaitItem;
import dev.omialien.revervoxmod.items.RevervoxSword;
import dev.omialien.revervoxmod.items.RevervoxVoiceBoxItem;
import dev.omialien.revervoxmod.registries.CreativeTabRegistry;
import dev.omialien.revervoxmod.registries.EntityRegistry;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SwordItem;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ItemRegistry {
    private static final DeferredRegister<Item> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"revervox_mod");
    public static final RegistryObject<ForgeSpawnEggItem> THINGY_SPAWN_EGG = ItemRegistry.register("thingy_spawn_egg", () -> new ForgeSpawnEggItem(EntityRegistry.THINGY, 14673424, 1785855, new Item.Properties().m_41487_(64)));
    public static final RegistryObject<ForgeSpawnEggItem> REVERVOX_SPAWN_EGG = ItemRegistry.register("revervox_spawn_egg", () -> new ForgeSpawnEggItem(EntityRegistry.REVERVOX, 0x3B3B3B, 16770449, new Item.Properties().m_41487_(64)));
    public static final RegistryObject<ForgeSpawnEggItem> REVERVOX_BAT_SPAWN_EGG = ItemRegistry.register("revervox_bat_spawn_egg", () -> new ForgeSpawnEggItem(EntityRegistry.REVERVOX_BAT, 16770449, 0x3B3B3B, new Item.Properties().m_41487_(64)));
    public static final RegistryObject<RevervoxVoiceBoxItem> REVERVOX_VOICE_BOX = ItemRegistry.register("revervox_voice_box", () -> new RevervoxVoiceBoxItem(new Item.Properties().m_41487_(1)));
    public static final RegistryObject<RevervoxBaitItem> REVERVOX_BAIT = ItemRegistry.register("revervox_bait", () -> new RevervoxBaitItem(new Item.Properties().m_41487_(16)));
    public static final RegistryObject<Item> REVERVOX_EAR = ItemRegistry.register("revervox_ear", () -> new Item(new Item.Properties()));
    public static final RegistryObject<MegaphoneItem> MEGAPHONE = ItemRegistry.register("megaphone", () -> new MegaphoneItem(new Item.Properties().m_41487_(1)));
    public static final RegistryObject<SwordItem> REVERVOX_SWORD = ItemRegistry.register("revervox_sword", () -> new RevervoxSword(3, -2.4f, new Item.Properties()));
    public static final RegistryObject<Item> REVERVOX_BAT_TOOTH = ItemRegistry.register("revervox_bat_tooth", () -> new Item(new Item.Properties().m_41487_(16)));

    private static <T extends Item> RegistryObject<T> register(String name, Supplier<T> item, boolean inTab) {
        RegistryObject reg = REGISTRY.register(name, item);
        if (inTab) {
            CreativeTabRegistry.addToTab(reg);
        }
        return reg;
    }

    private static <T extends Item> RegistryObject<T> register(String name, Supplier<T> item) {
        return ItemRegistry.register(name, item, true);
    }

    public static void register(IEventBus eventBus) {
        REGISTRY.register(eventBus);
    }
}

