/*
 * Decompiled with CFR 0.152.
 */
package dev.omialien.revervoxmod.voicechat;

import dev.omialien.revervoxmod.RevervoxMod;
import dev.omialien.revervoxmod.config.RevervoxModServerConfigs;
import dev.omialien.voicechatrecording.api.IRecordedAudio;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class AudioStorage {
    public static final int SAMPLE_RATE = 48000;
    private final Random rnd = new Random();
    private final Map<UUID, List<IRecordedAudio>> storedAudios = new ConcurrentHashMap<UUID, List<IRecordedAudio>>();

    public int getTotalAudioCount() {
        return this.storedAudios.values().stream().mapToInt(List::size).sum();
    }

    public void addAudio(IRecordedAudio audio) {
        if (!this.storedAudios.containsKey(audio.getPlayerUUID())) {
            this.storedAudios.put(audio.getPlayerUUID(), new LinkedList());
        }
        audio.saveAudio("revervox_mod");
        this.storedAudios.get(audio.getPlayerUUID()).add(audio);
    }

    public IRecordedAudio getRandomAudio(UUID player, boolean remove) {
        RevervoxMod.LOGGER.debug("storage: getting random audio specific, remove {} at size {}", (Object)remove, (Object)this.getTotalAudioCount());
        List<IRecordedAudio> recs = this.storedAudios.get(player);
        if (recs == null || recs.isEmpty()) {
            return null;
        }
        int idx = this.rnd.nextInt(recs.size());
        IRecordedAudio audio = recs.get(idx);
        if (remove && this.getTotalAudioCount() > (Integer)RevervoxModServerConfigs.MINIMUM_AUDIO_COUNT.get()) {
            RevervoxMod.LOGGER.debug("removing random audio from get");
            this.storedAudios.get(player).remove(audio);
            RevervoxMod.RECORDING_API.unsaveAudio("revervox_mod", audio);
        }
        return audio;
    }

    public IRecordedAudio getRandomAudio(Predicate<UUID> includePlayer, boolean remove) {
        RevervoxMod.LOGGER.debug("storage: getting random audio preidcate, remove {} at size {}", (Object)remove, (Object)this.getTotalAudioCount());
        LinkedList total = new LinkedList();
        this.storedAudios.keySet().stream().filter(includePlayer).forEach(uuid -> total.addAll(this.storedAudios.get(uuid)));
        if (total.isEmpty()) {
            return null;
        }
        int randomIndex = this.rnd.nextInt(total.size());
        IRecordedAudio randomAudio = (IRecordedAudio)total.get(randomIndex);
        if (remove && this.getTotalAudioCount() > (Integer)RevervoxModServerConfigs.MINIMUM_AUDIO_COUNT.get()) {
            RevervoxMod.LOGGER.debug("removing random audio from get");
            this.storedAudios.get(randomAudio.getPlayerUUID()).remove(randomAudio);
            RevervoxMod.RECORDING_API.unsaveAudio("revervox_mod", randomAudio);
        }
        return randomAudio;
    }

    public IRecordedAudio getRandomAudio(boolean remove) {
        RevervoxMod.LOGGER.debug("storage: getting random audio, remove {} at size {}", (Object)remove, (Object)this.getTotalAudioCount());
        List total = this.storedAudios.values().stream().flatMap(Collection::stream).toList();
        if (total.isEmpty()) {
            return null;
        }
        int randomIndex = this.rnd.nextInt(total.size());
        IRecordedAudio randomAudio = (IRecordedAudio)total.get(randomIndex);
        if (remove && this.getTotalAudioCount() > (Integer)RevervoxModServerConfigs.MINIMUM_AUDIO_COUNT.get()) {
            RevervoxMod.LOGGER.debug("removing random audio from get");
            this.storedAudios.get(randomAudio.getPlayerUUID()).remove(randomAudio);
            RevervoxMod.RECORDING_API.unsaveAudio("revervox_mod", randomAudio);
        }
        return randomAudio;
    }

    public void removeRandomAudio() {
        RevervoxMod.LOGGER.debug("removing random audio method");
        List total = this.storedAudios.values().stream().flatMap(Collection::stream).toList();
        if (total.isEmpty()) {
            return;
        }
        IRecordedAudio toRemove = (IRecordedAudio)total.get(this.rnd.nextInt(total.size()));
        this.storedAudios.get(toRemove.getPlayerUUID()).remove(toRemove);
        RevervoxMod.RECORDING_API.unsaveAudio("revervox_mod", toRemove);
    }

    public void savePlayerAudios(UUID uuid) {
        List<IRecordedAudio> recs = this.storedAudios.get(uuid);
        if (recs != null && !recs.isEmpty()) {
            recs.forEach(audio -> audio.saveAudio("revervox_mod"));
        }
    }

    public void saveAudios() {
        Set audios = this.storedAudios.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        for (IRecordedAudio audio : audios) {
            audio.saveAudio("revervox_mod");
        }
    }

    public void loadPlayerAudios(UUID uuid) {
        RevervoxMod.RECORDING_API.loadPlayerAudios(uuid, audio -> {
            if (RevervoxMod.AUDIOS.getTotalAudioCount() < (Integer)RevervoxModServerConfigs.RECORDING_LIMIT.get()) {
                RevervoxMod.AUDIOS.addAudio((IRecordedAudio)audio);
            }
        });
    }
}

