/*
 * Decompiled with CFR 0.152.
 */
package dev.omialien.revervoxmod.voicechat;

import dev.omialien.voicechatrecording.configs.RecordingCommonConfig;

public class AudioUtil {
    public static short[] applyRadioEffect(short[] pcmBE, double gain) {
        float[] samples = new float[pcmBE.length];
        for (int i = 0; i < pcmBE.length; ++i) {
            samples[i] = (float)pcmBE[i] / 32768.0f;
        }
        float[] filtered = AudioUtil.bandPassFilter(samples, 300.0, 3500.0, 48000);
        short[] out = new short[filtered.length];
        for (int i = 0; i < filtered.length; ++i) {
            float v = (float)((double)filtered[i] * gain);
            v = Math.max(-1.0f, Math.min(1.0f, v));
            out[i] = (short)(v * 32767.0f);
        }
        return out;
    }

    private static float[] bandPassFilter(float[] input, double lowCut, double highCut, int sampleRate) {
        int filterSize = 101;
        float[] filter = new float[filterSize];
        double nyquist = (double)sampleRate / 2.0;
        double low = lowCut / nyquist;
        double high = highCut / nyquist;
        for (int i = 0; i < filterSize; ++i) {
            int m = i - filterSize / 2;
            filter[i] = m == 0 ? (float)(2.0 * (high - low)) : (float)((Math.sin(Math.PI * 2 * high * (double)m) - Math.sin(Math.PI * 2 * low * (double)m)) / (Math.PI * (double)m));
            int n = i;
            filter[n] = (float)((double)filter[n] * (0.54 - 0.46 * Math.cos(Math.PI * 2 * (double)i / (double)(filterSize - 1))));
        }
        float[] output = new float[input.length];
        for (int i = 0; i < input.length; ++i) {
            double acc = 0.0;
            for (int j = 0; j < filterSize; ++j) {
                int idx = i - j;
                if (idx < 0) continue;
                acc += (double)(input[idx] * filter[j]);
            }
            output[i] = (float)acc;
        }
        return output;
    }

    public static double calculateRMS(short[] audio) {
        int end;
        int start;
        for (start = 0; start < audio.length && Math.abs(audio[start]) < (Integer)RecordingCommonConfig.SILENCE_THRESHOLD.get(); ++start) {
        }
        for (end = audio.length - 1; end > start && Math.abs(audio[end]) < (Integer)RecordingCommonConfig.SILENCE_THRESHOLD.get(); --end) {
        }
        int activeSamples = end - start + 1;
        long sumSquares = 0L;
        for (int i = start; i <= end; ++i) {
            short sample = audio[i];
            sumSquares += (long)(sample * sample);
        }
        return Math.sqrt((double)sumSquares / (double)activeSamples);
    }
}

