/*
 * Decompiled with CFR 0.152.
 */
package dev.omialien.revervoxmod.voicechat;

import com.mojang.datafixers.util.Pair;
import de.maxhenkel.voicechat.api.opus.OpusDecoder;
import de.maxhenkel.voicechat.api.opus.OpusEncoder;
import dev.omialien.voicechatrecording.VoiceChatRecording;
import java.util.UUID;

public class PlayerState {
    private boolean isScreaming;
    private long lastScream;
    private final UUID uuid;
    private Pair<OpusDecoder, OpusEncoder> coders;

    public PlayerState(UUID uuid) {
        this.uuid = uuid;
        this.isScreaming = false;
        this.coders = new Pair((Object)VoiceChatRecording.vcApi.createDecoder(), (Object)VoiceChatRecording.vcApi.createEncoder());
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setScreaming(boolean screaming) {
        if (screaming) {
            this.lastScream = System.currentTimeMillis();
        }
        this.isScreaming = screaming;
    }

    public boolean isScreaming() {
        return this.isScreaming && System.currentTimeMillis() - this.lastScream <= 500L;
    }

    public OpusDecoder getDecoder() {
        return (OpusDecoder)this.coders.getFirst();
    }

    public OpusEncoder getEncoder() {
        return (OpusEncoder)this.coders.getSecond();
    }
}

