/*
 * Decompiled with CFR 0.152.
 */
package dev.omialien.revervoxmod.voicechat;

import de.maxhenkel.voicechat.api.opus.OpusDecoder;
import de.maxhenkel.voicechat.api.opus.OpusEncoder;
import dev.omialien.revervoxmod.RevervoxMod;
import dev.omialien.revervoxmod.voicechat.PlayerState;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class PlayerStateManager {
    private static final Map<UUID, PlayerState> PLAYER_STATES = new ConcurrentHashMap<UUID, PlayerState>();

    public static void createState(UUID uuid) {
        if (PLAYER_STATES.containsKey(uuid)) {
            RevervoxMod.LOGGER.error("Tried to add already-existing state! {}", (Object)uuid);
            return;
        }
        PLAYER_STATES.put(uuid, new PlayerState(uuid));
    }

    public static void removeState(UUID uuid) {
        if (!PLAYER_STATES.containsKey(uuid)) {
            RevervoxMod.LOGGER.error("Tried to remove non-existing state! {}", (Object)uuid);
            return;
        }
        PLAYER_STATES.remove(uuid);
    }

    public static PlayerState getState(UUID uuid) {
        return PLAYER_STATES.get(uuid);
    }

    public static boolean isScreaming(UUID uuid) {
        return PlayerStateManager.getState(uuid).isScreaming();
    }

    public static void addScreamingPlayer(UUID uuid) {
        PlayerStateManager.getState(uuid).setScreaming(true);
    }

    public static void removeScreamingPlayer(UUID uuid) {
        PlayerStateManager.getState(uuid).setScreaming(false);
    }

    public static OpusDecoder getPlayerDecoder(UUID uuid) {
        return PlayerStateManager.getState(uuid).getDecoder();
    }

    public static OpusEncoder getPlayerEncoder(UUID uuid) {
        return PlayerStateManager.getState(uuid).getEncoder();
    }
}

