/*
 * Decompiled with CFR 0.152.
 */
package vayk.executablecrafting.customRecipes;

import com.ssomar.score.sobject.SObjectWithFileLoader;
import com.ssomar.score.sobject.SObjectWithFileManager;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.logging.Utils;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Optional;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import vayk.executablecrafting.ExecutableCrafting;
import vayk.executablecrafting.customRecipes.Recipe;
import vayk.executablecrafting.customRecipes.RecipeBuilder;
import vayk.executablecrafting.customRecipes.RecipeManager;

public class RecipeLoader
extends SObjectWithFileLoader<Recipe> {
    private static RecipeLoader instance;

    public RecipeLoader() {
        super((SPlugin)ExecutableCrafting.plugin, "/path/to/default/if/you/want", (SObjectWithFileManager)RecipeManager.getInstance(), 300);
    }

    public void load() {
        RecipeManager.getInstance().setDefaultObjects(new ArrayList());
        RecipeManager.getInstance().setLoadedObjects(new ArrayList());
        this.resetCpt();
        File recipesDirectory = new File(ExecutableCrafting.plugin.getDataFolder() + "/recipes");
        if (recipesDirectory.exists()) {
            this.loadObjectsInFolder(recipesDirectory, !ExecutableCrafting.plugin.isLotOfWork());
            Utils.sendConsoleMsg((String)(ExecutableCrafting.plugin.getNameDesign() + " &7Amount of Recipes configurations loaded: &e" + this.getCpt()));
        } else {
            this.createDefaultObjectsFile(!ExecutableCrafting.plugin.isLotOfWork());
            this.load();
        }
    }

    public void configVersionsConverter(File file) {
    }

    public Optional<Recipe> getObject(FileConfiguration itemConfig, String id, boolean showError, boolean isPremiumLoading, String path) {
        ArrayList<String> errors = new ArrayList<String>();
        Recipe recipe = RecipeBuilder.build(itemConfig, id, path);
        errors.addAll(recipe.load(ExecutableCrafting.plugin, (ConfigurationSection)itemConfig, isPremiumLoading));
        if (showError) {
            for (String s : errors) {
                Utils.sendConsoleMsg((String)(ExecutableCrafting.plugin.getNameDesign() + " " + StringConverter.coloredString((String)s)));
            }
        }
        return Optional.ofNullable(recipe);
    }

    public static RecipeLoader getInstance() {
        if (instance == null) {
            instance = new RecipeLoader();
        }
        return instance;
    }
}

