/*
 * Decompiled with CFR 0.152.
 */
package vayk.executablecrafting.recipeGroups;

import com.ssomar.score.commands.runnable.ActionInfo;
import com.ssomar.score.editor.Suggestion;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.custom.commands.player.PlayerCommandsFeature;
import com.ssomar.score.features.custom.conditions.block.parent.BlockConditionsFeature;
import com.ssomar.score.features.custom.conditions.placeholders.group.PlaceholderConditionGroupFeature;
import com.ssomar.score.features.custom.conditions.player.parent.PlayerConditionsFeature;
import com.ssomar.score.features.custom.itemcheckers.ItemCheckerType;
import com.ssomar.score.features.custom.itemcheckers.ItemCheckers;
import com.ssomar.score.features.types.list.ListUncoloredStringFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.sobject.SObjectWithFileEditable;
import com.ssomar.score.sobject.SObjectWithFileLoader;
import com.ssomar.score.sobject.menu.NewSObjectsManagerEditor;
import com.ssomar.score.sobject.menu.SObjectsEditorAbstract;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.messages.SendMessage;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vayk.executablecrafting.ExecutableCrafting;
import vayk.executablecrafting.config.GeneralConfig;
import vayk.executablecrafting.recipeGroups.RecipeGroupEditor;
import vayk.executablecrafting.recipeGroups.RecipeGroupEditorManager;
import vayk.executablecrafting.recipeGroups.RecipeGroupLoader;
import vayk.executablecrafting.recipeGroups.RecipeGroupManager;
import vayk.executablecrafting.recipeGroups.RecipeGroupsEditor;

public class RecipeGroup
extends SObjectWithFileEditable<RecipeGroup, RecipeGroupEditor, RecipeGroupEditorManager> {
    private ListUncoloredStringFeature recipesList;
    private PlayerConditionsFeature playerConditions;
    private BlockConditionsFeature blockConditions;
    private PlaceholderConditionGroupFeature placeholderConditions;
    private PlayerCommandsFeature commands;
    private ItemCheckers checkers;

    public RecipeGroup(FeatureParentInterface parent, String id, String path) {
        super((SPlugin)ExecutableCrafting.plugin, id, parent, (FeatureSettingsInterface)FeatureSettingsSCore.RECIPEGROUP, path, (SObjectWithFileLoader)RecipeGroupLoader.getInstance());
        this.reset();
    }

    public RecipeGroup(String id, String path) {
        super((SPlugin)ExecutableCrafting.plugin, id, (FeatureSettingsInterface)FeatureSettingsSCore.RECIPEGROUP, path, (SObjectWithFileLoader)RecipeGroupLoader.getInstance());
        this.reset();
    }

    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        features.add((FeatureInterface)this.recipesList);
        features.add((FeatureInterface)this.playerConditions);
        features.add((FeatureInterface)this.blockConditions);
        features.add((FeatureInterface)this.placeholderConditions);
        features.add((FeatureInterface)this.commands);
        features.add((FeatureInterface)this.checkers);
        return features;
    }

    public Map<FeatureInterface, Integer> getFeaturesMappingEditor() {
        HashMap<FeatureInterface, Integer> features = new HashMap<FeatureInterface, Integer>();
        features.put((FeatureInterface)this.recipesList, 1);
        features.put((FeatureInterface)this.playerConditions, 3);
        features.put((FeatureInterface)this.blockConditions, 4);
        features.put((FeatureInterface)this.placeholderConditions, 5);
        features.put((FeatureInterface)this.commands, 6);
        features.put((FeatureInterface)this.checkers, 7);
        return features;
    }

    public String getParentInfo() {
        return "(RecipeGroup: " + this.getId() + ")";
    }

    public void reload() {
        if (this.getParent() instanceof RecipeGroup) {
            RecipeGroup recipe = (RecipeGroup)this.getParent();
            recipe.setRecipesList(this.recipesList);
            recipe.setPlayerConditions(this.playerConditions);
            recipe.setBlockConditions(this.blockConditions);
            recipe.setPlaceholderConditions(this.placeholderConditions);
            recipe.setCommands(this.commands);
            recipe.setCheckers(this.checkers);
        }
    }

    public void openEditor(@NotNull Player player) {
        RecipeGroupEditorManager.getInstance().startEditing(player, (FeatureParentInterface)this);
    }

    public void openBackEditor(@NotNull Player player) {
        NewSObjectsManagerEditor.getInstance().startEditing(player, (SObjectsEditorAbstract)new RecipeGroupsEditor());
    }

    public List<String> load(SPlugin sPlugin, ConfigurationSection configurationSection, boolean isPremium) {
        ArrayList<String> errors = new ArrayList<String>();
        for (FeatureInterface feature : this.getFeatures()) {
            errors.addAll(feature.load(sPlugin, configurationSection, isPremium));
        }
        return errors;
    }

    public void save(ConfigurationSection configurationSection) {
        for (FeatureInterface feature : this.getFeatures()) {
            feature.save(configurationSection);
        }
        configurationSection.set("config_update", (Object)(!ExecutableCrafting.plugin.isLotOfWork() ? 1 : 0));
    }

    public RecipeGroup getValue() {
        return this;
    }

    public FeatureInterface initItemParentEditor(GUI gui, int i) {
        return null;
    }

    public void updateItemParentEditor(GUI gui) {
    }

    public void reset() {
        ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>();
        suggestions.add(new Suggestion("recipeId", "&erecipeId", "&6The ID of the recipe", null));
        suggestions.add(new Suggestion("prefix*", "&eprefix*", "&6Using *", null));
        this.recipesList = new ListUncoloredStringFeature((FeatureParentInterface)this, new ArrayList(), (FeatureSettingsInterface)FeatureSettingsSCore.recipesList, Optional.of(suggestions));
        this.playerConditions = new PlayerConditionsFeature((FeatureParentInterface)this, (FeatureSettingsInterface)FeatureSettingsSCore.playerConditions);
        this.blockConditions = new BlockConditionsFeature((FeatureParentInterface)this, (FeatureSettingsInterface)FeatureSettingsSCore.blockConditions);
        this.placeholderConditions = new PlaceholderConditionGroupFeature((FeatureParentInterface)this, (FeatureSettingsInterface)FeatureSettingsSCore.placeholdersConditions);
        this.commands = new PlayerCommandsFeature((FeatureParentInterface)this, (FeatureSettingsInterface)FeatureSettingsSCore.playerCommands);
        this.checkers = new ItemCheckers((FeatureParentInterface)this, ItemCheckerType.CUSTOM_CHECKS, GeneralConfig.getInstance().getItemCheckersDefaultValues(), (FeatureSettingsInterface)FeatureSettingsSCore.itemCheckers);
    }

    public ItemStack getIconItem() {
        return new ItemStack(Material.BOOK);
    }

    public boolean checkConditions(@Nullable OfflinePlayer player, @Nullable Block block) {
        Player onlinePlayer = null;
        if (player != null && player.isOnline()) {
            onlinePlayer = player.getPlayer();
        }
        List<RecipeGroup> recipeGroups = RecipeGroupManager.getInstance().getRecipeGroupsAssociatedToRecipe(this.getId());
        for (RecipeGroup recipeGroup : recipeGroups) {
            if (recipeGroup.checkConditions(player, block)) continue;
            return false;
        }
        if (onlinePlayer != null && !this.getPlayerConditions().verifConditions(onlinePlayer, new ArrayList(), new StringPlaceholder().setPlayerPlcHldr(player.getUniqueId()))) {
            return false;
        }
        if (block != null && !this.getBlockConditions().verifConditions(block, Optional.ofNullable(onlinePlayer), new SendMessage(), null)) {
            return false;
        }
        return this.getPlaceholderConditions().verifConditions(player, new ArrayList());
    }

    public FeatureParentInterface cloneParent(FeatureParentInterface parentOfTheParent) {
        return super.cloneParent(parentOfTheParent);
    }

    public void runCommands(Player player) {
        StringPlaceholder stringPlaceholder = new StringPlaceholder();
        stringPlaceholder.setPlayerPlcHldr(player.getUniqueId());
        ActionInfo actionInfo = new ActionInfo("", stringPlaceholder);
        actionInfo.setReceiverUUID(player.getUniqueId());
        this.commands.runCommands(actionInfo, "");
    }

    public FeatureInterface clone(FeatureParentInterface featureParentInterface) {
        RecipeGroup clone = new RecipeGroup(featureParentInterface, this.getId(), this.getPath());
        clone.setRecipesList(this.recipesList.clone((FeatureParentInterface)clone));
        clone.setPlayerConditions(this.playerConditions.clone((FeatureParentInterface)clone));
        clone.setBlockConditions(this.blockConditions.clone((FeatureParentInterface)clone));
        clone.setPlaceholderConditions(this.placeholderConditions.clone((FeatureParentInterface)clone));
        clone.setCommands(this.commands.clone((FeatureParentInterface)clone));
        clone.setCheckers(this.checkers.clone((FeatureParentInterface)clone));
        return clone;
    }

    public boolean isAssociatedWithRecipe(String recipeId) {
        for (String recipe : this.recipesList.getValue()) {
            String[] split;
            if (recipe.equals(recipeId)) {
                return true;
            }
            if (recipe.equals("*")) {
                return true;
            }
            if (!recipe.contains("*") || (split = recipe.split("\\*")).length != 2) continue;
            return recipeId.startsWith(split[0]);
        }
        return false;
    }

    public boolean verifyItemsSimilarity(ItemStack item1, ItemStack item2) {
        return this.checkers.isSimilar(item1, item2);
    }

    @Generated
    public ListUncoloredStringFeature getRecipesList() {
        return this.recipesList;
    }

    @Generated
    public PlayerConditionsFeature getPlayerConditions() {
        return this.playerConditions;
    }

    @Generated
    public BlockConditionsFeature getBlockConditions() {
        return this.blockConditions;
    }

    @Generated
    public PlaceholderConditionGroupFeature getPlaceholderConditions() {
        return this.placeholderConditions;
    }

    @Generated
    public PlayerCommandsFeature getCommands() {
        return this.commands;
    }

    @Generated
    public ItemCheckers getCheckers() {
        return this.checkers;
    }

    @Generated
    public void setRecipesList(ListUncoloredStringFeature recipesList) {
        this.recipesList = recipesList;
    }

    @Generated
    public void setPlayerConditions(PlayerConditionsFeature playerConditions) {
        this.playerConditions = playerConditions;
    }

    @Generated
    public void setBlockConditions(BlockConditionsFeature blockConditions) {
        this.blockConditions = blockConditions;
    }

    @Generated
    public void setPlaceholderConditions(PlaceholderConditionGroupFeature placeholderConditions) {
        this.placeholderConditions = placeholderConditions;
    }

    @Generated
    public void setCommands(PlayerCommandsFeature commands) {
        this.commands = commands;
    }

    @Generated
    public void setCheckers(ItemCheckers checkers) {
        this.checkers = checkers;
    }
}

