/*
 * Decompiled with CFR 0.152.
 */
package vayk.executablecrafting.customRecipes.types;

import com.ssomar.score.SCore;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.custom.itemcheckers.ItemCheckerEnum;
import com.ssomar.score.features.custom.itemcheckers.ItemCheckerType;
import com.ssomar.score.features.custom.itemcheckers.ItemCheckers;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.DoubleFeature;
import com.ssomar.score.features.types.IntegerFeature;
import com.ssomar.score.features.types.ItemStackFeature;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.plugin.Plugin;
import vayk.executablecrafting.ExecutableCrafting;
import vayk.executablecrafting.customRecipes.Recipe;
import vayk.executablecrafting.customRecipes.RecipeInput;
import vayk.executablecrafting.customRecipes.RecipeManager;
import vayk.executablecrafting.recipeGroups.RecipeGroup;
import vayk.executablecrafting.recipeGroups.RecipeGroupManager;

public class RecipeFurnace
extends Recipe {
    private ItemStackFeature input;
    private DoubleFeature experience;
    private IntegerFeature cookingTime;
    public long lastReload = 0L;

    public RecipeFurnace(FeatureParentInterface parent, String id, String path) {
        super(parent, id, path);
    }

    public RecipeFurnace(String id, String path) {
        super(id, path);
    }

    public RecipeFurnace clone(FeatureParentInterface parent) {
        RecipeFurnace clone = new RecipeFurnace((FeatureParentInterface)this, this.getId(), this.getPath());
        clone.setType(this.getType().clone((FeatureParentInterface)clone));
        clone.setResult(this.getResult().clone((FeatureParentInterface)clone));
        clone.setPlayerConditions(this.getPlayerConditions().clone((FeatureParentInterface)clone));
        clone.setBlockConditions(this.getBlockConditions().clone((FeatureParentInterface)clone));
        clone.setPlaceholderConditions(this.getPlaceholderConditions().clone((FeatureParentInterface)clone));
        clone.setCommands(this.getCommands().clone((FeatureParentInterface)clone));
        clone.setCheckers(this.getCheckers().clone((FeatureParentInterface)clone));
        clone.setInput(this.input.clone((FeatureParentInterface)clone));
        clone.setExperience(this.experience.clone((FeatureParentInterface)clone));
        clone.setCookingTime(this.cookingTime.clone((FeatureParentInterface)clone));
        return clone;
    }

    public boolean isInputEqualsTo(ItemStack item) {
        if (!this.input.getValue().isPresent()) {
            return false;
        }
        return this.verifyItemsSimilarity(new RecipeInput((ItemStack)this.input.getValue().get(), null), item);
    }

    @Override
    public void reset() {
        super.reset();
        this.input = new ItemStackFeature((FeatureParentInterface)this, Optional.empty(), (FeatureSettingsInterface)FeatureSettingsSCore.input1);
        this.experience = new DoubleFeature((FeatureParentInterface)this, Optional.of(0.0), (FeatureSettingsInterface)FeatureSettingsSCore.experience);
        this.cookingTime = new IntegerFeature((FeatureParentInterface)this, Optional.of(200), (FeatureSettingsInterface)FeatureSettingsSCore.cookingTime);
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        List<FeatureInterface> features = super.getFeatures();
        features.add((FeatureInterface)this.input);
        features.add((FeatureInterface)this.experience);
        features.add((FeatureInterface)this.cookingTime);
        return features;
    }

    @Override
    public Map<FeatureInterface, Integer> getFeaturesMappingEditor() {
        Map<FeatureInterface, Integer> features = super.getFeaturesMappingEditor();
        features.put((FeatureInterface)this.experience, 18);
        features.put((FeatureInterface)this.cookingTime, 27);
        features.put((FeatureInterface)this.input, 30);
        return features;
    }

    @Override
    public void reload() {
        super.reload();
        if (this.getParent() instanceof RecipeFurnace) {
            RecipeFurnace recipe = (RecipeFurnace)this.getParent();
            recipe.setInput(this.input);
            recipe.setExperience(this.experience);
            recipe.setCookingTime(this.cookingTime);
            RecipeManager.getInstance().actionOnObjectWhenReloading(recipe);
        }
    }

    public void registerRecipe() {
        FurnaceRecipe furnaceRecipe;
        if (System.currentTimeMillis() - this.lastReload < 1000L) {
            return;
        }
        this.lastReload = System.currentTimeMillis();
        if (this.input.getItemsStack() == null || this.input.getItemsStack().getType().isAir()) {
            return;
        }
        NamespacedKey key = new NamespacedKey((Plugin)ExecutableCrafting.plugin, this.getId());
        if (this.getCheckers().getItemCheckerType().getValue().get() == ItemCheckerType.ITEM_MUST_BE_EXACTLY_THE_SAME) {
            RecipeChoice.ExactChoice choice = new RecipeChoice.ExactChoice(this.input.getItemsStack());
            furnaceRecipe = new FurnaceRecipe(key, this.getResult().getItemsStack(), (RecipeChoice)choice, ((Double)this.getExperience().getValue().get()).floatValue(), ((Integer)this.getCookingTime().getValue().get()).intValue());
        } else {
            furnaceRecipe = new FurnaceRecipe(key, this.getResult().getItemsStack(), this.getInput().getItemsStack().getType(), ((Double)this.getExperience().getValue().get()).floatValue(), ((Integer)this.getCookingTime().getValue().get()).intValue());
        }
        if (Bukkit.getRecipe((NamespacedKey)key) != null) {
            Bukkit.removeRecipe((NamespacedKey)key);
        }
        Runnable runnable = () -> {
            Bukkit.addRecipe((org.bukkit.inventory.Recipe)furnaceRecipe);
            for (Player player : Bukkit.getOnlinePlayers()) {
                player.discoverRecipe(new NamespacedKey((Plugin)ExecutableCrafting.plugin, this.getId()));
            }
        };
        SCore.schedulerHook.runTask(runnable, 1L);
    }

    @Override
    public boolean verifyItemsSimilarity(RecipeInput input, ItemStack item) {
        List<RecipeGroup> recipeGroups = RecipeGroupManager.getInstance().getRecipeGroupsAssociatedToRecipe(this.getId());
        for (RecipeGroup recipeGroup : recipeGroups) {
            if (recipeGroup.verifyItemsSimilarity(input.getItem(), item)) continue;
            return false;
        }
        ItemCheckers checkers = this.getCheckers();
        ((BooleanFeature)checkers.getCheckers().get(ItemCheckerEnum.MATERIAL)).setValue(true);
        boolean isSimilar = checkers.isSimilar(input.getItem(), item);
        return isSimilar;
    }

    @Override
    public List<RecipeInput> getInputs() {
        ArrayList<RecipeInput> inputs = new ArrayList<RecipeInput>();
        inputs.add(new RecipeInput(this.input.getItemsStack(), null));
        return inputs;
    }

    @Generated
    public ItemStackFeature getInput() {
        return this.input;
    }

    @Generated
    public DoubleFeature getExperience() {
        return this.experience;
    }

    @Generated
    public IntegerFeature getCookingTime() {
        return this.cookingTime;
    }

    @Generated
    public long getLastReload() {
        return this.lastReload;
    }

    @Generated
    public void setInput(ItemStackFeature input) {
        this.input = input;
    }

    @Generated
    public void setExperience(DoubleFeature experience) {
        this.experience = experience;
    }

    @Generated
    public void setCookingTime(IntegerFeature cookingTime) {
        this.cookingTime = cookingTime;
    }

    @Generated
    public void setLastReload(long lastReload) {
        this.lastReload = lastReload;
    }
}

