/*
 * Decompiled with CFR 0.152.
 */
package vayk.executablecrafting.events;

import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.ActionInfo;
import com.ssomar.score.utils.emums.AnvilMergeType;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import vayk.executablecrafting.config.GeneralConfig;
import vayk.executablecrafting.customRecipes.RecipeManager;
import vayk.executablecrafting.customRecipes.types.RecipeAnvil;

public class AnvilListener
implements Listener {
    private ItemStack calculateResult(Player player, AnvilInventory inventory) {
        ItemStack item2;
        ItemStack item1 = inventory.getItem(0);
        if (item1 == null | (item2 = inventory.getItem(1)) == null) {
            return null;
        }
        Location loc = inventory.getLocation();
        if (loc == null) {
            return null;
        }
        Block block = loc.getBlock();
        RecipeAnvil anvilRecipe = RecipeManager.getInstance().getAnvilRecipe(item1, item2);
        if (anvilRecipe != null) {
            if (!anvilRecipe.checkConditions((OfflinePlayer)player, block)) {
                return null;
            }
            AnvilMergeType mergeType = (AnvilMergeType)anvilRecipe.getMergeType().getValue().get();
            ItemStack result = null;
            if (mergeType == AnvilMergeType.CUSTOM_RESULT) {
                result = anvilRecipe.resultItem();
            } else if (mergeType == AnvilMergeType.INPUT1_AS_RESULT) {
                result = item1.clone();
                result.setAmount(1);
            } else if (mergeType == AnvilMergeType.INPUT2_AS_RESULT) {
                result = item2.clone();
                result.setAmount(1);
            }
            ActionInfo actionInfo = new ActionInfo("", new StringPlaceholder());
            actionInfo.setLauncherUUID(player.getUniqueId());
            actionInfo.setItemStack(result);
            anvilRecipe.getItemCommandFeature().runCommands(actionInfo, "");
            return result;
        }
        return null;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void PrepareAnvilEventNormal(PrepareAnvilEvent event) {
        if (GeneralConfig.getInstance().getConfigEventPriority() != EventPriority.NORMAL) {
            return;
        }
        this.runPrepareAnvilEventActions(event);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void PrepareAnvilEventHigh(PrepareAnvilEvent event) {
        if (GeneralConfig.getInstance().getConfigEventPriority() != EventPriority.HIGH) {
            return;
        }
        this.runPrepareAnvilEventActions(event);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void PrepareAnvilEventHighest(PrepareAnvilEvent event) {
        if (GeneralConfig.getInstance().getConfigEventPriority() != EventPriority.HIGHEST) {
            return;
        }
        this.runPrepareAnvilEventActions(event);
    }

    public void runPrepareAnvilEventActions(PrepareAnvilEvent event) {
        for (HumanEntity viewer : event.getInventory().getViewers()) {
            if (!(viewer instanceof Player)) continue;
            Player player = (Player)viewer;
            try {
                ItemStack result = this.calculateResult(player, event.getInventory());
                if (result == null) {
                    return;
                }
                Runnable runnable = () -> {
                    event.setResult(result);
                    event.getInventory().setItem(2, result);
                    player.updateInventory();
                };
                SCore.schedulerHook.runEntityTask(runnable, null, (Entity)player, 0L);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
    }

    @EventHandler
    public void resetAnvil(InventoryClickEvent event) {
        Inventory inventory = event.getClickedInventory();
        if (inventory != null && inventory.getType() == InventoryType.ANVIL) {
            Player player = (Player)event.getWhoClicked();
            if (event.getRawSlot() == 2 && inventory.getItem(2) != null && player.getItemOnCursor().getType() == Material.AIR) {
                ItemStack item1 = inventory.getItem(0);
                ItemStack item2 = inventory.getItem(1);
                int amount1 = -100;
                int amount2 = -100;
                RecipeAnvil anvilRecipe = RecipeManager.getInstance().getAnvilRecipe(item1, item2);
                if (anvilRecipe == null) {
                    return;
                }
                ItemStack input1 = anvilRecipe.getInput1().getItemsStack();
                ItemStack input2 = anvilRecipe.getInput2().getItemsStack();
                amount1 = input1 != null ? input1.getAmount() : -100;
                amount2 = input2 != null ? input2.getAmount() : -100;
                player.setItemOnCursor(event.getCurrentItem());
                event.getClickedInventory().setItem(2, null);
                if (amount1 == -100) {
                    this.reduceItemAmount(inventory, 0, 1);
                    this.reduceItemAmount(inventory, 1, 1);
                } else {
                    this.reduceItemAmount(inventory, 0, amount1);
                    this.reduceItemAmount(inventory, 1, amount2);
                }
                inventory.setItem(2, this.calculateResult(player, (AnvilInventory)inventory));
                player.updateInventory();
            }
        }
    }

    private void reduceItemAmount(Inventory inventory, int slot, int amount) {
        ItemStack item = inventory.getItem(slot);
        if (item != null && item.getAmount() > amount) {
            item.setAmount(item.getAmount() - amount);
        } else {
            inventory.setItem(slot, null);
        }
    }
}

