/*
 * Decompiled with CFR 0.152.
 */
package vayk.executablecrafting.recipeBooks;

import com.ssomar.score.SsomarDev;
import com.ssomar.score.configs.messages.MessageInterface;
import com.ssomar.score.configs.messages.MessageMain;
import com.ssomar.score.utils.emums.RecipeType;
import com.ssomar.score.utils.strings.StringConverter;
import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.registry.data.dialog.ActionButton;
import io.papermc.paper.registry.data.dialog.DialogBase;
import io.papermc.paper.registry.data.dialog.DialogRegistryEntry;
import io.papermc.paper.registry.data.dialog.action.DialogAction;
import io.papermc.paper.registry.data.dialog.body.DialogBody;
import io.papermc.paper.registry.data.dialog.body.ItemDialogBody;
import io.papermc.paper.registry.data.dialog.body.PlainMessageDialogBody;
import io.papermc.paper.registry.data.dialog.input.DialogInput;
import io.papermc.paper.registry.data.dialog.input.NumberRangeDialogInput;
import io.papermc.paper.registry.data.dialog.type.DialogType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.dialog.DialogLike;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickCallback;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import vayk.executablecrafting.ExecutableCrafting;
import vayk.executablecrafting.config.GeneralConfig;
import vayk.executablecrafting.config.messages.Message;
import vayk.executablecrafting.customRecipes.Recipe;
import vayk.executablecrafting.customRecipes.RecipeCraftResult;
import vayk.executablecrafting.customRecipes.RecipeInput;
import vayk.executablecrafting.customRecipes.RecipeManager;
import vayk.executablecrafting.recipeBooks.ItemBuilder;
import vayk.executablecrafting.recipeBooks.RecipeBook;
import vayk.executablecrafting.recipeBooks.RecipeBookManagement;

public class RecipeBookManagementDialogs {
    public static void openFolderFromRecipeBook(Player player, String key, String folder, String page, RecipeBook recipeBook) {
        List<String> recipesInFolder = recipeBook.getFolders().get(folder);
        if (recipesInFolder == null) {
            return;
        }
        String title = StringConverter.coloredString((String)RecipeBookManagement.parseTitle(StringConverter.coloredString((String)MessageMain.getInstance().getMessage((Plugin)ExecutableCrafting.plugin, (MessageInterface)Message.RECIPE_BOOK_TITLE_FOLDER)), key, null, folder, page, null));
        Inventory gui = Bukkit.createInventory((InventoryHolder)player, (int)54, (String)title);
        int currentPage = Integer.parseInt(page);
        int recipesPerPage = 51;
        int totalRecipes = recipesInFolder.size();
        int totalPages = (int)Math.ceil((double)totalRecipes / (double)recipesPerPage);
        ActionButton next = ActionButton.create((Component)Component.text((String)"\u00a7fNext Page"), (Component)Component.text((String)"\u00a7e\u00a7oGo to the next page"), (int)70, null);
        if (currentPage >= totalPages) {
            next = ActionButton.create((Component)Component.text((String)""), (Component)Component.text((String)"\u00a7e\u00a7oNo next page"), (int)70, null);
        }
        ActionButton previous = ActionButton.create((Component)Component.text((String)"\u00a7fPrevious Page"), (Component)Component.text((String)"\u00a7e\u00a7oGo to the previous page"), (int)45, null);
        if (currentPage <= 0) {
            previous = ActionButton.create((Component)Component.text((String)""), (Component)Component.text((String)"\u00a7e\u00a7oNo previous page"), (int)45, null);
        }
        ArrayList<ActionButton> actionButtons = new ArrayList<ActionButton>();
        if (currentPage > 1) {
            actionButtons.add(previous);
        }
        if (currentPage < totalPages) {
            actionButtons.add(next);
        }
        actionButtons.add(ActionButton.create((Component)Component.text((String)"\u00a7fBack"), (Component)Component.text((String)"\u00a7e\u00a7oBack to the recipe book"), (int)50, (DialogAction)DialogAction.customClick((view, audience) -> {
            if (audience instanceof Player) {
                // empty if block
            }
        }, (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().uses(1).build()))));
        ArrayList<ItemDialogBody> body = new ArrayList<ItemDialogBody>();
        int startIndex = (Integer.parseInt(page) - 1) * recipesPerPage;
        int endIndex = Math.min(startIndex + recipesPerPage, recipesInFolder.size());
        for (int i = startIndex; i < endIndex; ++i) {
            String ID = recipesInFolder.get(i);
            if (ID.startsWith("folder:")) {
                String folderName;
                String folderNameWithColor = folderName = ID.substring(7);
                if (folderName.startsWith("color:")) {
                    folderNameWithColor = folderName.replace("color:", "");
                    folderNameWithColor = StringConverter.coloredString((String)folderNameWithColor);
                }
                ItemStack folderB = new ItemBuilder(Material.CHEST).setName(folderNameWithColor).addPublicBukkit("recipeID", "folder_" + folderName).build();
                body.add(DialogBody.item((ItemStack)folderB, (PlainMessageDialogBody)DialogBody.plainMessage((Component)Component.text((String)("Folder: " + folderName)), (int)300), (boolean)true, (boolean)true, (int)18, (int)18));
                continue;
            }
            if (!RecipeManager.getInstance().isValidID(ID)) continue;
            Recipe recipe = RecipeManager.getInstance().getRecipe(ID).get();
            ItemStack item1 = new ItemBuilder(recipe.getResult().getItemsStack()).addPublicBukkit("recipeID", "recipe_" + ID).build();
            ItemBuilder resultItemB = new ItemBuilder(item1);
            if (GeneralConfig.getInstance().getBooleanSetting(GeneralConfig.Setting.recipeBookNameOfID.name())) {
                resultItemB.setName(ID);
            }
            boolean positive = true;
            if (!recipe.checkConditions((OfflinePlayer)player, null)) {
                positive = false;
                resultItemB.addPublicBukkit("available", "false");
                resultItemB.addLore("&c You don't have the required conditions to craft this item");
            }
            Component itemName = item1.getItemMeta().hasDisplayName() ? item1.getItemMeta().displayName() : Component.text((String)ItemBuilder.returnItemName(item1));
            MiniMessage mm = MiniMessage.miniMessage();
            Component name = mm.deserialize((Object)"<gradient:#ff7a00:#fff200>Recipe of:</gradient> ").append(itemName.colorIfAbsent((TextColor)NamedTextColor.WHITE)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)mm.deserialize((Object)"<gradient:#ff6a00:#ffa000:#ffd100:#fff200>Click here to view the recipe of:</gradient> ").append(itemName.colorIfAbsent((TextColor)NamedTextColor.WHITE)))).clickEvent(ClickEvent.callback(audience -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("ec recipe " + ((Player)audience).getName() + " " + ID))));
            body.add(DialogBody.item((ItemStack)resultItemB.build(), (PlainMessageDialogBody)DialogBody.plainMessage((Component)name, (int)300), (boolean)true, (boolean)true, (int)18, (int)18));
        }
        Dialog dialog = Dialog.create(b -> ((DialogRegistryEntry.Builder)b.empty()).base(DialogBase.builder((Component)Component.text((String)"                                                                                                                                                                                                                                        ", (TextColor)NamedTextColor.YELLOW)).body(body).build()).type((DialogType)DialogType.multiAction((List)actionButtons).build()));
        player.showDialog((DialogLike)dialog);
    }

    public void openRecipeFromRecipeBook(Player player, Recipe recipe) {
        RecipeType typeOfCrafting = (RecipeType)recipe.getType().getValue().get();
        List<RecipeInput> itemsRecipe = recipe.getInputs();
        ItemBuilder resultItemB = new ItemBuilder(recipe.getResult().getItemsStack()).addPublicBukkit("recipeID", "recipe_" + (Object)((Object)recipe));
        ItemBuilder typeOfCraftingItemB = null;
        switch (typeOfCrafting) {
            case CRAFTING: {
                typeOfCraftingItemB = new ItemBuilder(Material.CRAFTING_TABLE).setName(RecipeBookManagement.craftingTableName).setLore(RecipeBookManagement.craftingTableLore).setCustomModelData(RecipeBookManagement.craftingTableCustomModelData);
                break;
            }
            case FURNACE: {
                typeOfCraftingItemB = new ItemBuilder(Material.FURNACE).setName(RecipeBookManagement.furnaceName).setLore(RecipeBookManagement.furnaceLore).setCustomModelData(RecipeBookManagement.furnaceCustomModelData);
            }
        }
        if (typeOfCraftingItemB == null) {
            return;
        }
        ItemStack resultItem = resultItemB.build();
        ItemStack typeOfCraftingItem = typeOfCraftingItemB.build();
        String name = resultItem.getItemMeta().hasDisplayName() ? resultItem.getItemMeta().getDisplayName() : ItemBuilder.returnItemName(resultItem);
        ArrayList<Object> body = new ArrayList<Object>();
        body.add(DialogBody.item((ItemStack)typeOfCraftingItem, (PlainMessageDialogBody)DialogBody.plainMessage((Component)Component.text((String)"Recipe type"), (int)100), (boolean)true, (boolean)true, (int)18, (int)18));
        for (int i = 0; i < itemsRecipe.size(); ++i) {
            ItemStack item = itemsRecipe.get(i).getItem();
            if (item == null || item.getType() == Material.AIR) continue;
            body.add(DialogBody.item((ItemStack)item, (PlainMessageDialogBody)DialogBody.plainMessage((Component)Component.text((String)("Slot " + i)), (int)100), (boolean)true, (boolean)true, (int)18, (int)18));
        }
        body.add(DialogBody.item((ItemStack)resultItem, (PlainMessageDialogBody)DialogBody.plainMessage((Component)Component.text((String)"Item to Craft"), (int)100), (boolean)true, (boolean)true, (int)18, (int)18));
        RecipeCraftResult recipeCraftResult = recipe.getMaxCraftAmountBy(player, Integer.MAX_VALUE);
        int maxAmount = recipeCraftResult.getAmount();
        SsomarDev.testMsg((String)("Max amount: " + maxAmount), (boolean)true);
        NumberRangeDialogInput amountInput = DialogInput.numberRange((String)"amount", (int)200, (Component)Component.text((String)"Craft amount"), (String)"%2$s", (float)1.0f, (float)maxAmount, (Float)Float.valueOf((float)Math.min(1, maxAmount) + 0.0f), (Float)Float.valueOf(1.0f));
        PlainMessageDialogBody invalidBody = DialogBody.plainMessage((Component)Component.text((String)"\u00a7c\u00a7oYou don't have the required item(s)"));
        ArrayList<NumberRangeDialogInput> inputs = new ArrayList<NumberRangeDialogInput>();
        if (maxAmount > 0) {
            inputs.add(amountInput);
        } else {
            body.add(invalidBody);
        }
        Dialog dialog = Dialog.create(b -> ((DialogRegistryEntry.Builder)b.empty()).base(DialogBase.builder((Component)Component.text((String)"                                                                                                                                                                                                                     ", (TextColor)NamedTextColor.YELLOW)).body(body).inputs(inputs).build()).type((DialogType)DialogType.confirmation((ActionButton)ActionButton.create((Component)Component.text((String)"\u00a7fBack"), (Component)Component.text((String)"\u00a7e\u00a7oBack to the recipe folder"), (int)50, null), (ActionButton)ActionButton.create((Component)Component.text((String)"\u00a76Craft"), (Component)Component.text((String)"\u00a77\u00a7oClick to craft this item"), (int)120, (DialogAction)DialogAction.customClick((view, audience) -> {
            if (audience instanceof Player) {
                float amount;
                Player p = (Player)audience;
                float f = amount = view.getFloat("amount") != null ? view.getFloat("amount").floatValue() : 0.0f;
                if (amount <= 0.0f) {
                    p.sendMessage((Component)Component.text((String)"\u00a7c\u00a7oYou can't craft this item !"));
                    return;
                }
                RecipeCraftResult recipeCraftResult1 = recipe.getMaxCraftAmountBy(p, (int)amount);
                if (recipeCraftResult1.getAmount() <= 0) {
                    p.sendMessage((Component)Component.text((String)"\u00a7c\u00a7oYou don't have the required item(s) to craft this item !"));
                    return;
                }
                PlayerInventory inventory = p.getInventory();
                Map<ItemStack, Integer> itemsToConsume = recipeCraftResult1.getItems();
                for (Map.Entry<ItemStack, Integer> entry : itemsToConsume.entrySet()) {
                    ItemStack item = entry.getKey().clone();
                    int amountToConsume = entry.getValue();
                    item.setAmount(amountToConsume);
                    if (item.getType() == Material.AIR || amountToConsume <= 0) continue;
                    inventory.removeItem(new ItemStack[]{item});
                }
                ItemStack result = recipe.getResult().getItemsStack().clone();
                result.setAmount(result.getAmount() * (int)amount);
                if (result.getType() != Material.AIR) {
                    inventory.addItem(new ItemStack[]{result});
                    p.sendMessage((Component)Component.text((String)("\u00a7a\u00a7oYou successfully crafted " + result.getAmount() + "x " + ItemBuilder.returnItemName(result))));
                }
            }
        }, (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().uses(1).build()))))));
        player.showDialog((DialogLike)dialog);
    }
}

