/*
 * Decompiled with CFR 0.152.
 */
package vayk.executablecrafting.customRecipes;

import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.editor.SaveSessionPathManager;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.editor.FeatureEditorInterface;
import com.ssomar.score.languages.messages.TM;
import com.ssomar.score.languages.messages.Text;
import com.ssomar.score.languages.messages.TextInterface;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.sobject.SObject;
import com.ssomar.score.utils.emums.RecipeType;
import java.util.Map;
import org.bukkit.entity.Player;
import vayk.executablecrafting.customRecipes.Recipe;
import vayk.executablecrafting.customRecipes.RecipeManager;

public class RecipeEditor
extends FeatureEditorInterface<Recipe> {
    private Recipe recipe;

    public RecipeEditor(Recipe r) {
        super((FeatureSettingsInterface)FeatureSettingsSCore.RECIPE, 54);
        this.recipe = r;
        this.load();
    }

    public void load() {
        this.clearAndSetBackground();
        RecipeType type = (RecipeType)this.recipe.getType().getValue().get();
        Recipe convertedRecipe = this.recipe.convertTo(type);
        if (convertedRecipe != this.recipe) {
            Player player = (Player)this.getInventory().getViewers().get(0);
            SaveSessionPathManager.getInstance().removeLastPlayerSessionPath(player);
            this.recipe = convertedRecipe;
            RecipeManager.getInstance().reloadObject((SObject)convertedRecipe);
            convertedRecipe.openEditor(player);
            return;
        }
        Map<FeatureInterface, Integer> features = this.recipe.getFeaturesMappingEditor();
        for (FeatureInterface feature : features.keySet()) {
            feature.initAndUpdateItemParentEditor((GUI)this, features.get(feature).intValue());
        }
        this.createItem(ORANGE, 1, 46, GUI.RESET, false, false, TM.gA((TextInterface)Text.EDITOR_RESET_DESCRIPTION));
        this.createItem(RED, 1, 45, GUI.BACK, false, false, new String[0]);
        this.createItem(YELLOW, 1, 47, GUI.CHANGE_LANGUAGE, false, false, GeneralConfig.getInstance().getAvailableLocales(new String[]{"", "&e&oClick here to change the language"}));
        this.createItem(GREEN, 1, 53, GUI.SAVE, false, false, TM.gA((TextInterface)Text.EDITOR_SAVE_DESCRIPTION));
    }

    public Recipe getParent() {
        return this.recipe;
    }
}

