/*
 * Decompiled with CFR 0.152.
 */
package vayk.executablecrafting.customRecipes;

import com.ssomar.score.sobject.SObjectWithFileManager;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.emums.RecipeType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import vayk.executablecrafting.ExecutableCrafting;
import vayk.executablecrafting.customRecipes.Recipe;
import vayk.executablecrafting.customRecipes.RecipeLoader;
import vayk.executablecrafting.customRecipes.types.RecipeAnvil;
import vayk.executablecrafting.customRecipes.types.RecipeCrafting;
import vayk.executablecrafting.customRecipes.types.RecipeFurnace;

public class RecipeManager
extends SObjectWithFileManager<Recipe> {
    private static RecipeManager instance;

    public RecipeManager() {
        super((SPlugin)ExecutableCrafting.plugin, "Recipes");
    }

    public void actionOnObjectWhenLoading(Recipe recipe) {
        if (recipe instanceof RecipeFurnace) {
            ((RecipeFurnace)recipe).registerRecipe();
        }
    }

    public void actionOnObjectWhenReloading(Recipe recipe) {
        if (recipe instanceof RecipeFurnace) {
            ((RecipeFurnace)recipe).registerRecipe();
        }
    }

    public Optional<Recipe> methodObjectLoading(String id) {
        return RecipeLoader.getInstance().getObjectById(id, false);
    }

    public static RecipeManager getInstance() {
        if (instance == null) {
            instance = new RecipeManager();
        }
        return instance;
    }

    public boolean isValidID(String id) {
        for (Recipe item : this.getLoadedObjects()) {
            if (!item.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    public Optional<Recipe> getRecipe(String id) {
        for (Recipe item : this.getLoadedObjects()) {
            if (!item.getId().equals(id)) continue;
            return Optional.of(item);
        }
        return Optional.empty();
    }

    public List<Recipe> getRecipes(RecipeType type) {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        for (Recipe recipe : this.getLoadedObjects()) {
            if (!((RecipeType)recipe.getType().getValue().get()).equals((Object)type)) continue;
            recipes.add(recipe);
        }
        return recipes;
    }

    public List<RecipeFurnace> getFurnaceRecipes() {
        ArrayList<RecipeFurnace> recipes = new ArrayList<RecipeFurnace>();
        for (Recipe recipe : this.getLoadedObjects()) {
            if (!(recipe instanceof RecipeFurnace)) continue;
            recipes.add((RecipeFurnace)recipe);
        }
        return recipes;
    }

    public RecipeFurnace getFurnaceRecipe(ItemStack input) {
        for (RecipeFurnace recipe : this.getFurnaceRecipes()) {
            if (!recipe.isInputEqualsTo(input)) continue;
            return recipe;
        }
        return null;
    }

    public RecipeFurnace getFurnaceRecipeWithKey(NamespacedKey key) {
        for (RecipeFurnace recipe : this.getFurnaceRecipes()) {
            NamespacedKey recipeKey = new NamespacedKey((Plugin)ExecutableCrafting.plugin, recipe.getId());
            if (!recipeKey.equals((Object)key)) continue;
            return recipe;
        }
        return null;
    }

    public List<RecipeCrafting> getCraftingRecipes() {
        ArrayList<RecipeCrafting> recipes = new ArrayList<RecipeCrafting>();
        for (Recipe recipe : this.getLoadedObjects()) {
            if (!(recipe instanceof RecipeCrafting)) continue;
            recipes.add((RecipeCrafting)recipe);
        }
        return recipes;
    }

    public RecipeCrafting getCraftingRecipe(ItemStack[] grid, boolean is2x2Grid) {
        for (RecipeCrafting recipe : this.getCraftingRecipes()) {
            if (recipe.isValidGrid(grid, is2x2Grid, true) == 0) continue;
            return recipe;
        }
        return null;
    }

    public RecipeCrafting getCraftingRecipeWithResult(ItemStack result) {
        for (RecipeCrafting recipe : this.getCraftingRecipes()) {
            ItemStack recipeResult = recipe.getResult().getItemsStack();
            if (!recipeResult.isSimilar(result)) continue;
            return recipe;
        }
        return null;
    }

    public List<RecipeAnvil> getAnvilRecipes() {
        ArrayList<RecipeAnvil> recipes = new ArrayList<RecipeAnvil>();
        for (Recipe recipe : this.getLoadedObjects()) {
            if (!(recipe instanceof RecipeAnvil)) continue;
            recipes.add((RecipeAnvil)recipe);
        }
        return recipes;
    }

    public RecipeAnvil getAnvilRecipe(ItemStack input1, ItemStack input2) {
        for (RecipeAnvil recipe : this.getAnvilRecipes()) {
            if (recipe.isValidGrid(input1, input2) == 0) continue;
            return recipe;
        }
        return null;
    }

    public void registerRecipes() {
        for (RecipeFurnace recipe : this.getFurnaceRecipes()) {
            recipe.registerRecipe();
        }
    }

    public List<NamespacedKey> getRecipesKey() {
        ArrayList<NamespacedKey> keys = new ArrayList<NamespacedKey>();
        for (RecipeFurnace recipe : this.getFurnaceRecipes()) {
            NamespacedKey key = new NamespacedKey((Plugin)ExecutableCrafting.plugin, recipe.getId());
            keys.add(key);
        }
        return keys;
    }
}

