/*
 * Decompiled with CFR 0.152.
 */
package vayk.executablecrafting;

import com.ssomar.score.SCore;
import com.ssomar.score.config.Config;
import com.ssomar.score.configs.messages.MessageInterface;
import com.ssomar.score.configs.messages.MessageMain;
import com.ssomar.score.sobject.SObject;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.logging.Utils;
import java.util.ArrayList;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import vayk.executablecrafting.bukkit.Metrics;
import vayk.executablecrafting.charts.SimplePie;
import vayk.executablecrafting.commands.CommandClass;
import vayk.executablecrafting.config.GeneralConfig;
import vayk.executablecrafting.config.messages.Message;
import vayk.executablecrafting.customRecipes.Recipe;
import vayk.executablecrafting.customRecipes.RecipeLoader;
import vayk.executablecrafting.customRecipes.RecipeManager;
import vayk.executablecrafting.events.AnvilListener;
import vayk.executablecrafting.events.CraftingTableListener;
import vayk.executablecrafting.events.DialogsListener;
import vayk.executablecrafting.events.EditorInteractionsListener;
import vayk.executablecrafting.events.FurnaceListener;
import vayk.executablecrafting.events.OnPlayerJoinListener;
import vayk.executablecrafting.recipeBooks.needtorework.RecipeBookManagement;
import vayk.executablecrafting.recipeBooks.needtorework.RecipeBooksEvents;
import vayk.executablecrafting.recipeGroups.RecipeGroup;
import vayk.executablecrafting.recipeGroups.RecipeGroupLoader;

public class ExecutableCrafting
extends JavaPlugin
implements SPlugin {
    public static ExecutableCrafting plugin;
    public static boolean enableDialogsModule;
    public static ArrayList<Player> debugPlayers;
    private static final boolean placeOfWork = true;

    public String getShortName() {
        return "EC";
    }

    public String getNameWithBrackets() {
        return "[ExecutableCrafting]";
    }

    public String getNameDesign() {
        return "&6ExecutableCrafting";
    }

    public String getNameDesignWithBrackets() {
        return "&6[ExecutableCrafting]";
    }

    public String getObjectName() {
        return null;
    }

    public String getObjectNameForPermission(SObject sObject) {
        if (sObject instanceof Recipe) {
            return "recipe";
        }
        if (sObject instanceof RecipeGroup) {
            return "recipeGroup";
        }
        return "recipe";
    }

    public Plugin getPlugin() {
        return plugin;
    }

    public boolean isLotOfWork() {
        return true;
    }

    public int getMaxSObjectsLimit() {
        return 300;
    }

    public Config getPluginConfig() {
        return GeneralConfig.getInstance();
    }

    public void onEnable() {
        plugin = this;
        int pluginId = 25823;
        Metrics metrics = new Metrics(this, pluginId);
        SimplePie customChart = new SimplePie("premium", () -> !this.isLotOfWork() + "");
        metrics.addCustomChart(customChart);
        this.sendPluginName();
        if (!SCore.is1v19Plus()) {
            Utils.sendConsoleMsg((String)"&cThis plugin requires at least 1.19 version of Minecraft.");
            Utils.sendConsoleMsg((String)"&cDisabling plugin...");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        MessageMain.getInstance().loadMessagesOf((Plugin)plugin, MessageInterface.getMessagesEnum((MessageInterface[])Message.values()));
        GeneralConfig.getInstance();
        RecipeGroupLoader.getInstance().load();
        RecipeLoader.getInstance().load();
        RecipeManager.getInstance().registerRecipes();
        RecipeBookManagement.getInstance().loadRecipeBook();
        Objects.requireNonNull(this.getCommand("ec")).setExecutor((CommandExecutor)new CommandClass(this));
        PluginManager pm = Bukkit.getPluginManager();
        pm.registerEvents((Listener)new CraftingTableListener(), (Plugin)this);
        pm.registerEvents((Listener)new FurnaceListener(), (Plugin)this);
        if (enableDialogsModule && SCore.is1v21v7Plus() && SCore.isPaperOrFork()) {
            pm.registerEvents((Listener)new DialogsListener(), (Plugin)this);
        }
        pm.registerEvents((Listener)new EditorInteractionsListener(), (Plugin)this);
        pm.registerEvents((Listener)new OnPlayerJoinListener(), (Plugin)this);
        pm.registerEvents((Listener)new AnvilListener(), (Plugin)this);
        pm.registerEvents((Listener)new RecipeBooksEvents(), (Plugin)this);
        this.sendPluginName();
    }

    public void sendPluginName() {
        if (plugin.isLotOfWork()) {
            Utils.sendConsoleMsg((String)("&7================ " + this.getNameDesign() + " &7================"));
        } else {
            Utils.sendConsoleMsg((String)("&7========&e*&7======== " + this.getNameDesign() + " &7========&e*&7========"));
        }
    }

    public void onReload(boolean fakeBooleanToDistinguishFromTheDefaultMethod) {
        this.sendPluginName();
        this.saveDefaultConfig();
        GeneralConfig.getInstance().reload();
        MessageMain.getInstance().loadMessagesOf((Plugin)plugin, MessageInterface.getMessagesEnum((MessageInterface[])Message.values()));
        RecipeGroupLoader.getInstance().reload();
        RecipeLoader.getInstance().reload();
        RecipeBookManagement.getInstance().loadRecipeBook();
        this.sendPluginName();
    }

    public void onDisable() {
    }

    static {
        enableDialogsModule = false;
        debugPlayers = new ArrayList();
    }
}

