/*
 * Decompiled with CFR 0.152.
 */
package vayk.executablecrafting.recipeBooks.needtorework;

public class WordUtils {
    public static String capitalize(String str) {
        return WordUtils.capitalize(str, null);
    }

    public static String capitalize(String str, char[] delimiters) {
        int delimLen;
        int n = delimLen = delimiters == null ? -1 : delimiters.length;
        if (str != null && str.length() != 0 && delimLen != 0) {
            int strLen = str.length();
            StringBuffer buffer = new StringBuffer(strLen);
            boolean capitalizeNext = true;
            for (int i = 0; i < strLen; ++i) {
                char ch = str.charAt(i);
                if (WordUtils.isDelimiter(ch, delimiters)) {
                    buffer.append(ch);
                    capitalizeNext = true;
                    continue;
                }
                if (capitalizeNext) {
                    buffer.append(Character.toTitleCase(ch));
                    capitalizeNext = false;
                    continue;
                }
                buffer.append(ch);
            }
            return buffer.toString();
        }
        return str;
    }

    public static String capitalizeFully(String str) {
        return WordUtils.capitalizeFully(str, null);
    }

    public static String capitalizeFully(String str, char[] delimiters) {
        int delimLen;
        int n = delimLen = delimiters == null ? -1 : delimiters.length;
        if (str != null && str.length() != 0 && delimLen != 0) {
            str = str.toLowerCase();
            return WordUtils.capitalize(str, delimiters);
        }
        return str;
    }

    public static String uncapitalize(String str) {
        return WordUtils.uncapitalize(str, null);
    }

    public static String uncapitalize(String str, char[] delimiters) {
        int delimLen;
        int n = delimLen = delimiters == null ? -1 : delimiters.length;
        if (str != null && str.length() != 0 && delimLen != 0) {
            int strLen = str.length();
            StringBuffer buffer = new StringBuffer(strLen);
            boolean uncapitalizeNext = true;
            for (int i = 0; i < strLen; ++i) {
                char ch = str.charAt(i);
                if (WordUtils.isDelimiter(ch, delimiters)) {
                    buffer.append(ch);
                    uncapitalizeNext = true;
                    continue;
                }
                if (uncapitalizeNext) {
                    buffer.append(Character.toLowerCase(ch));
                    uncapitalizeNext = false;
                    continue;
                }
                buffer.append(ch);
            }
            return buffer.toString();
        }
        return str;
    }

    public static String swapCase(String str) {
        int strLen;
        if (str != null && (strLen = str.length()) != 0) {
            StringBuffer buffer = new StringBuffer(strLen);
            boolean whitespace = true;
            for (int i = 0; i < strLen; ++i) {
                char ch = str.charAt(i);
                char tmp = Character.isUpperCase(ch) ? Character.toLowerCase(ch) : (Character.isTitleCase(ch) ? Character.toLowerCase(ch) : (Character.isLowerCase(ch) ? (whitespace ? Character.toTitleCase(ch) : Character.toUpperCase(ch)) : ch));
                buffer.append(tmp);
                whitespace = Character.isWhitespace(ch);
            }
            return buffer.toString();
        }
        return str;
    }

    public static String initials(String str) {
        return WordUtils.initials(str, null);
    }

    public static String initials(String str, char[] delimiters) {
        if (str != null && str.length() != 0) {
            if (delimiters != null && delimiters.length == 0) {
                return "";
            }
            int strLen = str.length();
            char[] buf = new char[strLen / 2 + 1];
            int count = 0;
            boolean lastWasGap = true;
            for (int i = 0; i < strLen; ++i) {
                char ch = str.charAt(i);
                if (WordUtils.isDelimiter(ch, delimiters)) {
                    lastWasGap = true;
                    continue;
                }
                if (!lastWasGap) continue;
                buf[count++] = ch;
                lastWasGap = false;
            }
            return new String(buf, 0, count);
        }
        return str;
    }

    private static boolean isDelimiter(char ch, char[] delimiters) {
        if (delimiters == null) {
            return Character.isWhitespace(ch);
        }
        int isize = delimiters.length;
        for (int i = 0; i < isize; ++i) {
            if (ch != delimiters[i]) continue;
            return true;
        }
        return false;
    }
}

