/*
 * Decompiled with CFR 0.152.
 */
package vayk.executablecrafting.events;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.features.custom.itemcheckers.ItemCheckers;
import com.ssomar.score.utils.emums.ShapeType;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import vayk.executablecrafting.customRecipes.RecipeInput;
import vayk.executablecrafting.customRecipes.RecipeManager;
import vayk.executablecrafting.customRecipes.types.RecipeCrafting;

public class CraftingTableListener
implements Listener {
    @EventHandler
    public void onPrepareCraft(PrepareItemCraftEvent event) {
        CraftingInventory inventory = event.getInventory();
        this.prepareCraft(inventory);
    }

    public void prepareCraft(CraftingInventory inventory) {
        ItemStack[] craftingGrid = inventory.getMatrix();
        boolean is2x2Grid = craftingGrid.length == 4;
        RecipeCrafting customCraftingTableRecipe = null;
        ItemStack resultedItemFromCrafting = null;
        for (RecipeCrafting recipe : RecipeManager.getInstance().getCraftingRecipes()) {
            int maxCraft = 1;
            maxCraft = recipe.isValidGrid(craftingGrid, is2x2Grid, true);
            if (maxCraft == 0) continue;
            customCraftingTableRecipe = recipe;
            resultedItemFromCrafting = recipe.getResult(maxCraft);
            break;
        }
        SsomarDev.testMsg((String)("onPrepareCraft customCraftingTableRecipe: " + customCraftingTableRecipe), (boolean)false);
        if (customCraftingTableRecipe == null) {
            return;
        }
        Block block = inventory.getLocation().getBlock();
        if (!customCraftingTableRecipe.checkConditions((OfflinePlayer)((Player)inventory.getHolder()), block)) {
            inventory.setResult(null);
            return;
        }
        ItemStack finalResultedItemFromCrafting = resultedItemFromCrafting;
        SsomarDev.testMsg((String)("onPrepareCraft finalResultedItemFromCrafting: " + finalResultedItemFromCrafting), (boolean)false);
        inventory.setResult(finalResultedItemFromCrafting);
    }

    /*
     * Enabled aggressive block sorting
     */
    @EventHandler(priority=EventPriority.LOWEST)
    public void onInventoryClick(InventoryClickEvent event) {
        ItemStack[] updatedMatrix;
        Inventory topInv = event.getInventory();
        if (!(topInv instanceof CraftingInventory)) {
            return;
        }
        CraftingInventory inventory = (CraftingInventory)topInv;
        if (event.getRawSlot() != 0) {
            return;
        }
        ItemStack resultInSlot = inventory.getResult();
        if (resultInSlot == null || resultInSlot.getType() == Material.AIR) {
            return;
        }
        ItemStack[] craftingGrid = inventory.getMatrix();
        boolean is2x2Grid = craftingGrid.length == 4;
        RecipeCrafting customRecipe = RecipeManager.getInstance().getCraftingRecipe(craftingGrid, is2x2Grid);
        if (customRecipe == null) {
            return;
        }
        boolean isShiftClick = event.isShiftClick();
        SsomarDev.testMsg((String)("onInventoryClick isShiftClick: " + isShiftClick), (boolean)true);
        boolean isShapeless = customRecipe.getTypeOfCraftingTableRecipe().getValue().get() == ShapeType.SHAPELESS;
        int craftedAmount = resultInSlot.getAmount();
        int recipeMultiplier = 1;
        SsomarDev.testMsg((String)("onInventoryClick base craftedAmount: " + craftedAmount), (boolean)true);
        if (isShiftClick) {
            recipeMultiplier = customRecipe.isValidGrid(craftingGrid, craftingGrid.length == 4, true);
            craftedAmount = recipeMultiplier * craftedAmount;
        }
        SsomarDev.testMsg((String)(":D Crafted amount: " + craftedAmount), (boolean)true);
        SsomarDev.testMsg((String)("onInventoryClick recipeMultiplier: " + recipeMultiplier), (boolean)true);
        ItemStack clickedItem = event.getWhoClicked().getItemOnCursor();
        if (!(clickedItem.getType() == Material.AIR || isShiftClick || customRecipe.getCheckers().isSimilar(clickedItem, customRecipe.resultItem()) && clickedItem.getAmount() < 64 && clickedItem.getAmount() + craftedAmount <= 64)) {
            event.setCancelled(true);
            SsomarDev.testMsg((String)"onInventoryClick cancelled because not enough space in cursor or not similar item", (boolean)true);
            return;
        }
        if (isShapeless) {
            RecipeResult recipeResult = this.processShapelessRecipe(craftingGrid, customRecipe, recipeMultiplier);
            if (!recipeResult.success) {
                SsomarDev.testMsg((String)"onInventoryClick cancelled because recipeResult not success", (boolean)true);
                return;
            }
            updatedMatrix = recipeResult.matrix;
        } else {
            updatedMatrix = this.handleShapedCrafting(craftingGrid, customRecipe, recipeMultiplier);
        }
        Player player = (Player)event.getWhoClicked();
        inventory.setMatrix(updatedMatrix);
        inventory.setResult(null);
        ItemStack resultInSlotClone = resultInSlot.clone();
        if (isShiftClick) {
            SsomarDev.testMsg((String)("Shift click crafting >> " + craftedAmount), (boolean)true);
            resultInSlotClone.setAmount(craftedAmount);
            HashMap notGiven = player.getInventory().addItem(new ItemStack[]{resultInSlotClone});
            for (ItemStack item : notGiven.values()) {
                SsomarDev.testMsg((String)("onInventoryClick dropping item: " + item), (boolean)true);
            }
        } else {
            this.addItemToCursor(player, resultInSlotClone);
        }
        SsomarDev.testMsg((String)("Items given " + resultInSlotClone), (boolean)true);
        customRecipe.runCommands(player);
        Runnable run = () -> this.prepareCraft(inventory);
        SCore.schedulerHook.runEntityTask(run, null, (Entity)player, 1L);
    }

    private void addItemToCursor(Player player, ItemStack itemStack) {
        ItemStack itemCursor = player.getItemOnCursor();
        if (itemCursor.getType() == Material.AIR) {
            player.setItemOnCursor(itemStack);
        } else {
            itemStack.setAmount(Math.min(itemCursor.getAmount() + itemStack.getAmount(), 64));
            player.setItemOnCursor(itemStack);
        }
    }

    private ItemStack[] handleShapedCrafting(ItemStack[] craftingGrid, RecipeCrafting customRecipe, int craftedAmount) {
        ItemStack[] itemStackArray;
        ItemStack[] updatedMatrix = new ItemStack[9];
        if (craftingGrid.length == 4) {
            ItemStack[] itemStackArray2 = new ItemStack[4];
            itemStackArray2[0] = customRecipe.getInput1().getValue().orElse(null);
            itemStackArray2[1] = customRecipe.getInput2().getValue().orElse(null);
            itemStackArray2[2] = customRecipe.getInput4().getValue().orElse(null);
            itemStackArray = itemStackArray2;
            itemStackArray2[3] = customRecipe.getInput5().getValue().orElse(null);
        } else {
            ItemStack[] itemStackArray3 = new ItemStack[9];
            itemStackArray3[0] = customRecipe.getInput1().getValue().orElse(null);
            itemStackArray3[1] = customRecipe.getInput2().getValue().orElse(null);
            itemStackArray3[2] = customRecipe.getInput3().getValue().orElse(null);
            itemStackArray3[3] = customRecipe.getInput4().getValue().orElse(null);
            itemStackArray3[4] = customRecipe.getInput5().getValue().orElse(null);
            itemStackArray3[5] = customRecipe.getInput6().getValue().orElse(null);
            itemStackArray3[6] = customRecipe.getInput7().getValue().orElse(null);
            itemStackArray3[7] = customRecipe.getInput8().getValue().orElse(null);
            itemStackArray = itemStackArray3;
            itemStackArray3[8] = customRecipe.getInput9().getValue().orElse(null);
        }
        ItemStack[] idealItems = itemStackArray;
        for (int i = 0; i < idealItems.length; ++i) {
            ItemStack idealItem = idealItems[i];
            ItemStack gridItem = craftingGrid[i];
            if (idealItem == null || idealItem.getType() == Material.AIR) {
                updatedMatrix[i] = gridItem;
                continue;
            }
            if (gridItem == null || gridItem.getType() == Material.AIR) {
                updatedMatrix[i] = null;
                continue;
            }
            int requiredAmount = idealItem.getAmount() * craftedAmount;
            if (gridItem.getAmount() >= requiredAmount) {
                gridItem.setAmount(gridItem.getAmount() - requiredAmount);
                updatedMatrix[i] = gridItem.getAmount() > 0 ? gridItem : null;
                continue;
            }
            updatedMatrix[i] = gridItem;
        }
        return updatedMatrix;
    }

    /*
     * WARNING - void declaration
     */
    private RecipeResult processShapelessRecipe(ItemStack[] craftingGrid, RecipeCrafting recipe, int craftedAmount) {
        void var13_17;
        ItemStack[] originalGrid = (ItemStack[])craftingGrid.clone();
        ItemStack[] updatedGrid = (ItemStack[])craftingGrid.clone();
        HashMap<Integer, ItemStack> hashMapNeededItems = new HashMap<Integer, ItemStack>();
        List<RecipeInput> recipeInputs = recipe.getInputs();
        for (int i = 0; i < 9; ++i) {
            if (recipeInputs.get(i).getItem() == null || recipeInputs.get(i).getItem().getType() == Material.AIR) continue;
            ItemStack item = recipeInputs.get(i).getItem().clone();
            item.setAmount(item.getAmount() * craftedAmount);
            hashMapNeededItems.put(i, item);
        }
        LinkedHashMap hashMapNeededItemsSortedMap = hashMapNeededItems.entrySet().stream().sorted((e1, e2) -> Integer.compare(((ItemStack)e2.getValue()).getAmount(), ((ItemStack)e1.getValue()).getAmount())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        HashMap<Integer, ItemStack> hashMapCraftingGrid = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < craftingGrid.length; ++i) {
            if (craftingGrid[i] == null) continue;
            hashMapCraftingGrid.put(i, craftingGrid[i].clone());
        }
        LinkedHashMap hashMapCraftingGridSortedMap = hashMapCraftingGrid.entrySet().stream().sorted((e1, e2) -> Integer.compare(((ItemStack)e2.getValue()).getAmount(), ((ItemStack)e1.getValue()).getAmount())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        if (hashMapNeededItemsSortedMap.size() != hashMapCraftingGridSortedMap.size()) {
            return new RecipeResult(originalGrid, false);
        }
        HashSet<Integer> usedSlots = new HashSet<Integer>();
        for (Map.Entry entry : hashMapNeededItemsSortedMap.sequencedEntrySet()) {
            ItemStack neededItem = (ItemStack)entry.getValue();
            int bestPosition = -1;
            for (int i = 0; i < craftingGrid.length; ++i) {
                ItemStack gridItem;
                if (usedSlots.contains(i) || (gridItem = (ItemStack)hashMapCraftingGridSortedMap.get(i)) == null || gridItem.getType() == Material.AIR || !recipe.getCheckers().isSimilar(gridItem, neededItem)) continue;
                int neededAmount = neededItem.getAmount();
                int availableAmount = gridItem.getAmount();
                if (bestPosition == -1 && availableAmount >= neededAmount) {
                    bestPosition = i;
                    continue;
                }
                if (bestPosition == -1 || ((ItemStack)hashMapCraftingGridSortedMap.get(i)).getAmount() < ((ItemStack)hashMapCraftingGridSortedMap.get(bestPosition)).getAmount()) continue;
                bestPosition = i;
            }
            if (bestPosition == -1) {
                return new RecipeResult(originalGrid, false);
            }
            usedSlots.add(bestPosition);
            ItemStack gridItem = (ItemStack)hashMapCraftingGridSortedMap.get(bestPosition);
            int neededAmount = neededItem.getAmount();
            int availableAmount = gridItem.getAmount();
            int amountToConsume = Math.min(neededAmount, availableAmount);
            if (amountToConsume < gridItem.getAmount()) {
                ItemStack update = (ItemStack)hashMapCraftingGridSortedMap.get(bestPosition);
                update.setAmount(availableAmount - amountToConsume);
                hashMapCraftingGridSortedMap.put(bestPosition, update);
                continue;
            }
            hashMapCraftingGridSortedMap.remove(bestPosition);
        }
        LinkedHashMap reversedMap = hashMapCraftingGridSortedMap.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        boolean bl = false;
        while (var13_17 < craftingGrid.length) {
            updatedGrid[var13_17] = (ItemStack)reversedMap.get((int)var13_17);
            ++var13_17;
        }
        return new RecipeResult(updatedGrid, true);
    }

    private static class RecipeResult {
        final ItemStack[] matrix;
        final boolean success;

        RecipeResult(ItemStack[] matrix, boolean success) {
            this.matrix = matrix;
            this.success = success;
        }
    }

    public class InputAndCheckers {
        private final ItemStack input;
        private final ItemCheckers checkers;

        public InputAndCheckers(ItemStack input, ItemCheckers checkers) {
            this.input = input;
            this.checkers = checkers;
        }

        @Generated
        public ItemStack getInput() {
            return this.input;
        }

        @Generated
        public ItemCheckers getCheckers() {
            return this.checkers;
        }
    }
}

