/*
 * Decompiled with CFR 0.152.
 */
package vayk.executablecrafting.commands;

import com.ssomar.score.commands.score.CommandsClassAbstract;
import com.ssomar.score.configs.messages.MessageInterface;
import com.ssomar.score.configs.messages.MessageMain;
import com.ssomar.score.editor.SaveSessionPathManager;
import com.ssomar.score.sobject.SObject;
import com.ssomar.score.sobject.menu.NewSObjectsManagerEditor;
import com.ssomar.score.sobject.menu.SObjectsEditorAbstract;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.messages.SendMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;
import vayk.executablecrafting.ExecutableCrafting;
import vayk.executablecrafting.config.messages.Message;
import vayk.executablecrafting.customRecipes.Recipe;
import vayk.executablecrafting.customRecipes.RecipeManager;
import vayk.executablecrafting.customRecipes.RecipesEditor;
import vayk.executablecrafting.customRecipes.types.RecipeCrafting;
import vayk.executablecrafting.recipeBooks.RecipeBookManagement;
import vayk.executablecrafting.recipeGroups.RecipeGroup;
import vayk.executablecrafting.recipeGroups.RecipeGroupManager;
import vayk.executablecrafting.recipeGroups.RecipeGroupsEditor;

public class CommandClass
extends CommandsClassAbstract<ExecutableCrafting> {
    public CommandClass(ExecutableCrafting main) {
        super((SPlugin)main);
        this.addCommand("reload");
        this.addCommand("show");
        this.addCommand("editor");
        this.addCommand("edit");
        this.addCommand("create");
        this.addCommand("delete");
        this.addCommand("groups");
        this.addCommand("groups-create");
        this.addCommand("groups-delete");
        this.addCommand("debug");
        this.addCommand("book");
        this.addCommand("recipe");
    }

    public void runCommand(CommandSender sender, @Nullable Player player, String command, String[] args, String typedCommand) {
        switch (command) {
            case "create": {
                if (player == null) {
                    SendMessage.sendMessageNoPlch((CommandSender)sender, (String)"&cYou must be a player to use this command");
                    return;
                }
                if (args.length >= 1) {
                    String recipe_id = args[0];
                    if (RecipeManager.getInstance().isValidID(recipe_id)) {
                        SendMessage.sendMessageNoPlch((Player)player, (String)"&cThis file already exists");
                        return;
                    }
                    RecipeCrafting i = new RecipeCrafting(args[0], "plugins/ExecutableCrafting/recipes/" + args[0] + ".yml");
                    i.save();
                    RecipeManager.getInstance().addLoadedObject((SObject)i);
                    i.openEditor(player);
                    break;
                }
                SendMessage.sendMessageNoPlch((CommandSender)sender, (String)"&cYou are missing the id name &f/ec create <idname>");
                break;
            }
            case "delete": {
                if (args.length == 2) {
                    if (!args[1].equalsIgnoreCase("confirm")) {
                        this.getSm().sendMessage(sender, "&c" + ((ExecutableCrafting)this.getSPlugin()).getNameWithBrackets() + " &cTo confirm the delete type &6/ec delete {recipeId} confirm");
                        return;
                    }
                    Optional eiOpt = RecipeManager.getInstance().getLoadedObjectWithID(args[0]);
                    if (eiOpt.isPresent()) {
                        RecipeManager.getInstance().deleteObject(args[0]);
                        this.getSm().sendMessage(sender, ((ExecutableCrafting)this.getSPlugin()).getNameDesign() + " &7Recipe &e" + args[0] + " &7deleted");
                        if (player == null) break;
                        NewSObjectsManagerEditor.getInstance().startEditing(player, (SObjectsEditorAbstract)new RecipesEditor());
                        break;
                    }
                    this.getSm().sendMessage(sender, "&c" + ((ExecutableCrafting)this.getSPlugin()).getNameWithBrackets() + " &cRecipe &6" + args[0] + " &cnot found");
                    break;
                }
                this.getSm().sendMessage(sender, "&c" + ((ExecutableCrafting)this.getSPlugin()).getNameWithBrackets() + " &cTo confirm the delete type &6/ec delete {recipeId} confirm");
                break;
            }
            case "groups-create": {
                if (player == null) {
                    SendMessage.sendMessageNoPlch((CommandSender)sender, (String)"&cYou must be a player to use this command");
                    return;
                }
                if (args.length >= 1) {
                    String groupId = args[0];
                    if (RecipeGroupManager.getInstance().isValidID(groupId)) {
                        SendMessage.sendMessageNoPlch((Player)player, (String)"&cThis group ID already exists");
                        return;
                    }
                    RecipeGroup i = new RecipeGroup(args[0], "plugins/ExecutableCrafting/groups/" + args[0] + ".yml");
                    i.save();
                    RecipeGroupManager.getInstance().addLoadedObject((SObject)i);
                    i.openEditor(player);
                    break;
                }
                SendMessage.sendMessageNoPlch((CommandSender)sender, (String)"&cYou are missing the id name &f/ec groups-create <idname>");
                break;
            }
            case "groups-delete": {
                if (args.length == 2) {
                    if (!args[1].equalsIgnoreCase("confirm")) {
                        this.getSm().sendMessage(sender, "&c" + ((ExecutableCrafting)this.getSPlugin()).getNameWithBrackets() + " &cTo confirm the delete type &6/ec groups-delete {groupId} confirm");
                        return;
                    }
                    Optional eiOpt = RecipeGroupManager.getInstance().getLoadedObjectWithID(args[0]);
                    if (eiOpt.isPresent()) {
                        RecipeGroupManager.getInstance().deleteObject(args[0]);
                        this.getSm().sendMessage(sender, ((ExecutableCrafting)this.getSPlugin()).getNameDesign() + " &7Group &e" + args[0] + " &7deleted");
                        if (player == null) break;
                        NewSObjectsManagerEditor.getInstance().startEditing(player, (SObjectsEditorAbstract)new RecipeGroupsEditor());
                        break;
                    }
                    this.getSm().sendMessage(sender, "&c" + ((ExecutableCrafting)this.getSPlugin()).getNameWithBrackets() + " &cGroup &6" + args[0] + " &cnot found");
                    break;
                }
                this.getSm().sendMessage(sender, "&c" + ((ExecutableCrafting)this.getSPlugin()).getNameWithBrackets() + " &cTo confirm the delete type &6/ec groups-delete {groupId} confirm");
                break;
            }
            case "reload": {
                ExecutableCrafting.plugin.onReload(true);
                SendMessage.sendMessageNoPlch((CommandSender)sender, (String)"&aExecutableCrafting reloaded");
                break;
            }
            case "show": 
            case "editor": {
                if (player != null) {
                    NewSObjectsManagerEditor.getInstance().startEditing(player, (SObjectsEditorAbstract)new RecipesEditor());
                    break;
                }
                SendMessage.sendMessageNoPlch((CommandSender)sender, (String)"You must be a player to use this command");
                break;
            }
            case "edit": {
                if (player == null) break;
                SaveSessionPathManager.getInstance().clearPlayerSessionPath(player);
                if (args.length > 0) {
                    try {
                        Optional ec = RecipeManager.getInstance().getLoadedObjectWithID(args[0]);
                        if (ec.isPresent()) {
                            ((Recipe)((Object)ec.get())).openEditor(player);
                            break;
                        }
                        this.getSm().sendMessage(sender, "&c" + ((ExecutableCrafting)this.getSPlugin()).getNameWithBrackets() + " &cThis Recipe &6" + args[0] + " &cdoesn't exist");
                    }
                    catch (NullPointerException e) {
                        this.getSm().sendMessage(sender, "&c" + ((ExecutableCrafting)this.getSPlugin()).getNameWithBrackets() + " &cError > Invalid recipeID &6/ec edit {recipeID}");
                    }
                    break;
                }
                this.getSm().sendMessage(sender, "&c" + ((ExecutableCrafting)this.getSPlugin()).getNameWithBrackets() + " &cError > Invalid recipeID &6/ec edit {recipeID}");
                break;
            }
            case "groups": {
                if (player != null) {
                    NewSObjectsManagerEditor.getInstance().startEditing(player, (SObjectsEditorAbstract)new RecipeGroupsEditor());
                    break;
                }
                SendMessage.sendMessageNoPlch((CommandSender)sender, (String)"You must be a player to use this command");
                break;
            }
            case "debug": {
                if (ExecutableCrafting.debugPlayers.contains(player)) {
                    ExecutableCrafting.debugPlayers.remove(player);
                    SendMessage.sendMessageNoPlch((Player)player, (String)MessageMain.getInstance().getMessage((Plugin)ExecutableCrafting.plugin, (MessageInterface)Message.DEBUG_DEACTIVATED));
                    break;
                }
                ExecutableCrafting.debugPlayers.add(player);
                SendMessage.sendMessageNoPlch((Player)player, (String)MessageMain.getInstance().getMessage((Plugin)ExecutableCrafting.plugin, (MessageInterface)Message.DEBUG_ACTIVATED));
                break;
            }
            case "book": {
                if (args.length < 2) {
                    SendMessage.sendMessageNoPlch((CommandSender)sender, (String)"Usage: /ec book <player> <book>");
                    break;
                }
                Player target = Bukkit.getPlayer((String)args[0]);
                String book = args[1];
                RecipeBookManagement.getInstance().openRecipeBook(target, book, "1");
                break;
            }
            case "recipe": {
                if (args.length < 2) {
                    SendMessage.sendMessageNoPlch((CommandSender)sender, (String)"Usage: /ec recipe <player> <recipe_id>");
                    break;
                }
                Player target = Bukkit.getPlayer((String)args[0]);
                String recipe = args[1];
                RecipeBookManagement.openRecipeFromRecipeBook(target, UUID.randomUUID().toString(), recipe);
            }
        }
    }

    public List<String> getOnTabCompleteArguments(CommandSender commandSender, Command command, String label, String[] args) {
        ArrayList<String> arguments = new ArrayList<String>();
        if (args.length >= 2) {
            switch (args[0]) {
                case "create": {
                    arguments.add("id");
                    return arguments;
                }
                case "edit": {
                    arguments.addAll(RecipeManager.getInstance().getLoadedObjectsIDs());
                    return arguments;
                }
                case "book": {
                    if (args.length == 3) {
                        arguments.addAll(RecipeBookManagement.recipeBooks.keySet());
                    } else if (args.length == 2) {
                        if (commandSender instanceof Player) {
                            arguments.add(commandSender.getName());
                        }
                        Bukkit.getOnlinePlayers().forEach(player -> {
                            if (!player.getName().equals(commandSender.getName())) {
                                arguments.add(player.getName());
                            }
                        });
                    }
                    return arguments;
                }
            }
        }
        return new ArrayList<String>();
    }
}

