/*
 * Decompiled with CFR 0.152.
 */
package vayk.executablecrafting.config;

import com.ssomar.score.config.Config;
import com.ssomar.score.features.custom.itemcheckers.ItemCheckerEnum;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventPriority;
import org.bukkit.plugin.Plugin;
import vayk.executablecrafting.ExecutableCrafting;

public class GeneralConfig
extends Config {
    private static GeneralConfig instance;
    private Map<ItemCheckerEnum, Boolean> itemCheckersDefaultValues;
    private EventPriority configEventPriority;

    public GeneralConfig() {
        super("config.yml");
        super.setup((Plugin)ExecutableCrafting.plugin);
    }

    public boolean converter(FileConfiguration fileConfiguration) {
        return false;
    }

    public void load() {
        this.loadBooleanSetting(Setting.exactItemAmount.name(), false);
        this.loadBooleanSetting(Setting.castResultAsMaxAmount.name(), false);
        this.loadBooleanSetting(Setting.recipeBookNameOfID.name(), true);
        this.loadBooleanSetting(Setting.recipesInternal.name(), true);
        this.loadBooleanSetting(Setting.recipesInternal_ShiftClickToRecipesInternal.name(), true);
        this.loadBooleanSetting(Setting.recipesInternal_checkRecipesFromInventory.name(), false);
        this.loadBooleanSetting(Setting.playerCanOpenNotMeetingCondition.name(), false);
        this.loadBooleanSetting(Setting.plchdShowAll.name(), true);
        switch (this.config.getString("eventsPriority", "NORMAL")) {
            case "HIGH": {
                this.configEventPriority = EventPriority.HIGH;
                break;
            }
            case "HIGHEST": {
                this.configEventPriority = EventPriority.HIGHEST;
                break;
            }
            default: {
                this.configEventPriority = EventPriority.NORMAL;
            }
        }
        this.itemCheckersDefaultValues = new HashMap<ItemCheckerEnum, Boolean>();
        for (ItemCheckerEnum itemChecker : ItemCheckerEnum.values()) {
            if (this.config.contains(itemChecker.getFeatureSetting().getName())) {
                this.itemCheckersDefaultValues.put(itemChecker, this.config.getBoolean(itemChecker.getFeatureSetting().getName(), false));
                continue;
            }
            this.itemCheckersDefaultValues.put(itemChecker, this.config.getBoolean("itemCheckers." + itemChecker.getFeatureSetting().getName(), false));
        }
    }

    public static GeneralConfig getInstance() {
        if (instance == null) {
            instance = new GeneralConfig();
        }
        return instance;
    }

    public void reload() {
        instance = new GeneralConfig();
    }

    @Generated
    public Map<ItemCheckerEnum, Boolean> getItemCheckersDefaultValues() {
        return this.itemCheckersDefaultValues;
    }

    @Generated
    public EventPriority getConfigEventPriority() {
        return this.configEventPriority;
    }

    @Generated
    public void setItemCheckersDefaultValues(Map<ItemCheckerEnum, Boolean> itemCheckersDefaultValues) {
        this.itemCheckersDefaultValues = itemCheckersDefaultValues;
    }

    @Generated
    public void setConfigEventPriority(EventPriority configEventPriority) {
        this.configEventPriority = configEventPriority;
    }

    public static enum Setting {
        exactItemAmount,
        castResultAsMaxAmount,
        recipeBookNameOfID,
        recipesInternal,
        recipesInternal_ShiftClickToRecipesInternal,
        recipesInternal_checkRecipesFromInventory,
        playerCanOpenNotMeetingCondition,
        plchdShowAll;

    }
}

