/*
 * Decompiled with CFR 0.152.
 */
package vayk.executablecrafting.customRecipes;

import com.ssomar.score.SsomarDev;
import com.ssomar.score.commands.runnable.ActionInfo;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.custom.commands.player.PlayerCommandsFeature;
import com.ssomar.score.features.custom.conditions.block.parent.BlockConditionsFeature;
import com.ssomar.score.features.custom.conditions.placeholders.group.PlaceholderConditionGroupFeature;
import com.ssomar.score.features.custom.conditions.player.parent.PlayerConditionsFeature;
import com.ssomar.score.features.custom.itemcheckers.ItemCheckerType;
import com.ssomar.score.features.custom.itemcheckers.ItemCheckers;
import com.ssomar.score.features.types.ItemStackFeature;
import com.ssomar.score.features.types.RecipeTypeFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.sobject.SObjectWithFileEditable;
import com.ssomar.score.sobject.SObjectWithFileLoader;
import com.ssomar.score.sobject.menu.NewSObjectsManagerEditor;
import com.ssomar.score.sobject.menu.SObjectsEditorAbstract;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.emums.RecipeType;
import com.ssomar.score.utils.messages.SendMessage;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vayk.executablecrafting.ExecutableCrafting;
import vayk.executablecrafting.config.GeneralConfig;
import vayk.executablecrafting.customRecipes.RecipeCraftResult;
import vayk.executablecrafting.customRecipes.RecipeEditor;
import vayk.executablecrafting.customRecipes.RecipeEditorManager;
import vayk.executablecrafting.customRecipes.RecipeInput;
import vayk.executablecrafting.customRecipes.RecipeLoader;
import vayk.executablecrafting.customRecipes.RecipesEditor;
import vayk.executablecrafting.customRecipes.types.RecipeAnvil;
import vayk.executablecrafting.customRecipes.types.RecipeCrafting;
import vayk.executablecrafting.customRecipes.types.RecipeFurnace;
import vayk.executablecrafting.recipeGroups.RecipeGroup;
import vayk.executablecrafting.recipeGroups.RecipeGroupManager;

public abstract class Recipe
extends SObjectWithFileEditable<Recipe, RecipeEditor, RecipeEditorManager> {
    private RecipeTypeFeature type;
    private ItemStackFeature result;
    private PlayerConditionsFeature playerConditions;
    private BlockConditionsFeature blockConditions;
    private PlaceholderConditionGroupFeature placeholderConditions;
    private PlayerCommandsFeature commands;
    private ItemCheckers checkers;

    public Recipe(FeatureParentInterface parent, String id, String path) {
        super((SPlugin)ExecutableCrafting.plugin, id, parent, (FeatureSettingsInterface)FeatureSettingsSCore.RECIPE, path, (SObjectWithFileLoader)RecipeLoader.getInstance());
        this.reset();
    }

    public Recipe(String id, String path) {
        super((SPlugin)ExecutableCrafting.plugin, id, (FeatureSettingsInterface)FeatureSettingsSCore.RECIPE, path, (SObjectWithFileLoader)RecipeLoader.getInstance());
        this.reset();
    }

    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        features.add((FeatureInterface)this.type);
        features.add((FeatureInterface)this.playerConditions);
        features.add((FeatureInterface)this.blockConditions);
        features.add((FeatureInterface)this.placeholderConditions);
        features.add((FeatureInterface)this.commands);
        features.add((FeatureInterface)this.checkers);
        features.add((FeatureInterface)this.result);
        return features;
    }

    public Map<FeatureInterface, Integer> getFeaturesMappingEditor() {
        HashMap<FeatureInterface, Integer> features = new HashMap<FeatureInterface, Integer>();
        features.put((FeatureInterface)this.type, 0);
        features.put((FeatureInterface)this.playerConditions, 3);
        features.put((FeatureInterface)this.blockConditions, 4);
        features.put((FeatureInterface)this.placeholderConditions, 5);
        features.put((FeatureInterface)this.commands, 6);
        features.put((FeatureInterface)this.checkers, 7);
        features.put((FeatureInterface)this.result, 33);
        return features;
    }

    public String getParentInfo() {
        return "(Recipe: " + this.getId() + ")";
    }

    public void reload() {
        if (this.getParent() instanceof Recipe) {
            Recipe recipe = (Recipe)this.getParent();
            recipe.setType(this.type);
            recipe.setResult(this.result);
            recipe.setPlayerConditions(this.playerConditions);
            recipe.setBlockConditions(this.blockConditions);
            recipe.setPlaceholderConditions(this.placeholderConditions);
            recipe.setCommands(this.commands);
            recipe.setCheckers(this.checkers);
        }
    }

    public void openEditor(@NotNull Player player) {
        SsomarDev.testMsg((String)("Opening editor for recipe " + ((Object)((Object)this)).hashCode()), (boolean)true);
        RecipeEditorManager.getInstance().startEditing(player, (FeatureParentInterface)this);
    }

    public void openBackEditor(@NotNull Player player) {
        NewSObjectsManagerEditor.getInstance().startEditing(player, (SObjectsEditorAbstract)new RecipesEditor());
    }

    public List<String> load(SPlugin sPlugin, ConfigurationSection configurationSection, boolean isPremium) {
        ArrayList<String> errors = new ArrayList<String>();
        for (FeatureInterface feature : this.getFeatures()) {
            errors.addAll(feature.load(sPlugin, configurationSection, isPremium));
        }
        return errors;
    }

    public void save(ConfigurationSection configurationSection) {
        for (String key : configurationSection.getKeys(false)) {
            configurationSection.set(key, null);
        }
        SsomarDev.testMsg((String)("Saving recipe " + this.getId()), (boolean)true);
        for (FeatureInterface feature : this.getFeatures()) {
            if (feature instanceof ItemStackFeature) {
                SsomarDev.testMsg((String)("Saving feature " + feature.getName() + " with value " + ((ItemStackFeature)feature).getItemsStack()), (boolean)true);
            }
            feature.save(configurationSection);
        }
        configurationSection.set("config_update", (Object)(!ExecutableCrafting.plugin.isLotOfWork() ? 1 : 0));
    }

    public Recipe getValue() {
        return this;
    }

    public FeatureInterface initItemParentEditor(GUI gui, int i) {
        return null;
    }

    public void updateItemParentEditor(GUI gui) {
    }

    public void reset() {
        this.type = new RecipeTypeFeature((FeatureParentInterface)this, Optional.of(RecipeType.CRAFTING), (FeatureSettingsInterface)FeatureSettingsSCore.recipeType);
        this.result = new ItemStackFeature((FeatureParentInterface)this, Optional.of(new ItemStack(Material.EMERALD)), (FeatureSettingsInterface)FeatureSettingsSCore.result);
        this.playerConditions = new PlayerConditionsFeature((FeatureParentInterface)this, (FeatureSettingsInterface)FeatureSettingsSCore.playerConditions);
        this.blockConditions = new BlockConditionsFeature((FeatureParentInterface)this, (FeatureSettingsInterface)FeatureSettingsSCore.blockConditions);
        this.placeholderConditions = new PlaceholderConditionGroupFeature((FeatureParentInterface)this, (FeatureSettingsInterface)FeatureSettingsSCore.placeholdersConditions);
        this.commands = new PlayerCommandsFeature((FeatureParentInterface)this, (FeatureSettingsInterface)FeatureSettingsSCore.playerCommands);
        this.checkers = new ItemCheckers((FeatureParentInterface)this, ItemCheckerType.ITEM_MUST_BE_EXACTLY_THE_SAME, GeneralConfig.getInstance().getItemCheckersDefaultValues(), (FeatureSettingsInterface)FeatureSettingsSCore.itemCheckers);
    }

    public ItemStack getIconItem() {
        return this.result.getItemsStack();
    }

    public boolean checkConditions(@Nullable OfflinePlayer player, @Nullable Block block) {
        Player onlinePlayer = null;
        if (player != null && player.isOnline()) {
            onlinePlayer = player.getPlayer();
        }
        List<RecipeGroup> recipeGroups = RecipeGroupManager.getInstance().getRecipeGroupsAssociatedToRecipe(this.getId());
        for (RecipeGroup recipeGroup : recipeGroups) {
            if (recipeGroup.checkConditions(player, block)) continue;
            return false;
        }
        if (onlinePlayer != null && !this.getPlayerConditions().verifConditions(onlinePlayer, new ArrayList(), new StringPlaceholder().setPlayerPlcHldr(player.getUniqueId()))) {
            return false;
        }
        if (block != null && !this.getBlockConditions().verifConditions(block, Optional.ofNullable(onlinePlayer), new SendMessage(), null)) {
            return false;
        }
        return this.getPlaceholderConditions().verifConditions(player, new ArrayList());
    }

    public FeatureParentInterface cloneParent(FeatureParentInterface parentOfTheParent) {
        return super.cloneParent(parentOfTheParent);
    }

    public void runCommands(Player player) {
        List<RecipeGroup> recipeGroups = RecipeGroupManager.getInstance().getRecipeGroupsAssociatedToRecipe(this.getId());
        for (RecipeGroup recipeGroup : recipeGroups) {
            recipeGroup.runCommands(player);
        }
        StringPlaceholder stringPlaceholder = new StringPlaceholder();
        stringPlaceholder.setPlayerPlcHldr(player.getUniqueId());
        ActionInfo actionInfo = new ActionInfo("", stringPlaceholder);
        actionInfo.setReceiverUUID(player.getUniqueId());
        this.commands.runCommands(actionInfo, "");
    }

    public Recipe convertTo(RecipeType recipeType) {
        Recipe newRecipe;
        if (recipeType.equals((Object)RecipeType.CRAFTING) && !(this instanceof RecipeCrafting)) {
            newRecipe = new RecipeCrafting((FeatureParentInterface)this, this.getId(), this.getPath());
        } else if (recipeType.equals((Object)RecipeType.ANVIL) && !(this instanceof RecipeAnvil)) {
            newRecipe = new RecipeAnvil((FeatureParentInterface)this, this.getId(), this.getPath());
        } else if (recipeType.equals((Object)RecipeType.FURNACE) && !(this instanceof RecipeFurnace)) {
            newRecipe = new RecipeFurnace((FeatureParentInterface)this, this.getId(), this.getPath());
        } else {
            return this;
        }
        newRecipe.setType(this.type);
        newRecipe.setResult(this.result);
        newRecipe.setPlayerConditions(this.playerConditions);
        newRecipe.setBlockConditions(this.blockConditions);
        newRecipe.setPlaceholderConditions(this.placeholderConditions);
        newRecipe.setCommands(this.commands);
        newRecipe.setCheckers(this.checkers);
        return newRecipe;
    }

    public ItemStack resultItem() {
        return ((ItemStack)this.result.getValue().get()).clone();
    }

    public boolean verifyItemsSimilarity(RecipeInput input, ItemStack item) {
        List<RecipeGroup> recipeGroups = RecipeGroupManager.getInstance().getRecipeGroupsAssociatedToRecipe(this.getId());
        for (RecipeGroup recipeGroup : recipeGroups) {
            if (recipeGroup.verifyItemsSimilarity(input.getItem(), item)) continue;
            return false;
        }
        return this.checkers.isSimilar(input.getItem(), item) && (input.getItemCheckers() == null || input.getItemCheckers().isSimilar(input.getItem(), item));
    }

    public abstract List<RecipeInput> getInputs();

    public RecipeCraftResult getMaxCraftAmountBy(Player player, int maxAmount) {
        ItemStack[] contents;
        RecipeCraftResult result = new RecipeCraftResult();
        PlayerInventory inventory = player.getInventory();
        HashMap<Integer, Integer> itemCounts = new HashMap<Integer, Integer>();
        HashMap<ItemStack, Integer> itemConsumed = new HashMap<ItemStack, Integer>();
        int slot = 0;
        for (ItemStack item : contents = inventory.getContents()) {
            if (item != null && !item.getType().isAir()) {
                itemCounts.put(slot, item.getAmount());
            }
            ++slot;
        }
        int maxCraftAmount = 0;
        boolean oneInputFound = false;
        do {
            for (RecipeInput input : this.getInputs()) {
                ItemStack item = input.getItem();
                if (item == null || item.getType().isAir()) continue;
                oneInputFound = true;
                int slotIndex = 0;
                boolean found = false;
                for (ItemStack content : contents) {
                    if (content != null && !content.getType().isAir() && this.verifyItemsSimilarity(input, content) && itemCounts.get(slotIndex) != null && (Integer)itemCounts.get(slotIndex) >= item.getAmount()) {
                        itemCounts.put(slotIndex, (Integer)itemCounts.get(slotIndex) - item.getAmount());
                        itemConsumed.put(content, itemConsumed.getOrDefault(content, 0) + item.getAmount());
                        SsomarDev.testMsg((String)("Found item " + item.getType() + " in slot " + slotIndex + " with remaining count " + itemCounts.get(slotIndex)), (boolean)true);
                        found = true;
                    }
                    ++slotIndex;
                }
                if (found) continue;
                result.setAmount(maxCraftAmount);
                result.setItems(itemConsumed);
                return result;
            }
            if (!oneInputFound) {
                SsomarDev.testMsg((String)("No input found for recipe " + this.getId()), (boolean)true);
                result.setValid(false);
                return result;
            }
            result.setValid(true);
        } while (++maxCraftAmount < maxAmount);
        SsomarDev.testMsg((String)("Max craft amount for recipe " + this.getId() + " is " + maxCraftAmount), (boolean)true);
        result.setAmount(maxCraftAmount);
        result.setItems(itemConsumed);
        return result;
    }

    @Generated
    public RecipeTypeFeature getType() {
        return this.type;
    }

    @Generated
    public ItemStackFeature getResult() {
        return this.result;
    }

    @Generated
    public PlayerConditionsFeature getPlayerConditions() {
        return this.playerConditions;
    }

    @Generated
    public BlockConditionsFeature getBlockConditions() {
        return this.blockConditions;
    }

    @Generated
    public PlaceholderConditionGroupFeature getPlaceholderConditions() {
        return this.placeholderConditions;
    }

    @Generated
    public PlayerCommandsFeature getCommands() {
        return this.commands;
    }

    @Generated
    public ItemCheckers getCheckers() {
        return this.checkers;
    }

    @Generated
    public void setType(RecipeTypeFeature type) {
        this.type = type;
    }

    @Generated
    public void setResult(ItemStackFeature result) {
        this.result = result;
    }

    @Generated
    public void setPlayerConditions(PlayerConditionsFeature playerConditions) {
        this.playerConditions = playerConditions;
    }

    @Generated
    public void setBlockConditions(BlockConditionsFeature blockConditions) {
        this.blockConditions = blockConditions;
    }

    @Generated
    public void setPlaceholderConditions(PlaceholderConditionGroupFeature placeholderConditions) {
        this.placeholderConditions = placeholderConditions;
    }

    @Generated
    public void setCommands(PlayerCommandsFeature commands) {
        this.commands = commands;
    }

    @Generated
    public void setCheckers(ItemCheckers checkers) {
        this.checkers = checkers;
    }
}

