/*
 * Decompiled with CFR 0.152.
 */
package vayk.executablecrafting.events;

import com.ssomar.executableblocks.api.ExecutableBlocksAPI;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.api.executableblocks.config.placed.ExecutableBlockPlacedInterface;
import com.ssomar.score.usedapi.Dependency;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.Furnace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.inventory.FurnaceStartSmeltEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;
import vayk.executablecrafting.customRecipes.RecipeManager;
import vayk.executablecrafting.customRecipes.types.RecipeFurnace;

public class FurnaceListener
implements Listener {
    public static final boolean DEBUG = true;

    @Nullable
    public OfflinePlayer getSupposedOwnerOf(Block block) {
        if (Dependency.EXECUTABLE_BLOCKS.isEnabled() && ExecutableBlocksAPI.getExecutableBlocksPlacedManager().getExecutableBlockPlaced(block).isPresent()) {
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)((ExecutableBlockPlacedInterface)ExecutableBlocksAPI.getExecutableBlocksPlacedManager().getExecutableBlockPlaced(block).get()).getInternalData().getOwnerUUID());
            return player;
        }
        return null;
    }

    @EventHandler
    public void onBurnEvent(FurnaceBurnEvent event) {
        ItemStack source = ((Furnace)event.getBlock().getState()).getInventory().getSmelting();
        if (event.getBurnTime() <= 0) {
            return;
        }
        RecipeFurnace recipe = RecipeManager.getInstance().getFurnaceRecipe(source);
        if (recipe == null) {
            SsomarDev.testMsg((String)"FurnaceBurnEvent >> Recipe is null", (boolean)true);
            return;
        }
        SsomarDev.testMsg((String)("FurnaceBurnEvent >> " + recipe.getId()), (boolean)true);
        Block block = event.getBlock();
        OfflinePlayer offlinePlayer = this.getSupposedOwnerOf(block);
        if (!recipe.checkConditions(offlinePlayer, block)) {
            SsomarDev.testMsg((String)"FurnaceBurnEvent >> Recipe conditions are not met", (boolean)true);
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onFurnaceSmelt(FurnaceSmeltEvent event) {
        ItemStack source = event.getSource();
        RecipeFurnace recipe = RecipeManager.getInstance().getFurnaceRecipe(source);
        if (recipe == null) {
            SsomarDev.testMsg((String)"FurnaceSmeltEvent >> Recipe is null", (boolean)true);
            return;
        }
        SsomarDev.testMsg((String)("FurnaceSmeltEvent >> " + recipe.getId()), (boolean)true);
        Block block = event.getBlock();
        OfflinePlayer offlinePlayer = this.getSupposedOwnerOf(block);
        if (!recipe.checkConditions(offlinePlayer, block)) {
            SsomarDev.testMsg((String)"FurnaceSmeltEvent >> Recipe conditions are not met", (boolean)true);
            event.setCancelled(true);
        } else if (offlinePlayer != null && offlinePlayer.isOnline()) {
            recipe.runCommands(offlinePlayer.getPlayer());
        }
    }

    @EventHandler
    public void onFurnaceSmelt(FurnaceStartSmeltEvent event) {
        NamespacedKey key = event.getRecipe().getKey();
        ItemStack source = event.getSource();
        SsomarDev.testMsg((String)("FurnaceStartSmeltEvent >> Source: " + source + " key >> " + key), (boolean)true);
        RecipeFurnace recipe = RecipeManager.getInstance().getFurnaceRecipeWithKey(key);
        if (recipe == null) {
            SsomarDev.testMsg((String)"FurnaceStartSmeltEvent >> Recipe is null", (boolean)true);
            return;
        }
        if (!recipe.isInputEqualsTo(source)) {
            SsomarDev.testMsg((String)"FurnaceStartSmeltEvent >> Recipe input does not match source", (boolean)true);
            event.setTotalCookTime(Integer.MAX_VALUE);
            return;
        }
        SsomarDev.testMsg((String)("FurnaceStartSmeltEvent >> " + recipe.getId()), (boolean)true);
        Block block = event.getBlock();
        OfflinePlayer offlinePlayer = this.getSupposedOwnerOf(block);
        if (!recipe.checkConditions(offlinePlayer, block)) {
            SsomarDev.testMsg((String)"FurnaceStartSmeltEvent >> Recipe conditions are not met", (boolean)true);
            event.setTotalCookTime(Integer.MAX_VALUE);
        }
    }
}

