/*
 * Decompiled with CFR 0.152.
 */
package vayk.executablecrafting.recipeBooks;

import com.ssomar.score.SCore;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import com.ssomar.score.utils.strings.StringConverter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import vayk.executablecrafting.ExecutableCrafting;
import vayk.executablecrafting.recipeBooks.WordUtils;

public class ItemBuilder {
    private final ItemStack item;

    public ItemBuilder(Material material) {
        this.item = new ItemStack(material);
    }

    public ItemBuilder(ItemStack item) {
        this.item = item.clone();
    }

    public ItemBuilder setName(String name) {
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null && name != null) {
            name = "&e&l" + name;
            name = StringConverter.coloredString((String)name);
            meta.setDisplayName(name);
            this.item.setItemMeta(meta);
        }
        return this;
    }

    public ItemBuilder setMaterial(Material material) {
        this.item.setType(material);
        return this;
    }

    public ItemBuilder resetLore() {
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            meta.setLore(new ArrayList());
            this.item.setItemMeta(meta);
        }
        return this;
    }

    public ItemBuilder setLore(String ... lore) {
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            for (int i = 0; i < lore.length; ++i) {
                lore[i] = lore[i].replace(":", "&r&7:");
                lore[i] = StringConverter.coloredString((String)("&e" + lore[i]));
            }
            meta.setLore(Arrays.asList(lore));
            this.item.setItemMeta(meta);
        }
        return this;
    }

    public ItemBuilder setLore(List<String> lore) {
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            ArrayList<String> coloredLore = new ArrayList<String>();
            for (String line : lore) {
                line = line.replace(":", "&r&7:");
                coloredLore.add(StringConverter.coloredString((String)("&e" + line)));
            }
            meta.setLore(coloredLore);
            this.item.setItemMeta(meta);
        }
        return this;
    }

    public ItemBuilder addLore(String ... lore) {
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            List currentLore = meta.getLore() != null ? meta.getLore() : new ArrayList();
            for (String line : lore) {
                currentLore.add(StringConverter.coloredString((String)line));
            }
            meta.setLore(currentLore);
            this.item.setItemMeta(meta);
        }
        return this;
    }

    public ItemBuilder addPapiLore(Player player, List<String> lore) {
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            List currentLore = meta.getLore() != null ? meta.getLore() : new ArrayList();
            for (String line : lore) {
                currentLore.add(StringPlaceholder.replacePlaceholderOfPAPI((String)line, (UUID)player.getUniqueId()));
            }
            meta.setLore(currentLore);
            this.item.setItemMeta(meta);
        }
        return this;
    }

    public ItemBuilder addItemFlag(ItemFlag ... flags) {
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            meta.addItemFlags(flags);
            this.item.setItemMeta(meta);
        }
        return this;
    }

    public ItemBuilder setInvisible() {
        if (SCore.is1v20Plus()) {
            try {
                ItemMeta meta = this.item.getItemMeta();
                if (meta != null) {
                    Method setHideTooltip = meta.getClass().getMethod("setHideTooltip", Boolean.TYPE);
                    setHideTooltip.setAccessible(true);
                    setHideTooltip.invoke((Object)meta, true);
                    this.item.setItemMeta(meta);
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException meta) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this;
    }

    public ItemBuilder setCustomModelData(Integer cmd) {
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null && cmd != null) {
            meta.setCustomModelData(cmd);
            this.item.setItemMeta(meta);
        }
        return this;
    }

    public ItemBuilder setEnchanted(boolean enchanted) {
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            if (enchanted) {
                meta.addEnchant(Enchantment.FIRE_ASPECT, 1, true);
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            } else {
                meta.getEnchants().keySet().forEach(arg_0 -> ((ItemMeta)meta).removeEnchant(arg_0));
                meta.removeItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            this.item.setItemMeta(meta);
        }
        return this;
    }

    public ItemBuilder addPublicBukkit(String key, String id) {
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            PersistentDataContainer container = meta.getPersistentDataContainer();
            container.set(new NamespacedKey((Plugin)ExecutableCrafting.plugin, key), PersistentDataType.STRING, (Object)id);
            this.item.setItemMeta(meta);
        }
        return this;
    }

    public ItemBuilder setPlayerHead(String textureValue) {
        if (textureValue == null || textureValue.isEmpty()) {
            return this;
        }
        if (this.item.getType() != Material.PLAYER_HEAD) {
            return this;
        }
        return new ItemBuilder(this.item);
    }

    public ItemStack build() {
        return this.item;
    }

    public static String returnItemName(ItemStack item) {
        return WordUtils.capitalize(item.getType().name().toLowerCase().replace("_", " "), new char[]{' '});
    }

    public static boolean hasPublicBukkit(ItemStack item, String key, String id) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        NamespacedKey namespacedKey = new NamespacedKey((Plugin)ExecutableCrafting.plugin, key);
        String storedId = (String)container.get(namespacedKey, PersistentDataType.STRING);
        return id.equals(storedId);
    }

    public static String getPublicBukkit(ItemStack item, String key) {
        if (item == null || !item.hasItemMeta()) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        NamespacedKey namespacedKey = new NamespacedKey((Plugin)ExecutableCrafting.plugin, key);
        return (String)container.get(namespacedKey, PersistentDataType.STRING);
    }
}

